/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.io.Serializable;
import java.util.Arrays;

public final class NamedObjectKey
implements Serializable {
    private static final long serialVersionUID = -5008609072012459037L;
    private final String[] key;

    public NamedObjectKey(String ... key) {
        this.key = key == null || key.length == 0 ? new String[0] : Arrays.copyOf(key, key.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NamedObjectKey)) {
            return false;
        }
        NamedObjectKey other = (NamedObjectKey)obj;
        return Arrays.equals(this.key, other.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        return "{\"key\": \"" + String.join((CharSequence)"/", this.key) + "\"}";
    }

    public NamedObjectKey with(String name) {
        int currentLength = this.key.length;
        String[] newKey = Arrays.copyOf(this.key, currentLength + 1);
        newKey[currentLength] = name;
        return new NamedObjectKey(newKey);
    }
}

