/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder<K, V> {
    private final Map<K, V> map;

    public MapBuilder() {
        this(false);
    }

    public MapBuilder(K key, V value) {
        this(false);
        this.append(key, value);
    }

    public MapBuilder(boolean sortedMap, K key, V value) {
        this(sortedMap);
        this.append(key, value);
    }

    public MapBuilder(int size, float factor) {
        this.map = new HashMap(size, factor);
    }

    public MapBuilder(boolean sortedMap) {
        this.map = sortedMap ? new LinkedHashMap() : new HashMap();
    }

    public MapBuilder<K, V> append(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> appendIf(K key, V value, boolean condition) {
        if (condition) {
            this.append(key, value);
        }
        return this;
    }

    public MapBuilder<K, V> appendIfNotNull(K key, V value) {
        if (value != null) {
            this.append(key, value);
        }
        return this;
    }

    public MapBuilder<K, V> appendIfTrue(K key, V value) {
        if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
            this.append(key, value);
        }
        return this;
    }

    public int size() {
        return this.map.size();
    }

    public Map<K, V> build() {
        return this.map;
    }
}

