/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.backgroundrunner;

import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingRunnable;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class BackgroundRunner<E> {
    private final Supplier<E> task;
    private final Consumer<E> result;
    private final Consumer<Exception> exceptionConsumer;
    boolean triggeredExceptionInSupplier;
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private E computation;
    private Future<E> future;

    public BackgroundRunner(ThrowingSupplier<E> task) {
        this(task, null, null);
    }

    public BackgroundRunner(ThrowingSupplier<E> task, ThrowingConsumer<E> result) {
        this(task, result, null);
    }

    public BackgroundRunner(ThrowingRunnable runnable) {
        this(() -> {
            runnable.run();
            return null;
        });
    }

    public BackgroundRunner(ThrowingRunnable runnable, ThrowingConsumer<Exception> exceptionConsumer) {
        this(() -> {
            runnable.run();
            return null;
        }, null, exceptionConsumer);
    }

    public BackgroundRunner(ThrowingRunnable runnable, ThrowingRunnable callback, ThrowingConsumer<Exception> exceptionConsumer) {
        this(() -> {
            runnable.run();
            return null;
        }, e -> callback.run(), exceptionConsumer);
    }

    public BackgroundRunner(ThrowingSupplier<E> task, ThrowingConsumer<E> result, ThrowingConsumer<Exception> exceptionConsumer) {
        this.task = task;
        this.result = result;
        this.exceptionConsumer = exceptionConsumer;
    }

    public boolean cancel() {
        if (this.future != null) {
            try {
                return this.future.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void execute() {
        this.future = EXECUTOR.submit(this::doInBackground);
    }

    public E doInBackground() {
        try {
            this.computation = this.task.get();
        }
        catch (Exception e) {
            if (this.exceptionConsumer != null) {
                this.triggeredExceptionInSupplier = true;
                this.exceptionConsumer.accept(e);
            }
            e.printStackTrace();
            throw e;
        }
        try {
            if (this.result != null && !this.triggeredExceptionInSupplier) {
                this.result.accept(this.computation);
            }
        }
        catch (Exception e) {
            if (this.exceptionConsumer != null) {
                this.exceptionConsumer.accept(e);
            }
            e.printStackTrace();
        }
        return this.computation;
    }

    public E get() throws InterruptedException, ExecutionException {
        if (this.future != null) {
            return this.future.get();
        }
        return null;
    }
}

