/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import com.bedatadriven.jackson.datatype.jts.parsers.GenericGeometryParser;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.geojson.DateParser;
import org.geotools.data.geojson.ObjectMapperFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.Geometries;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class GeoJSONReader
implements AutoCloseable {
    public static final String GEOMETRY_NAME = "geometry";
    private static final Logger LOGGER = Logging.getLogger(GeoJSONReader.class);
    private JsonParser parser;
    private static JsonFactory factory = new JsonFactory();
    private SimpleFeatureType schema;
    private SimpleFeatureBuilder builder;
    private int nextID = 0;
    private String baseName = "features";
    private boolean schemaChanged = false;
    private static GeometryFactory GEOM_FACTORY = new GeometryFactory();
    private static GenericGeometryParser GEOM_PARSER = new GenericGeometryParser(GEOM_FACTORY);
    private URL url;
    private InputStream is;
    private boolean guessingDates = true;
    private DateParser dateParser = new DateParser();

    public GeoJSONReader(URL url) throws IOException {
        this.url = url;
        this.is = url.openStream();
        this.parser = factory.createParser(url);
        this.baseName = FilenameUtils.getBaseName((String)url.getPath());
    }

    public GeoJSONReader(InputStream is) throws IOException {
        this.parser = factory.createParser(is);
    }

    public GeoJSONReader(String json) throws IOException {
        this.parser = factory.createParser(json);
    }

    public boolean isGuessingDates() {
        return this.guessingDates;
    }

    public void setGuessingDates(boolean guessingDates) {
        this.guessingDates = guessingDates;
    }

    /*
     * Exception decompiling
     */
    public boolean isConnected() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static SimpleFeature parseFeature(String json) throws JsonParseException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SimpleFeatureCollection parseFeatureCollection(String jsonString) {
        try (GeoJSONReader reader = new GeoJSONReader(new ByteArrayInputStream(jsonString.getBytes()));){
            SimpleFeatureCollection features;
            SimpleFeatureCollection simpleFeatureCollection = features = reader.getFeatures();
            return simpleFeatureCollection;
        }
        catch (IOException e) {
            throw new RuntimeException("problem parsing FeatureCollection", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Geometry parseGeometry(String input) {
        try (JsonParser lParser = factory.createParser((InputStream)new ByteArrayInputStream(input.getBytes()));){
            Geometry g;
            ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
            ObjectNode node = (ObjectNode)mapper.readTree(lParser);
            Geometry geometry = g = GEOM_PARSER.geometryFromJson((JsonNode)node);
            return geometry;
        }
        catch (IOException e) {
            throw new RuntimeException("problem parsing Geometry", e);
        }
    }

    public SimpleFeature getFeature() throws IOException {
        ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
        ObjectNode node = (ObjectNode)mapper.readTree(this.parser);
        return this.getNextFeature(node);
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        JsonToken token;
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
        ArrayList<Object> features = new ArrayList<SimpleFeature>();
        this.builder = null;
        while (!this.parser.isClosed() && (token = this.parser.nextToken()) != null) {
            if (!JsonToken.FIELD_NAME.equals((Object)token) || !"features".equalsIgnoreCase(this.parser.currentName())) continue;
            token = this.parser.nextToken();
            if (!JsonToken.START_ARRAY.equals((Object)token) || token == null) break;
            while (this.parser.nextToken() == JsonToken.START_OBJECT) {
                ObjectNode node = (ObjectNode)mapper.readTree(this.parser);
                SimpleFeature simpleFeature = this.getNextFeature(node);
                features.add(simpleFeature);
            }
        }
        if (this.isSchemaChanged()) {
            ArrayList<SimpleFeature> nFeatures = new ArrayList<SimpleFeature>(features.size());
            for (SimpleFeature simpleFeature : features) {
                if (simpleFeature.getFeatureType() != this.schema) {
                    SimpleFeature nFeature = DataUtilities.reType(this.schema, simpleFeature);
                    nFeatures.add(nFeature);
                    continue;
                }
                nFeatures.add(simpleFeature);
            }
            features = nFeatures;
        }
        return new ListFeatureCollection(this.schema, features);
    }

    private SimpleFeature getNextFeature(ObjectNode node) throws IOException {
        JsonNode type = node.get("type");
        if (type == null) {
            throw new RuntimeException("Missing object type in GeoJSON Parsing, expected type=Feature here");
        }
        if (!"Feature".equalsIgnoreCase(type.asText())) {
            throw new RuntimeException("Unexpected object type in GeoJSON Parsing, expected Feature got '" + type.asText() + "'");
        }
        JsonNode geom = node.get(GEOMETRY_NAME);
        Geometry g = GEOM_PARSER.geometryFromJson(geom);
        JsonNode props = node.get("properties");
        if (this.builder == null || !this.builder.getFeatureType().getGeometryDescriptor().getType().getBinding().isInstance(g)) {
            this.builder = this.getBuilder(props, g);
        }
        boolean restart = true;
        SimpleFeature feature = null;
        while (restart) {
            restart = false;
            Iterator fields = props.fields();
            while (fields.hasNext()) {
                Class binding;
                Map.Entry n = (Map.Entry)fields.next();
                AttributeDescriptor descriptor = this.schema.getDescriptor((String)n.getKey());
                if (descriptor == null) {
                    restart = true;
                    this.builder = null;
                    this.builder = this.getBuilder(props, g);
                    this.setSchemaChanged(true);
                    descriptor = this.schema.getDescriptor((String)n.getKey());
                }
                if ((binding = descriptor.getType().getBinding()) == Integer.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asInt());
                    continue;
                }
                if (binding == Double.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asDouble());
                    continue;
                }
                if (binding == String.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).textValue());
                    continue;
                }
                if (binding == Boolean.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).booleanValue());
                    continue;
                }
                if (binding == Object.class) {
                    this.builder.set((String)n.getKey(), n.getValue());
                    continue;
                }
                if (binding == List.class) {
                    ArrayNode array = (ArrayNode)n.getValue();
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.size(); ++i) {
                        Object vc;
                        JsonNode item = array.get(i);
                        switch (item.getNodeType()) {
                            case BOOLEAN: {
                                vc = item.asBoolean();
                                break;
                            }
                            case NUMBER: {
                                vc = item.asDouble();
                                break;
                            }
                            case STRING: {
                                vc = item.asText();
                                break;
                            }
                            case NULL: {
                                vc = null;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Cannot handle arrays with values of type " + item.getNodeType());
                            }
                        }
                        list.add(vc);
                    }
                    this.builder.set((String)n.getKey(), list);
                    continue;
                }
                if (Geometry.class.isAssignableFrom(binding)) {
                    Geometry geomAtt = GEOM_PARSER.geometryFromJson((JsonNode)n.getValue());
                    this.builder.set((String)n.getKey(), (Object)geomAtt);
                    continue;
                }
                if (Date.class.isAssignableFrom(binding)) {
                    String text = ((JsonNode)n.getValue()).asText();
                    Date date = this.dateParser.parse(text);
                    if (date != null) {
                        this.builder.set((String)n.getKey(), (Object)date);
                        continue;
                    }
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asText());
                    continue;
                }
                LOGGER.warning("Unable to parse object of type " + binding);
                this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asText());
            }
            this.builder.set(GEOMETRY_NAME, (Object)g);
            String newId = this.baseName + "." + this.nextID++;
            feature = this.builder.buildFeature(newId);
        }
        return feature;
    }

    private SimpleFeatureBuilder getBuilder(JsonNode props, Geometry g) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setCRS(DefaultGeographicCRS.WGS84);
        typeBuilder.setName(this.baseName);
        HashSet<String> existing = new HashSet<String>();
        if (this.schema != null) {
            for (AttributeDescriptor att : this.schema.getAttributeDescriptors()) {
                if (att instanceof GeometryDescriptor && this.schema.getGeometryDescriptor() == att && g != null) {
                    GeometryDescriptor gd = (GeometryDescriptor)att;
                    Class<?> currClass = g.getClass();
                    Class prevClass = gd.getType().getBinding();
                    if (!prevClass.isAssignableFrom(currClass)) {
                        typeBuilder.add(GEOMETRY_NAME, Geometry.class, DefaultGeographicCRS.WGS84);
                    } else {
                        typeBuilder.add(att);
                    }
                } else {
                    typeBuilder.add(att);
                }
                existing.add(att.getLocalName());
            }
        }
        if (typeBuilder.getDefaultGeometry() == null && g != null) {
            typeBuilder.setDefaultGeometry(GEOMETRY_NAME);
            if (!existing.contains(GEOMETRY_NAME)) {
                Class<?> geomType = g.getClass();
                typeBuilder.add(GEOMETRY_NAME, geomType, DefaultGeographicCRS.WGS84);
            }
        }
        Iterator fields = props.fields();
        while (fields.hasNext()) {
            Map.Entry n = (Map.Entry)fields.next();
            if (existing.contains(n.getKey())) continue;
            existing.add((String)n.getKey());
            typeBuilder.nillable(true);
            JsonNode value = (JsonNode)n.getValue();
            if (value instanceof IntNode) {
                typeBuilder.add((String)n.getKey(), Integer.class);
                continue;
            }
            if (value instanceof DoubleNode) {
                typeBuilder.add((String)n.getKey(), Double.class);
                continue;
            }
            if (value instanceof BooleanNode) {
                typeBuilder.add((String)n.getKey(), Boolean.class);
                continue;
            }
            if (value instanceof ObjectNode) {
                if (Optional.ofNullable(value.get("type")).map(t -> t.asText()).map(t -> Geometries.getForName(t)).isPresent()) {
                    typeBuilder.add((String)n.getKey(), Geometry.class, DefaultGeographicCRS.WGS84);
                    continue;
                }
                typeBuilder.add((String)n.getKey(), Object.class);
                continue;
            }
            if (value instanceof ArrayNode) {
                typeBuilder.add((String)n.getKey(), List.class);
                continue;
            }
            if (value instanceof TextNode && this.guessingDates) {
                Date date = this.dateParser.parse(value.asText());
                if (date != null) {
                    typeBuilder.add((String)n.getKey(), Date.class);
                    continue;
                }
                typeBuilder.defaultValue("");
                typeBuilder.add((String)n.getKey(), String.class);
                continue;
            }
            typeBuilder.defaultValue("");
            typeBuilder.add((String)n.getKey(), String.class);
        }
        this.schema = typeBuilder.buildFeatureType();
        return new SimpleFeatureBuilder(this.schema);
    }

    public SimpleFeatureIterator getIterator() throws IOException {
        if (!this.isConnected()) {
            LOGGER.fine("trying to read an unconnected data stream");
            return new DefaultFeatureCollection(null, null).features();
        }
        return new GeoJsonIterator(this.parser);
    }

    public FeatureType getSchema() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        return this.schema;
    }

    public void setSchema(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public boolean isSchemaChanged() {
        return this.schemaChanged;
    }

    public void setSchemaChanged(boolean schemaChanged) {
        this.schemaChanged = schemaChanged;
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
            this.parser = null;
        }
        if (this.is != null) {
            this.is.close();
        }
    }

    private class GeoJsonIterator
    implements SimpleFeatureIterator,
    AutoCloseable {
        ObjectMapper mapper = new ObjectMapper();
        JsonParser parser;
        private SimpleFeature feature;

        public GeoJsonIterator(JsonParser parser) throws IOException {
            JsonToken token;
            if (!GeoJSONReader.this.isConnected()) {
                throw new IOException("not connected to " + GeoJSONReader.this.url.toExternalForm());
            }
            this.parser = parser;
            GeoJSONReader.this.builder = null;
            while (!parser.isClosed() && (token = parser.nextToken()) != null) {
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !"features".equalsIgnoreCase(parser.currentName())) continue;
                token = parser.nextToken();
                if (JsonToken.START_ARRAY.equals((Object)token) && token != null) break;
                throw new IOException("No Features found");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.feature != null) {
                return true;
            }
            try {
                if (this.parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode node = (ObjectNode)this.mapper.readTree(this.parser);
                    this.feature = GeoJSONReader.this.getNextFeature(node);
                    if (this.feature != null) {
                        return true;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
            }
            return false;
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (this.feature != null) {
                SimpleFeature ret = this.feature;
                this.feature = null;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void close() {
            try {
                try {
                    if (this.parser != null) {
                        this.parser.close();
                    }
                }
                finally {
                    if (GeoJSONReader.this.is != null) {
                        GeoJSONReader.this.is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected failure closing iterator", e);
            }
            this.parser = null;
        }
    }
}

