/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.parsql.sql.transform;

import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TSQLLexer;
import com.sigge.parsql.sql.transform.TokenType;
import com.sigge.parsql.sql.transform.TokenUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class KeywordsFormatter {
    private static Set<String> KEYWORDS_TO_TAB = new HashSet<String>(Arrays.asList("SELECT", "FROM", "UPDATE", "SET", "WHERE", "ON", "EXEC", "WITH", "MERGE", "CROSS", "JOIN", "APPLY", "DECLARE"));

    public String transform(String text) {
        try {
            List<ISQLToken> tokens = TSQLLexer.parse(text);
            if (tokens.size() > 0) {
                StringBuilder sb = new StringBuilder(text.length());
                int copiedSoFar = -1;
                int i = 0;
                while (i < tokens.size()) {
                    ISQLToken keyword = tokens.get(i);
                    String keywordInText = text.substring(keyword.getStart(), keyword.getEnd() + 1);
                    if (keyword.getTokenType() == TokenType.KEYWORD && KEYWORDS_TO_TAB.contains(keywordInText.toUpperCase())) {
                        this.normalizeStart(text, sb, tokens, i, copiedSoFar);
                        sb.append(text.substring(keyword.getStart(), keyword.getEnd() + 1).toUpperCase());
                        if (i + 1 == tokens.size()) break;
                        NormalizePair p = this.normalizeAfter(text, sb, tokens, i);
                        copiedSoFar = p.charsCopiedNew;
                        i = p.newToken;
                    } else {
                        if (keyword.getStart() > copiedSoFar + 1) {
                            sb.append(text.substring(copiedSoFar + 1, keyword.getStart()));
                        }
                        sb.append(keyword.getTokenType() == TokenType.KEYWORD ? keywordInText.toUpperCase() : keywordInText);
                        copiedSoFar = keyword.getEnd();
                    }
                    ++i;
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    private NormalizePair normalizeAfter(String text, StringBuilder sb, List<ISQLToken> keywords, int currentToken) {
        List<ISQLToken> tokens = TokenUtils.getTokensUntilNewLine(text, keywords, currentToken);
        if (tokens.isEmpty()) {
            return new NormalizePair(keywords.get(currentToken).getEnd(), currentToken);
        }
        List<ISQLToken> realTokens = TokenUtils.trimLeft(TokenUtils.trimRight(tokens));
        if (realTokens.size() > 0) {
            sb.append("\t");
            ISQLToken zz = realTokens.get(0);
            int i = 0;
            while (i < tokens.size()) {
                ISQLToken z = keywords.get(currentToken + i + 1);
                if (z == zz) {
                    return new NormalizePair(z.getStart() - 1, currentToken + i);
                }
                ++i;
            }
        }
        ISQLToken t = tokens.get(tokens.size() - 1);
        return new NormalizePair(t.getEnd(), currentToken + tokens.size());
    }

    private void normalizeStart(String text, StringBuilder sb, List<ISQLToken> keywords, int currentToken, int charIndexCopiedSoFar) {
        if (currentToken == 0) {
            return;
        }
        ISQLToken keyword = keywords.get(currentToken);
        int i = currentToken - 1;
        ISQLToken t = keywords.get(i);
        if (t.getEnd() <= charIndexCopiedSoFar) {
            return;
        }
        if (t.getTokenType() != TokenType.NEWLINE && t.getTokenType() != TokenType.TAB) {
            sb.append(text.substring(charIndexCopiedSoFar + 1, t.getEnd() + 1));
            return;
        }
        --i;
        while (i >= 0) {
            ISQLToken t2 = keywords.get(i);
            if (t2.getEnd() <= charIndexCopiedSoFar || t2.getTokenType() == TokenType.NEWLINE || t2.in(TokenType.MULTICOMMENT, TokenType.NESTED_MULTICOMMENT, TokenType.DOUBLE_QUOTE_IDENTIFIER, TokenType.BRACES_IDENTIFIER, TokenType.STRING) && TokenUtils.tokenContainsNewLine(t2, text)) break;
            --i;
        }
        int countWS = 0;
        int countChars = 0;
        ISQLToken ke = null;
        int j = keywords.get(i + 1).getStart();
        while (j < keyword.getStart()) {
            ke = keywords.get(j);
            TokenType te = ke.getTokenType();
            switch (te) {
                case WHITESPACE: {
                    countChars += 1 + ke.getEnd() - ke.getStart();
                    countWS += 1 + ke.getEnd() - ke.getStart();
                    break;
                }
                case TAB: {
                    countChars += countChars % 8 + (countChars % 8 == 0 ? 8 : 0);
                    countWS = 0;
                    break;
                }
                default: {
                    countWS = 0;
                    countChars += 1 + ke.getEnd() - ke.getStart();
                }
            }
            ++j;
        }
        if (countWS == 0) {
            sb.append(text.substring(charIndexCopiedSoFar + 1, ke.getEnd() + 1)).append("\t");
            return;
        }
        int cntReal = countChars - countWS;
        sb.append(text.substring(charIndexCopiedSoFar + 1, charIndexCopiedSoFar + 1 + cntReal));
        while (cntReal < countChars) {
            sb.append("\t");
            cntReal += cntReal % 8 + (cntReal % 8 == 0 ? 8 : 0);
        }
    }

    static class NormalizePair {
        int charsCopiedNew;
        int newToken;

        NormalizePair(int charsCopiedNew, int newToken) {
            this.charsCopiedNew = charsCopiedNew;
            this.newToken = newToken;
        }
    }
}

