/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.ObjectUtils;

public class CloneUtils {
    public static List<?> cloneList(List<?> source) {
        Args.nullNotPermitted(source, "source");
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : source) {
            if (obj != null) {
                try {
                    result.add(ObjectUtils.clone(obj));
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            result.add(null);
        }
        return result;
    }

    public static Map cloneMapValues(Map source) {
        Args.nullNotPermitted(source, "source");
        HashMap result = new HashMap();
        for (Object key : source.keySet()) {
            Object value = source.get(key);
            if (value != null) {
                try {
                    result.put(key, ObjectUtils.clone(value));
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            result.put(key, null);
        }
        return result;
    }
}

