/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input.compressed;

import it.geosolutions.imageio.stream.input.FilterImageInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import javax.imageio.stream.ImageInputStream;

public class InflaterImageInputStream
extends FilterImageInputStream {
    protected int len;
    private byte[] b = new byte[512];
    protected boolean closed = false;
    protected byte[] buf;
    protected byte[] singleByteBuf = new byte[1];
    protected boolean usesDefaultInflater = false;
    protected Inflater inf;

    public InflaterImageInputStream(ImageInputStream iis) {
        this(iis, new Inflater());
        this.usesDefaultInflater = true;
    }

    public InflaterImageInputStream(ImageInputStream iis, Inflater inflater) {
        super(iis);
        this.inf = inflater;
        if (this.inf == null) {
            throw new NullPointerException();
        }
        this.buf = new byte[8192];
    }

    public InflaterImageInputStream(ImageInputStream iis, Inflater inflater, int size) {
        super(iis);
        this.inf = inflater;
        if (this.inf == null) {
            throw new NullPointerException();
        }
        this.buf = new byte[size];
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        return this.read(this.singleByteBuf, 0, 1) == -1 ? -1 : this.singleByteBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            int n;
            while ((n = this.inf.inflate(b, off, len)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    return -1;
                }
                if (!this.inf.needsInput()) continue;
                this.fill();
            }
            return n;
        }
        catch (DataFormatException e) {
            String s = e.getMessage();
            throw new ZipException(s != null ? s : "Invalid ZLIB data format");
        }
    }

    protected void fill() throws IOException {
        this.checkClosed();
        this.len = this.iis.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.usesDefaultInflater) {
                this.inf.end();
            }
            super.close();
            this.closed = true;
        }
    }

    @Override
    public void mark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long pos) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.skipBytes(n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        int total;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.checkClosed();
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        for (total = 0; total < max; total += len) {
            len = max - total;
            if (len > this.b.length) {
                len = this.b.length;
            }
            if ((len = this.read(this.b, 0, len)) == -1) break;
        }
        return total;
    }
}

