/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableWeakAssociation;
import schemacrawler.crawl.RetrieverUtility;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.WeakAssociation;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class WeakAssociationBuilder {
    private static final Logger LOGGER = Logger.getLogger(WeakAssociationBuilder.class.getName());
    private final Catalog catalog;
    private final Collection<ColumnReference> columnReferences;

    public static WeakAssociationBuilder builder(Catalog catalog) {
        return new WeakAssociationBuilder(catalog);
    }

    private WeakAssociationBuilder(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.columnReferences = new HashSet<ColumnReference>();
    }

    public WeakAssociationBuilder addColumnReference(WeakAssociationColumn referencingColumn, WeakAssociationColumn referencedColumn) {
        Objects.requireNonNull(referencingColumn, "No referencing column provided");
        Objects.requireNonNull(referencedColumn, "No referenced column provided");
        Column fkColumn = RetrieverUtility.lookupOrCreateColumn(this.catalog, referencingColumn.getSchema(), referencingColumn.getTableName(), referencingColumn.getColumnName());
        Column pkColumn = RetrieverUtility.lookupOrCreateColumn(this.catalog, referencedColumn.getSchema(), referencedColumn.getTableName(), referencedColumn.getColumnName());
        Objects.requireNonNull(fkColumn, "No referencing column provided");
        Objects.requireNonNull(pkColumn, "No referenced column provided");
        if (fkColumn.equals(pkColumn)) {
            return this;
        }
        boolean isFkColumnPartial = fkColumn instanceof PartialDatabaseObject;
        boolean isPkColumnPartial = pkColumn instanceof PartialDatabaseObject;
        if (isFkColumnPartial && isPkColumnPartial) {
            return this;
        }
        ImmutableColumnReference columnReference = new ImmutableColumnReference(this.columnReferences.size(), fkColumn, pkColumn);
        this.columnReferences.add(columnReference);
        return this;
    }

    public WeakAssociation build() {
        return this.build(null);
    }

    public WeakAssociation build(String name) {
        if (this.columnReferences.isEmpty()) {
            LOGGER.log(Level.CONFIG, "Weak association not built, since there are no column references");
            return null;
        }
        ColumnReference someColumnReference = this.columnReferences.iterator().next();
        Table referencedTable = (Table)someColumnReference.getPrimaryKeyColumn().getParent();
        Table referencingTable = (Table)someColumnReference.getForeignKeyColumn().getParent();
        String weakAssociationName = Utility.isBlank((CharSequence)name) ? RetrieverUtility.constructForeignKeyName(referencedTable, referencingTable) : name;
        MutableWeakAssociation weakAssociation = new MutableWeakAssociation(weakAssociationName);
        for (ColumnReference columnReference : this.columnReferences) {
            if (referencedTable.equals(columnReference.getPrimaryKeyColumn().getParent()) && referencingTable.equals(columnReference.getForeignKeyColumn().getParent())) {
                weakAssociation.addColumnReference(columnReference);
                continue;
            }
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Weak association not built, since column references are not consistent, %s", new Object[]{this.columnReferences}));
            return null;
        }
        if (referencedTable instanceof MutableTable) {
            ((MutableTable)referencedTable).addWeakAssociation(weakAssociation);
        }
        if (referencingTable instanceof MutableTable) {
            ((MutableTable)referencingTable).addWeakAssociation(weakAssociation);
        }
        return weakAssociation;
    }

    public WeakAssociationBuilder clear() {
        this.columnReferences.clear();
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Builder <%s> cleared", new Object[]{this.hashCode()}));
        return this;
    }

    public static final class WeakAssociationColumn {
        private final Schema schema;
        private final String tableName;
        private final String columnName;

        public WeakAssociationColumn(Column column) {
            this(Objects.requireNonNull(column, "No column provided").getSchema(), ((Table)column.getParent()).getName(), column.getName());
        }

        public WeakAssociationColumn(Schema schema, String table, String column) {
            this.schema = Objects.requireNonNull(schema, "No schema provided");
            this.tableName = Utility.requireNotBlank((String)table, (String)"No table name provided");
            this.columnName = Utility.requireNotBlank((String)column, (String)"No column name provided");
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return String.format("weak-association <%s.%s.%s>", this.schema, this.tableName, this.columnName);
        }
    }
}

