/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.log4j.helpers.Loader;
import org.geotools.util.logging.Log4JLogger;
import org.geotools.util.logging.LoggerFactory;

public class Log4JLoggerFactory
extends LoggerFactory<org.apache.log4j.Logger> {
    private static Log4JLoggerFactory factory;

    protected Log4JLoggerFactory() throws NoClassDefFoundError {
        super(org.apache.log4j.Logger.class);
    }

    public static synchronized Log4JLoggerFactory getInstance() throws NoClassDefFoundError {
        if (factory == null) {
            factory = new Log4JLoggerFactory();
        }
        return factory;
    }

    @Override
    protected org.apache.log4j.Logger getImplementation(String name) {
        return org.apache.log4j.Logger.getLogger((String)name);
    }

    @Override
    protected Logger wrap(String name, org.apache.log4j.Logger implementation) {
        return new Log4JLogger(name, implementation);
    }

    @Override
    protected org.apache.log4j.Logger unwrap(Logger logger) {
        if (logger instanceof Log4JLogger) {
            return ((Log4JLogger)logger).logger;
        }
        return null;
    }

    @Override
    public String lookupConfiguration() {
        String override = System.getProperty("log4j.defaultInitOverride");
        if (override == null || "false".equalsIgnoreCase(override)) {
            String configFile = System.getProperty("log4j.configuration");
            URL url = null;
            if (configFile != null) {
                try {
                    url = new URL(configFile);
                }
                catch (MalformedURLException ignore) {
                    url = Loader.getResource((String)configFile);
                }
                if (url != null) {
                    return url.toString();
                }
                return configFile + " (not found)";
            }
            url = Loader.getResource((String)"log4j.xml");
            if (url == null) {
                url = Loader.getResource((String)"log4j.properties");
            }
            if (url != null) {
                return url.toString();
            }
            return "(not found)";
        }
        return "Override log4j.defaultInitOverride '" + override + "'";
    }
}

