/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.sigge.filerunner.view.tabs.ITabManagerSwitcher;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.SwingUtilities;

public class TabSwitcherListener
implements ContainerListener {
    private final ITabManagerSwitcher tabManagerSwitcher;

    public TabSwitcherListener(ITabManagerSwitcher tabManagerSwitcher) {
        this.tabManagerSwitcher = tabManagerSwitcher;
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.methodInvokeOnCorrectThread(() -> this.removeKeyAndContainerListenerRecursively(e.getChild()));
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.methodInvokeOnCorrectThread(() -> this.addKeyAndContainerListenerRecursively(e.getChild()));
    }

    private void methodInvokeOnCorrectThread(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        this.tabManagerSwitcher.unregister(c);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            int i = 0;
            while (i < children.length) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
                ++i;
            }
        }
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        this.tabManagerSwitcher.register(c);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            int i = 0;
            while (i < children.length) {
                this.addKeyAndContainerListenerRecursively(children[i]);
                ++i;
            }
        }
    }
}

