/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.commands.TabCommands;
import com.sigge.filerunner.commands.tabs.BrowseToTabAction;
import com.sigge.filerunner.commands.tabs.CopyFileNameAction;
import com.sigge.filerunner.commands.tabs.CopyFilePathAction;
import com.sigge.filerunner.commands.tabs.CopyTabFileAction;
import com.sigge.filerunner.commands.tabs.RenameTabAction;
import com.sigge.filerunner.commands.tabs.RenameTabFileAction;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.IFeedback;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.ButtonTabComponent;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.editors.DefaultTextEditorHandler;
import com.sigge.filerunner.view.editors.IEditorHandler;
import com.sigge.filerunner.view.menu.RecentMenuHandler;
import com.sigge.filerunner.view.tabs.ColorLabel;
import com.sigge.filerunner.view.tabs.IFilePicker;
import com.sigge.filerunner.view.tabs.ITabEditor;
import com.sigge.filerunner.view.tabs.TabActionUtils;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabContentEditorListener;
import com.sigge.filerunner.view.tabs.TabUtils;
import com.sigge.fileutils.FileWatcherListener;
import com.sigge.fileutils.FileWatcherService;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TabManager
implements FileWatcherListener,
Provider<Consumer<File>> {
    public static final String FINISHED_STATE = "Finished";
    private final DnDTabbedPane tab;
    private final CardHolder<TabContent> holder;
    private final AtomicInteger counter = new AtomicInteger(0);
    private boolean suspend = false;
    private final List<TabContentEditorListener> tabContentListeners = new ArrayList<TabContentEditorListener>();
    private final Map<Integer, TabContent> tabmap = new HashMap<Integer, TabContent>();
    private final Map<Integer, ITabEditor> rmap = new HashMap<Integer, ITabEditor>();
    private final Map<Integer, JPanel> panelmap = new HashMap<Integer, JPanel>();
    private final List<File> changeQueue = Collections.synchronizedList(new ArrayList());
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();
    private static final ExecutorService EXECUTOR = Executors.newWorkStealingPool();
    private final RecentMenuHandler recentMenuHandler;
    private final Icon loader = IconUtils.getSmallAnimatedIcon("loader_small.gif");
    private final IFeedback feedback;
    private static final String STATE_ACTIVE = "STATE_ACTIVE";
    private static final Logger LOGGER = LoggerFactory.getLogger(TabManager.class);
    private final Set<IEditorHandler> editorHandlers;
    private FileWatcherService fw;

    @Inject
    public TabManager(@Named(value="mainTab") DnDTabbedPane jt, RecentMenuHandler handler, final CardHolder<TabContent> holder, IFilePicker saver, IFeedback feedback, Set<IEditorHandler> editorHandlers, final FileWatcherService fw) {
        this.fw = fw;
        LOGGER.debug("Create tab manager");
        this.editorHandlers = editorHandlers;
        this.tab = jt;
        this.recentMenuHandler = handler;
        this.feedback = feedback;
        this.recentMenuHandler.initializeList();
        this.holder = holder;
        fw.addFileChangeListener((FileWatcherListener)this);
        this.tab.addChangeListener(e -> {
            if (!this.suspend && this.tab.getSelectedIndex() != holder.currentIndex()) {
                holder.current(this.tab.getSelectedIndex());
            }
        });
        this.tab.addTabMoveListener((event, from, to) -> {
            TabContent cfr_ignored_0 = (TabContent)holder.move(from, to);
        });
        holder.addListener(new CardHolder.CardHolderListener<TabContent>(){

            @Override
            public boolean previewDeleted(TabContent element, int index) {
                for (int i = 0; i < TabManager.this.tabContentListeners.size(); ++i) {
                    if (((TabContentEditorListener)TabManager.this.tabContentListeners.get(i)).previewEditorRemoval(element, (ITabEditor)TabManager.this.rmap.get(index))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public TabContent resyncElementBeforeDelete(TabContent element) {
                ITabEditor iTabEditor = (ITabEditor)TabManager.this.rmap.get(element.getId());
                return iTabEditor.resyncElementBeforeDelete(element);
            }

            @Override
            public void deleted(TabContent element, int index) {
                try {
                    TabManager.this.suspend = true;
                    TabManager.this.tab.remove(index);
                    ActionMap am = TabManager.this.tab.getActionMap();
                    Action action = am.get("scrollTabsBackwardAction");
                    if (action != null) {
                        SwingUtilities.invokeLater(() -> action.actionPerformed(new ActionEvent(TabManager.this.tab, 1001, "")));
                    }
                    TabManager.this.tabContentListeners.forEach(l -> l.editorRemoved(element, (ITabEditor)TabManager.this.rmap.get(element.getId())));
                    IEditorHandler h = TabManager.this.findHandler(element);
                    h.deleted(element);
                    Integer id = element.getId();
                    TabManager.this.rmap.remove(id);
                    TabManager.this.tabmap.remove(id);
                    TabManager.this.panelmap.remove(id);
                    if (element.isAFile()) {
                        fw.removeFileToWatch(new File(element.getFileName()));
                    }
                    TabManager.this.suspend = false;
                    if (TabManager.this.tabmap.size() == 0) {
                        SwingUtilities.invokeLater(() -> TabManager.this.add());
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Exception while deleting", (Throwable)ex);
                }
            }

            @Override
            public synchronized void added(TabContent tc, int index) {
                String title = tc.getTitle();
                JPanel jp2 = new JPanel();
                jp2.setBorder(BorderFactory.createEmptyBorder());
                jp2.setLayout(new BorderLayout());
                TabManager.this.tab.addTab(title, null, (Component)jp2, tc.getFileName() != null && tc.getFileName().length() > 0 ? tc.getFileName() : null);
                ColorLabel tabLabel = new ColorLabel("<html>&nbsp;&nbsp;" + title + "&nbsp;&nbsp;");
                TabManager.this.tab.setTabComponentAt(index, (Component)new ButtonTabComponent((JTabbedPane)TabManager.this.tab, tabLabel, e -> holder.removeAndChangeToPrevious((int)e)));
                IEditorHandler h = TabManager.this.findHandler(tc);
                ITabEditor editor = h.create(tc);
                TabManager.this.tabmap.put(tc.getId(), tc);
                TabManager.this.rmap.put(tc.getId(), editor);
                jp2.add((Component)editor.getMainComponent(), "Center");
                TabManager.this.panelmap.put(tc.getId(), (JPanel)editor.getMainComponent());
                if (editor.getEditorComponent() instanceof RSyntaxTextArea) {
                    TabManager.this.tabContentListeners.forEach(l -> l.editorAdded(tc, (RSyntaxTextArea)editor.getEditorComponent()));
                }
                if (tc.isAFile()) {
                    try {
                        fw.addFileToWatch(new File(tc.getFileName()));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }

            @Override
            public void replaced(TabContent newElement, TabContent oldElement, int index) {
                Integer id = newElement.getId();
                TabManager.this.tabmap.put(id, newElement);
                IEditorHandler h = TabManager.this.findHandler(oldElement);
                h.replaced(newElement, oldElement, index);
                if (oldElement.isAFile() && !newElement.getFileName().equals(newElement.getFileName())) {
                    fw.removeFileToWatch(new File(oldElement.getFileName()));
                }
                if (newElement.isAFile()) {
                    try {
                        if (!newElement.getFileName().equals(oldElement.getFileName())) {
                            fw.addFileToWatch(new File(newElement.getFileName()));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void newCurrent(TabContent element, int index) {
                if (TabManager.this.suspend) {
                    return;
                }
                element.setStateValue(TabManager.STATE_ACTIVE, null);
                TabManager.this.tab.setSelectedIndex(index);
                ButtonTabComponent tabComponent = (ButtonTabComponent)TabManager.this.tab.getTabComponentAt(holder.getIndex(element));
                tabComponent.setLabelFont(tabComponent.getFont().deriveFont(0));
                TabManager.this.tabContentListeners.forEach(l -> l.newActive(element, (ITabEditor)TabManager.this.rmap.get(element.getId())));
            }
        });
        ComponentUtils.removeTravelsalForComponent((JComponent)this.tab, true);
    }

    private <E> IEditorHandler<E> findHandler(TabContent tc) {
        IEditorHandler supporter = null;
        for (IEditorHandler handler : this.editorHandlers) {
            if (!handler.supports(tc) || (supporter = handler) instanceof DefaultTextEditorHandler) continue;
            return supporter;
        }
        return supporter;
    }

    private <E> IEditorHandler<E> findHandler(File file) {
        IEditorHandler supporter = null;
        for (IEditorHandler handler : this.editorHandlers) {
            if (!handler.supports(file) || (supporter = handler) instanceof DefaultTextEditorHandler) continue;
            return supporter;
        }
        return supporter;
    }

    @Inject
    private void setupTabContext(final TabCommands.CloseCurrentTab closeTab, final TabCommands.RemoveOthers removeOthers, final TabCommands.RemoveLeft removeLeft, final TabCommands.RemoveRight removeRight, final TabCommands.RemoveAll removeAll, final TabCommands.FreezeTab freezeTab, final CopyTabFileAction copyTabFileAction, final RenameTabAction renameTabAction, final CopyFileNameAction copyFileNameAction, final CopyFilePathAction copyFilePathAction, final RenameTabFileAction renameTabFileAction, final BrowseToTabAction browseToTabAction) {
        this.tab.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                int tabNr = TabUtils.getTabForMouseEvent((JTabbedPane)TabManager.this.tab, me);
                if (tabNr == -1) {
                    return;
                }
                if (ButtonUtils.isRightClick(me)) {
                    JPopupMenu pp = new JPopupMenu("Tab commands");
                    TabContent tc = (TabContent)TabManager.this.holder.getValueAt(tabNr);
                    if (tc.isAFile()) {
                        pp.add(ActionUtils.createMenuAction("Browse to...", IconUtils.getSmallIcon("folder_into.png"), e -> browseToTabAction.executeForTab(tc)));
                        pp.addSeparator();
                        pp.add(ActionUtils.createMenuAction("Copy file", IconUtils.getSmallIcon("copy.png"), e -> copyTabFileAction.executeForTab(tc)));
                        pp.addSeparator();
                        pp.add(ActionUtils.createMenuAction("Copy file name", IconUtils.getSmallIcon("copy.png"), e -> copyFileNameAction.executeForTab(tc)));
                        pp.add(ActionUtils.createMenuAction("Copy full path", IconUtils.getSmallIcon("clipboard_next.png"), e -> copyFilePathAction.executeForTab(tc)));
                        pp.addSeparator();
                        pp.add(ActionUtils.createMenuAction("Rename file", null, e -> renameTabFileAction.executeForTab(tc)));
                        pp.addSeparator();
                    } else {
                        pp.add(ActionUtils.createMenuAction("Rename tab", null, e -> renameTabAction.executeForTab(tc)));
                    }
                    pp.add(ActionUtils.createMenuAction("Freeze tab", null, freezeTab));
                    pp.addSeparator();
                    pp.add(ActionUtils.createMenuAction("Close tab", IconUtils.getSmallIcon("close.png"), closeTab));
                    pp.add(ActionUtils.createMenuAction("Close others", null, removeOthers));
                    pp.add(ActionUtils.createMenuAction("Close left", null, removeLeft));
                    pp.add(ActionUtils.createMenuAction("Close right", null, removeRight));
                    pp.addSeparator();
                    pp.add(ActionUtils.createMenuAction("Close all", null, removeAll));
                    pp.show((Component)TabManager.this.tab, me.getX(), me.getY());
                } else if (me.getButton() == 2) {
                    TabManager.this.holder.removeAndChangeToPrevious(tabNr);
                }
            }
        });
    }

    public void renameTab(TabContent tc) {
        String name = JOptionPane.showInputDialog((Component)this.tab, "Rename file to", tc.getTitle());
        if (name == null) {
            return;
        }
        String originalName = tc.getTitle();
        TabContent newElement = new TabContent(name, null, tc.getContent(), tc.getContentType(), tc.getEncoding());
        newElement.assignId(tc.getId());
        newElement.setStateValue("ORIGINALTITLE", originalName);
        this.holder.replaceCurrent(newElement);
    }

    public void replaceTab(TabContent tc) {
        this.holder.replaceCurrent(tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(TabContent tc) {
        File f = new File(tc.getFileName());
        String name = JOptionPane.showInputDialog((Component)this.tab, "Rename file to", f.getName());
        if (name == null || f.getName().equals(name)) {
            return;
        }
        File newFile = Paths.get(f.getParent(), name).toFile();
        if (newFile.exists()) {
            this.feedback.showMessage((JComponent)this.tab, "File " + name + " already exists");
            return;
        }
        this.fw.addFileSuspendWatch(f);
        this.fw.addFileSuspendWatch(newFile);
        try {
            if (f.renameTo(newFile)) {
                TabContent newElement = new TabContent(newFile.getName(), newFile.getAbsolutePath(), tc.getContent(), tc.getEncoding());
                newElement.assignId(tc.getId());
                this.holder.replaceCurrent(newElement);
            }
        }
        catch (Exception e) {
            this.feedback.showMessage((JComponent)this.tab, "Couldn't save file due to:" + e.getMessage());
        }
        finally {
            SCHEDULER.schedule(() -> this.fw.removeFileSuspendWatch(f), 2L, TimeUnit.SECONDS);
            SCHEDULER.schedule(() -> this.fw.removeFileSuspendWatch(newFile), 2L, TimeUnit.SECONDS);
        }
    }

    @Inject
    public void setActions(TabCommands.NewTabAction newTab, TabCommands.OpenTabAction openTab, TabCommands.SaveFileAction saveFile, TabCommands.RestoreTabAction restoreTab, TabCommands.CloseCurrentTab closeTab) {
        TabActionUtils.addAction((JComponent)this.tab, newTab);
        TabActionUtils.addAction((JComponent)this.tab, openTab);
        TabActionUtils.addAction((JComponent)this.tab, saveFile);
        TabActionUtils.addAction((JComponent)this.tab, restoreTab);
        TabActionUtils.addAction((JComponent)this.tab, closeTab);
    }

    public void saveFile(String encoding) {
        this.saveFile(false, encoding);
    }

    public void saveFile() {
        this.saveFile(false);
    }

    public void saveFile(boolean saveAs) {
        this.saveFile(saveAs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(boolean saveAs, String encoding) {
        block9: {
            TabContent tc = this.holder.current();
            if (tc != null) {
                Optional<File> optFile;
                File fsss;
                block7: {
                    block8: {
                        fsss = null;
                        optFile = this.findHandler(tc).save(tc, saveAs, encoding);
                        if (optFile.isPresent()) break block7;
                        if (fsss == null) break block8;
                        File fsss2 = fsss;
                        SCHEDULER.schedule(() -> this.fw.removeFileSuspendWatch(fsss2), 2L, TimeUnit.SECONDS);
                    }
                    return;
                }
                try {
                    fsss = optFile.get();
                    this.recentMenuHandler.openFile(fsss);
                    ConfigHandler.getConfig().setLastDirectory(fsss.getParent());
                    if (fsss == null) break block9;
                    File fsss2 = fsss;
                    SCHEDULER.schedule(() -> this.fw.removeFileSuspendWatch(fsss2), 2L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    try {
                        this.feedback.showMessage((JComponent)this.tab, "Couldn't save file due to:" + e.getMessage());
                        if (fsss == null) break block9;
                        File fsss2 = fsss;
                        SCHEDULER.schedule(() -> this.fw.removeFileSuspendWatch(fsss2), 2L, TimeUnit.SECONDS);
                    }
                    catch (Throwable throwable) {
                        if (fsss != null) {
                            File fsss2 = fsss;
                            SCHEDULER.schedule(() -> this.fw.removeFileSuspendWatch(fsss2), 2L, TimeUnit.SECONDS);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public List<Tuple<File, String>> openFile() {
        File dir = new File(ConfigHandler.getConfig().getLastDirectory());
        return this.openFile(dir);
    }

    public List<Tuple<File, String>> openFile(File preferredDir) {
        FileNameExtensionFilter fs = new FileNameExtensionFilter("SQL-files (*.sql)", "sql");
        List<File> files = FileUtils.openFiles((Component)this.tab, preferredDir, fs);
        if (files == null) {
            return Collections.EMPTY_LIST;
        }
        return this.openFiles(files);
    }

    public List<Tuple<File, String>> openFiles(List<File> files) {
        return this.openFiles(files, false);
    }

    public List<Tuple<File, String>> openFiles(List<File> files, boolean alwaysReplace) {
        boolean activated = false;
        ArrayList<Tuple<File, String>> errorMessages = new ArrayList<Tuple<File, String>>();
        for (File file : files) {
            String absolutePath = file.getAbsolutePath();
            TabContent tab = this.findContentByFile(absolutePath);
            if (tab != null && !alwaysReplace) {
                if (!activated) {
                    this.holder.current(tab);
                    activated = true;
                }
                this.recentMenuHandler.openFile(file);
                continue;
            }
            try {
                TabContent tc = this.findHandler(file).open(file, Optional.ofNullable(tab));
                if (tc != tab) {
                    this.addToHolder(tc);
                } else if (!activated) {
                    this.holder.current(tc);
                    activated = true;
                }
                this.recentMenuHandler.openFile(file);
            }
            catch (Exception e) {
                errorMessages.add((Tuple<File, String>)Tuple.of((Object)file, (Object)e.getMessage()));
            }
        }
        return errorMessages;
    }

    public void setCurrent(int index) {
        this.holder.current(index);
    }

    private TabContent findContentByFile(String path) {
        for (TabContent content : this.holder.view()) {
            try {
                if (!content.isAFile() || !path.equals(content.getFileName()) && !Files.isSameFile(Paths.get(path, new String[0]), Paths.get(content.getFileName(), new String[0]))) continue;
                return content;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public int create(List<TabContent> contents, int currentIndex) {
        this.suspend = true;
        int index = 0;
        ArrayList<TabContent> tabs = new ArrayList<TabContent>(contents);
        ArrayList<Future<TabContent>> futures = new ArrayList<Future<TabContent>>();
        for (int i = 0; i < contents.size(); ++i) {
            TabContent tabContent = contents.get(i);
            if (!tabContent.isAFile()) continue;
            int s = i;
            futures.add(EXECUTOR.submit(() -> tabs.set(s, this.createContentFromFileContent(content))));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
        for (int i = 0; i < tabs.size(); ++i) {
            TabContent tabContent;
            if (i + 1 == tabs.size()) {
                // empty if block
            }
            if ((tabContent = (TabContent)tabs.get(i)) == null) {
                if (i >= currentIndex) continue;
                --index;
                continue;
            }
            this.addToHolder(tabContent, true);
        }
        this.suspend = false;
        return currentIndex + index;
    }

    private TabContent createContentFromFileContent(TabContent content) {
        try {
            File file = new File(content.getFileName());
            if (file.exists()) {
                Tuple<String, String> fileAndEncoding = FileUtils.fileContent(file);
                TabContent tc = new TabContent(content.getTitle(), content.getFileName(), (String)fileAndEncoding.first(), (String)fileAndEncoding.second());
                content.copyStateTo(tc);
                return tc;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error occured while getting file content, file: {}, error: {}", (Object)content.getFileName(), (Object)e);
            return null;
        }
    }

    public TabContent add() {
        return this.add(null, "");
    }

    public TabContent add(String title, String content) {
        return this.add(title, content, null, null);
    }

    public TabContent add(String title, String content, String contentType) {
        return this.add(title, content, null, contentType);
    }

    public TabContent add(String title, String content, Map<String, Object> contextValue) {
        return this.add(title, content, contextValue, null);
    }

    private TabContent add(String title, String content, Map<String, Object> contextValue, String contentType) {
        TabContent tc = new TabContent(title != null ? title : "New file(" + this.counter + ")", content, contentType);
        if (contextValue != null) {
            contextValue.entrySet().stream().forEach(e -> tc.setStateValue((String)e.getKey(), e.getValue()));
        }
        return this.addToHolder(tc);
    }

    public void close() {
        this.holder.remove();
    }

    public List<TabContent> dumpContents() {
        ArrayList<TabContent> contents = new ArrayList<TabContent>();
        for (TabContent tc : this.holder.view()) {
            TabContent newContent = new TabContent(tc.getTitle(), tc.getFileName(), tc.isAFile() ? "" : this.rmap.get(tc.getId()).getData(), tc.getEncoding(), tc.getContentType());
            newContent.assignId(tc.getId());
            contents.add(newContent);
        }
        return contents;
    }

    public TabContent currentTab() {
        return this.holder.current();
    }

    public RSyntaxTextArea currentTextArea() {
        return (RSyntaxTextArea)this.rmap.get(this.holder.current().getId()).getEditorComponent();
    }

    public RSyntaxTextArea getAreaForContent(TabContent tc) {
        return (RSyntaxTextArea)this.rmap.get(tc.getId()).getEditorComponent();
    }

    public JPanel getContent() {
        return this.panelmap.get(this.holder.current().getId());
    }

    public JPanel getContent(TabContent tc) {
        return this.panelmap.get(tc.getId());
    }

    public void addContentEditorListener(TabContentEditorListener listener) {
        this.tabContentListeners.add(listener);
    }

    public void removeContentEditorListener(TabContentEditorListener listener) {
        this.tabContentListeners.remove(listener);
    }

    private boolean addFile(TabContent content, File file) {
        if (file.exists()) {
            try {
                Tuple<String, String> fileAndEncoding = FileUtils.fileContent(file);
                TabContent tc = new TabContent(content.getTitle(), content.getFileName(), (String)fileAndEncoding.first(), (String)fileAndEncoding.second());
                this.addToHolder(tc);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Error occured while getting file content, file: {}, error: {}", (Object)file, (Object)e);
            }
        } else {
            this.feedback.showMessage((JComponent)this.tab, "File " + file.getAbsolutePath() + " no longer exists, and will be closed");
        }
        return false;
    }

    private TabContent addToHolder(TabContent tc) {
        return this.addToHolder(tc, false);
    }

    private TabContent addToHolder(TabContent tc, boolean dontSetCurrent) {
        tc.assignId(this.counter.incrementAndGet());
        return this.holder.add(tc);
    }

    public void fileChanged(File f) {
        if (this.changeQueue.contains(f)) {
            return;
        }
        this.changeQueue.add(f);
        TabContent tc = this.findFile(f);
        if (tc != null && JOptionPane.showConfirmDialog((Component)this.tab, String.format("File %s seems to have been changed recently, do you want to reload it?", tc.getFileName()), "Are you sure?", 0) == 0) {
            SwingUtilities.invokeLater(() -> this.openFiles(Arrays.asList(f), true));
        }
        SCHEDULER.schedule(() -> this.changeQueue.remove(f), 2L, TimeUnit.SECONDS);
    }

    public void fileDeleted(File f) {
        TabContent tc = this.findFile(f);
        if (tc != null && !f.exists() && JOptionPane.showConfirmDialog((Component)this.tab, String.format("File %s seems to have been deleted recently, do you want to remove it?", tc.getFileName()), "Are you sure?", 0) == 0) {
            this.holder.remove(tc);
        }
    }

    public TabContent getContentFromArea(RSyntaxTextArea sta) {
        for (Integer i : this.rmap.keySet()) {
            ITabEditor iTabEditor = this.rmap.get(i);
            Object editorComponent = iTabEditor.getEditorComponent();
            if (editorComponent != sta) continue;
            return this.tabmap.get(i);
        }
        return null;
    }

    private TabContent findFile(File f) {
        for (Integer key : this.tabmap.keySet()) {
            TabContent x = this.tabmap.get(key);
            if (x == null || !x.isAFile() || !new File(x.getFileName()).equals(f)) continue;
            return x;
        }
        return null;
    }

    public void setRunning(TabContent tabContent, boolean running) {
        ButtonTabComponent tabComponent = (ButtonTabComponent)this.tab.getTabComponentAt(this.holder.getIndex(tabContent));
        if (running) {
            tabComponent.setIcon(this.loader);
        } else {
            if (tabContent.getStateValue(FINISHED_STATE) != null) {
                tabContent.setStateValue(FINISHED_STATE, null);
                if (!this.holder.current().equals(tabContent)) {
                    tabComponent.setLabelFont(tabComponent.getFont().deriveFont(1));
                }
            }
            tabComponent.setIcon(null);
        }
    }

    public void setColor(TabContent tabContent, Color tabColor) {
        ButtonTabComponent tabComponent = (ButtonTabComponent)this.tab.getTabComponentAt(this.holder.getIndex(tabContent));
        if (tabComponent == null) {
            System.out.println("Got here on null: " + this.holder.getIndex(tabContent) + ", tabs: " + this.tab.getTabCount());
            return;
        }
        tabComponent.setLabelBackground(tabColor);
    }

    public Consumer<File> get() {
        return f -> FileUtils.displayFileMessages(this.openFiles(Arrays.asList(f)));
    }

    public boolean isDirty(TabContent tc) {
        return this.findHandler(tc).isDirty(tc);
    }

    public List<TabContent> getDirtyTabContents() {
        ArrayList<TabContent> contents = new ArrayList<TabContent>();
        for (TabContent tc : this.tabmap.values()) {
            if (!this.findHandler(tc).isDirty(tc)) continue;
            contents.add(tc);
        }
        return contents;
    }

    public int currentTabIndex() {
        return this.holder.currentIndex();
    }
}

