/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.view.core.ButtonTabComponent;
import com.sigge.filerunner.view.tabs.TabContent;
import com.siggemannen.binding.ADocumentAdapter;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class TabContentDocumentListener
extends ADocumentAdapter {
    private final TabContent tc;
    private final RSyntaxTextArea rx;
    private int initialContent;
    private Boolean prevDirtyState;
    private int initialLength;
    private final CardHolder<TabContent> holder;
    private final JTabbedPane tab;
    private boolean inited = true;

    public TabContentDocumentListener(CardHolder<TabContent> holder, JTabbedPane tab, TabContent tc, RSyntaxTextArea rx, String content) {
        this.holder = holder;
        this.tab = tab;
        this.rx = rx;
        this.tc = tc;
        this.initialContent = content.hashCode();
        this.initialLength = content.length();
    }

    protected void setValueFromDocument(DocumentEvent e) {
        this.inited = false;
        int currentIndex = this.holder.getIndex(this.tc);
        if (currentIndex <= this.tab.getTabCount() - 1) {
            SwingUtilities.invokeLater(() -> this.updateDirtyState(currentIndex));
        }
    }

    private void updateDirtyState(int currentIndex) {
        if (!this.tc.isAFile()) {
            this.tc.setContent(this.rx.getText());
        }
        boolean dirty = this.isDirty();
        if (this.prevDirtyState == null || this.prevDirtyState != dirty) {
            this.setLabelState(dirty, currentIndex);
            this.prevDirtyState = dirty;
        }
    }

    private void setLabelState(boolean dirty, int currentIndex) {
        ButtonTabComponent oldComp = (ButtonTabComponent)this.tab.getTabComponentAt(currentIndex);
        oldComp.setText("<html>&nbsp;&nbsp;" + this.tc.getTitle() + (dirty ? "&nbsp;<b>*</b>" : "") + "&nbsp;&nbsp;");
    }

    public boolean isDirty() {
        if (this.inited) {
            return false;
        }
        return this.rx.canUndo() || this.initialLength != this.tc.getContent().length() || this.initialContent != this.tc.getContent().hashCode();
    }

    public void saved() {
        String content = this.rx.getText();
        this.initialContent = content.hashCode();
        this.initialLength = content.length();
        this.prevDirtyState = null;
        this.inited = true;
        this.setLabelState(false, this.holder.currentIndex());
    }
}

