/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers;

import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.ICSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class WhereTransformer
implements ICSVTransformer {
    @Override
    public String transform(String csv, Optional<IResultSetTable> table, TransformContext context) {
        boolean preview = context.isPreview();
        Optional<DatabaseContext> currentContext = context.getCurrentContext();
        IResultSetTable resultSetTableModel = table.get();
        StringBuilder sb = new StringBuilder(resultSetTableModel.getRowCount() * resultSetTableModel.getColumnCount() * 10);
        boolean useInbuilder = resultSetTableModel.getColumnCount() == 1 && resultSetTableModel.getRowCount() > 1;
        LinkedHashSet<String> inValues = new LinkedHashSet<String>();
        AtomicInteger row = new AtomicInteger(0);
        if (resultSetTableModel.getRowCount() > 1) {
            sb.append("(\n");
        }
        int i = 0;
        while (i < resultSetTableModel.getRowCount()) {
            if (preview && row.get() > 50) break;
            if (row.get() != 0) {
                sb.append("\tOR\t");
                if (resultSetTableModel.getColumnCount() > 1) {
                    sb.append("(\n\t");
                }
            } else if (resultSetTableModel.getColumnCount() > 1 || resultSetTableModel.getRowCount() > 1) {
                if (resultSetTableModel.getColumnCount() > 1 && resultSetTableModel.getRowCount() > 1) {
                    sb.append("\t(");
                }
                sb.append("\n\t");
            }
            row.incrementAndGet();
            int col = 0;
            int len = 0;
            while (len < resultSetTableModel.getColumnCount()) {
                boolean isString = this.isString(resultSetTableModel, col);
                if (col > 0) {
                    sb.append("\n\tAND\t");
                } else if (resultSetTableModel.getColumnCount() > 1) {
                    sb.append("\t");
                }
                String object = resultSetTableModel.getValueForDisplay(i, len);
                if (useInbuilder) {
                    if (object == null) {
                        useInbuilder = false;
                    } else {
                        inValues.add(isString ? "N'" + object.replace("'", "''") + "'" : object);
                    }
                }
                sb.append(this.getSafeColumnName(resultSetTableModel.getColumnName(col), currentContext)).append(object == null ? " IS " : " = ");
                if (object != null && isString) {
                    sb.append("N'");
                }
                sb.append(object == null ? "NULL" : object.replace("'", "''"));
                if (object != null && isString) {
                    sb.append("'");
                }
                ++col;
                ++len;
            }
            if (resultSetTableModel.getColumnCount() > 1 || resultSetTableModel.getRowCount() > 1) {
                if (resultSetTableModel.getColumnCount() > 1 && resultSetTableModel.getRowCount() > 1) {
                    sb.append("\n\t)");
                }
                sb.append("\n");
            }
            ++i;
        }
        if (resultSetTableModel.getRowCount() > 1) {
            sb.append(")");
        }
        if (useInbuilder && inValues.size() > 0) {
            sb = new StringBuilder(String.valueOf(resultSetTableModel.getColumnName(0)) + " IN (");
            int cnt = 0;
            for (String val : inValues) {
                if (cnt > 0) {
                    sb.append("\n\t,\t");
                } else {
                    sb.append("\n\t\t");
                }
                ++cnt;
                sb.append(val);
            }
            sb.append("\n\t)");
        }
        return sb.toString();
    }

    @Override
    public int supports(String csv, Optional<IResultSetTable> table, int lines, int cols) {
        return table.map(IResultSetTable::getRowCount).orElse(101) <= 100 ? 1 : 0;
    }

    @Override
    public String getLabel() {
        return "Where";
    }
}

