/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers;

import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.ICSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TextSplitter;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import java.util.List;
import java.util.Optional;

public class UnionAllTransformer
implements ICSVTransformer {
    @Override
    public String transform(String csv, Optional<IResultSetTable> table, TransformContext context) {
        boolean preview = context.isPreview();
        TextSplitter ts = new TextSplitter(this, csv, table, context, false);
        StringBuilder sb = new StringBuilder(csv == null ? 100 : csv.length());
        int row = 0;
        int col = 0;
        for (List<String> str : ts.getRows()) {
            sb.append("");
            if (row != 0) {
                sb.append("UNION ALL\n");
            }
            sb.append("SELECT\t");
            ++row;
            col = 0;
            int len = 0;
            while (len < ts.getColumnCount()) {
                if (col > 0) {
                    sb.append(", ");
                }
                if (str.size() > len) {
                    String object = str.get(len);
                    if (object == null || object.equalsIgnoreCase("NULL") || object.length() == 0 && !table.isPresent() && !ts.getStringColumns().containsKey(col)) {
                        sb.append("NULL");
                    } else {
                        if (ts.getStringColumns().containsKey(col)) {
                            sb.append("N'");
                        }
                        sb.append(object.replace("'", "''"));
                        if (ts.getStringColumns().containsKey(col)) {
                            sb.append("'");
                        }
                    }
                } else if (ts.getStringColumns().containsKey(col)) {
                    sb.append("''");
                } else {
                    sb.append("NULL");
                }
                if (row == 1) {
                    sb.append(" AS " + ts.getColumnNames().get(col));
                }
                ++col;
                ++len;
            }
            sb.append("\n");
            if (preview && row > 100) break;
        }
        return sb.toString();
    }

    @Override
    public int supports(String csv, Optional<IResultSetTable> table, int lines, int cols) {
        return lines < 300 ? 1 : 0;
    }

    @Override
    public String getLabel() {
        return "UNION ALL";
    }
}

