/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.SelectedResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.ICSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.NewLineReplaceDialog;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TextStyle;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.CSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.ColumnWiseTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.InTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.LeaveTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.UnionAllTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.UnionAllWithColumnsTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.ValuesTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.ValuesWithColumnsTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers.WhereTransformer;
import com.siggemannen.binding.Binder;
import com.siggemannen.core.MapBuilder;
import com.siggemannen.core.Tuple;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

@Singleton
public class TextTransformer {
    private static final int VALUES = 1;
    private static final int IN = 2;
    private static final int LEAVE = 0;
    private static final int SKIP = -1;
    private static final int WHERE = 3;
    private static final int COLUMN = 4;
    private static final int CSV = 5;
    private static final int UNION_ALL = 6;
    private static final int UNION_ALL_HEADED = 7;
    private static final int VALUES_COLUMN = 8;
    private boolean activateViaSpecialPaste;
    private boolean activeViaPaste;
    private final Map<String, IResultSetTable> repository;
    private final Map<Integer, ICSVTransformer> transformers = this.createTransformers();
    private static final ICSVTransformer LEAVE_TRANSFORMER = new LeaveTransformer();
    private final SQLManager manager;
    private final JFrame mainFrame;

    @Inject
    TextTransformer(@Named(value="model_repository") Map<String, IResultSetTable> repository, SQLManager manager, @Named(value="mainFrame") JFrame mainFrame) {
        this.repository = repository;
        this.manager = manager;
        this.mainFrame = mainFrame;
    }

    private Map<Integer, ICSVTransformer> createTransformers() {
        HashMap<Integer, ICSVTransformer> transformers = new HashMap<Integer, ICSVTransformer>();
        transformers.put(1, new ValuesTransformer());
        transformers.put(2, new InTransformer());
        transformers.put(3, new WhereTransformer());
        transformers.put(4, new ColumnWiseTransformer());
        transformers.put(5, new CSVTransformer());
        transformers.put(6, new UnionAllTransformer());
        transformers.put(7, new UnionAllWithColumnsTransformer());
        transformers.put(8, new ValuesWithColumnsTransformer());
        return transformers;
    }

    public void activateViaSpecialPaste(boolean activate) {
        this.activateViaSpecialPaste = activate;
    }

    public void activateViaPaste(boolean activate) {
        this.activeViaPaste = activate;
    }

    public String transform(String text, IResultSetTable rstm) {
        if (!this.activateViaSpecialPaste && !this.activeViaPaste) {
            return text;
        }
        if (this.activeViaPaste) {
            if (rstm == null) {
                return text;
            }
            if (rstm.getRowCount() <= 1) {
                return text;
            }
            if (rstm.getColumnCount() == 1 && rstm.getRowCount() == 2) {
                return text;
            }
        }
        if (text.length() > 20000000) {
            return text;
        }
        if (text.matches("[\n\r]+")) {
            return text;
        }
        if (rstm != null && rstm instanceof SelectedResultSetTable) {
            IResultSetTable realModel = this.repository.get(rstm.getIdentifier());
            if (realModel != null) {
                ((SelectedResultSetTable)rstm).reconstruct(realModel);
            } else {
                rstm = null;
            }
        }
        int tabsCnt = 0;
        int pipeCnt = 0;
        int newLinesCnt = 0;
        int spaceCnt = 0;
        if (rstm == null) {
            tabsCnt = this.countAtLeast(text, "\t");
            pipeCnt = this.countAtLeast(text, "|");
            newLinesCnt = this.countAtLeast(text, "\n");
            spaceCnt = text.split(" +").length;
        }
        HashMap<Integer, Tuple> supported = new HashMap<Integer, Tuple>();
        int preferred = 0;
        int supportLevelMax = 1;
        Iterator<Integer> iterator = this.transformers.keySet().iterator();
        while (iterator.hasNext()) {
            Integer key;
            ICSVTransformer transformer;
            int supports = (transformer = this.transformers.get(key = iterator.next())).supports(text, Optional.ofNullable(rstm), newLinesCnt, tabsCnt);
            supported.put(key, Tuple.of((Object)transformer, (Object)(supports > 0 ? 1 : 0)));
            if (supports <= 0 || supportLevelMax >= supports) continue;
            preferred = key;
            supportLevelMax = supports;
        }
        if (supported.size() > 0) {
            NewLineReplaceDialog model = new NewLineReplaceDialog();
            Binder.bindToCombo(model.textStyle, Arrays.asList(TextStyle.values()));
            model.textStyle.setSelectedItem(TextStyle.TAB_SEPARATED);
            model.textStyle.setRenderer(new LabelledCellRenderer());
            TransformState ts = new TransformState(model, text, rstm, TextStyle.TAB_SEPARATED);
            TextPaneUtil.configureSyntaxTextArea(model.previewTextArea);
            JMemoryDialog jd = new JMemoryDialog(null, "Special paste", true, "Special paste");
            supported.put(0, Tuple.of((Object)LEAVE_TRANSFORMER, (Object)true));
            Map radio = new MapBuilder((Object)0, (Object)model.leaveOption).append((Object)1, (Object)model.valuesOption).append((Object)6, (Object)model.unionAllOption).append((Object)7, (Object)model.headedUnionAll).append((Object)2, (Object)model.inOption).append((Object)3, (Object)model.whereOption).append((Object)4, (Object)model.columnwiseOption).append((Object)5, (Object)model.csvOption).append((Object)8, (Object)model.headerValuesOption).build();
            IResultSetTable rstm2 = rstm;
            int tabsCnt2 = tabsCnt;
            int pipeCnt2 = pipeCnt;
            int newLinesCnt2 = newLinesCnt;
            int spaceCnt2 = spaceCnt;
            model.textStyle.addActionListener(al -> {
                ts.style = (TextStyle)newLineReplaceDialog.textStyle.getSelectedItem();
                Tuple<Integer, ICSVTransformer> selectedOption = this.getSelectedOption(radio, supported);
                JRadioButton j = (JRadioButton)radio.get(selectedOption.first());
                boolean wasVisible = j.isVisible();
                int preferred2 = 0;
                int supportLevelMax2 = 1;
                for (Integer key : this.transformers.keySet()) {
                    ICSVTransformer transformer = this.transformers.get(key);
                    int supports = transformer.supports(text, Optional.ofNullable(rstm2), newLinesCnt2, ts.style == TextStyle.PIPE_SEPARATED ? pipeCnt2 : (ts.style == TextStyle.SPACE_SEPARATED ? spaceCnt2 : tabsCnt2));
                    supported.put(key, Tuple.of((Object)transformer, (Object)(supports > 0 ? 1 : 0)));
                    ((JRadioButton)radio.get(key)).setVisible(supports > 0);
                    if (supports <= 0 || supportLevelMax2 >= supports) continue;
                    preferred2 = key;
                    supportLevelMax2 = supports;
                }
                if (wasVisible && !j.isVisible()) {
                    ((JRadioButton)radio.get(preferred2)).setSelected(true);
                }
                this.option(ts, (Integer)selectedOption.first(), (ICSVTransformer)selectedOption.second());
            });
            for (Integer key : radio.keySet()) {
                JRadioButton option = (JRadioButton)radio.get(key);
                option.setVisible((Boolean)((Tuple)supported.get(key)).second());
                this.addListener(option, () -> this.option(ts, key, (ICSVTransformer)((Tuple)supported.get(key)).first()));
            }
            jd.getRootPane().setDefaultButton(model.goButton);
            jd.addOKAction(model.goButton);
            if (this.activeViaPaste) {
                SwingUtilities.invokeLater(() -> {
                    boolean bl = newLineReplaceDialog.leaveOption.requestFocusInWindow();
                });
                model.leaveOption.setSelected(true);
            } else if (preferred > 0) {
                JRadioButton jRadioButton = (JRadioButton)radio.get(preferred);
                SwingUtilities.invokeLater(() -> jRadioButton.requestFocusInWindow());
                jRadioButton.setSelected(true);
            } else if (((Boolean)((Tuple)supported.get(3)).second()).booleanValue()) {
                SwingUtilities.invokeLater(() -> {
                    boolean bl = newLineReplaceDialog.whereOption.requestFocusInWindow();
                });
                model.whereOption.setSelected(true);
            } else if (((Boolean)((Tuple)supported.get(1)).second()).booleanValue()) {
                SwingUtilities.invokeLater(() -> {
                    boolean bl = newLineReplaceDialog.valuesOption.requestFocusInWindow();
                });
                model.valuesOption.setSelected(true);
            } else if (((Boolean)((Tuple)supported.get(8)).second()).booleanValue()) {
                SwingUtilities.invokeLater(() -> {
                    boolean bl = newLineReplaceDialog.headerValuesOption.requestFocusInWindow();
                });
                model.headerValuesOption.setSelected(true);
            } else {
                model.inOption.setSelected(true);
                SwingUtilities.invokeLater(() -> {
                    boolean bl = newLineReplaceDialog.inOption.requestFocusInWindow();
                });
            }
            jd.getContentPane().add(model);
            if (!jd.isSizeSetFromSettings()) {
                jd.setSize(500, 400);
            }
            jd.centerOnCorrectScreen(this.mainFrame);
            jd.setVisible(true);
            if (jd.getReturnStatus() == 0) {
                ts.state = -1;
            }
            return ts.getValue();
        }
        return text;
    }

    private Tuple<Integer, ICSVTransformer> getSelectedOption(Map<Integer, JRadioButton> radio, Map<Integer, Tuple<ICSVTransformer, Boolean>> supported) {
        for (Map.Entry<Integer, JRadioButton> x : radio.entrySet()) {
            if (!x.getValue().isSelected() || !x.getValue().isVisible()) continue;
            return Tuple.of((Object)x.getKey(), (Object)((ICSVTransformer)supported.get(x.getKey()).first()));
        }
        return null;
    }

    private void option(TransformState ts, int state, ICSVTransformer transformer) {
        ts.state = state;
        Map map = ts.cache.getOrDefault(ts.state, new HashMap());
        String cache = (String)map.get(ts.style);
        if (cache == null) {
            cache = transformer.transform(ts.toTransform, Optional.ofNullable(ts.resultSetTableModel), new TransformContext(Optional.ofNullable(this.manager.getCurrentContext()), ts.style, true));
            map.put(ts.style, cache);
            ts.cache.put(ts.state, map);
        }
        ts.fullValue = () -> transformer.transform(transformState.toTransform, Optional.ofNullable(ts.resultSetTableModel), new TransformContext(Optional.ofNullable(this.manager.getCurrentContext()), ts.style, false));
        ts.model.previewTextArea.setText(cache);
        ts.model.previewTextArea.setCaretPosition(0);
    }

    private void addListener(AbstractButton j, Runnable r) {
        j.addItemListener(l -> {
            if (l.getStateChange() == 1) {
                r.run();
            }
        });
    }

    private int countAtLeast(String string, String toFind) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = string.indexOf(toFind, lastIndex)) == -1) continue;
            ++count;
            lastIndex += toFind.length();
        }
        return count;
    }

    private static class TransformState {
        int state = 0;
        final NewLineReplaceDialog model;
        final String toTransform;
        Map<Integer, Map<TextStyle, String>> cache = new HashMap<Integer, Map<TextStyle, String>>();
        private final IResultSetTable resultSetTableModel;
        private Supplier<String> fullValue = null;
        private TextStyle style;

        TransformState(NewLineReplaceDialog model, String originalString, IResultSetTable resultSetTableModel, TextStyle style) {
            this.model = model;
            this.toTransform = originalString;
            this.resultSetTableModel = resultSetTableModel;
            this.style = style;
        }

        String getValue() {
            if (this.state == 0) {
                return this.toTransform;
            }
            if (this.state == -1) {
                return null;
            }
            if (this.fullValue != null) {
                return this.fullValue.get();
            }
            return this.cache.get(this.state).get(this.style);
        }
    }
}

