/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.view.rsyntaxtextarea.ColumnSelectedText;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.ConfigurableCaret;

public class RSQLSyntaxTextArea
extends RSyntaxTextArea {
    protected final ColumnSelectionCaret caret;
    private FocusableTip tip;

    public RSQLSyntaxTextArea() {
        this("", null);
    }

    public RSQLSyntaxTextArea(String text, String style) {
        super(new RSyntaxDocument(style == null ? "text/tsql" : style));
        this.setTabSize(8);
        try {
            this.getDocument().putProperty("multiByte", Boolean.TRUE);
            this.getDocument().insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.getCaret().setBlinkRate(0);
        this.caret = new ColumnSelectionCaret(CaretStyle.VERTICAL_LINE_STYLE);
        this.caret.setBlinkRate(0);
        this.caret.setAlwaysVisible(true);
        this.setCaret((Caret)((Object)this.caret));
        this.setUseFocusableTips(true);
        this.addKeyListener(this.caret);
    }

    public void registerTip(FocusableTip tip) {
        this.tip = tip;
    }

    public void closeToolTip() {
        if (this.tip != null) {
            this.tip.possiblyDisposeOfTipWindow();
        }
    }

    public boolean isColumnSelection() {
        int line2;
        Document doc;
        Element defaultRootElement;
        int line1;
        boolean multipleHighlights;
        if (this.getSelectionEnd() - this.getSelectionStart() + 1 >= this.getDocument().getLength()) {
            return false;
        }
        if (this.getHighlighter().getHighlights().length == 1) {
            return this.getCaret().getDot() == this.getCaret().getMark();
        }
        boolean bl = multipleHighlights = this.getHighlighter().getHighlights().length > 1;
        if (!multipleHighlights) {
            return false;
        }
        Tuple<Point, Point> points = this.getPoints();
        int pos = this.getUI().viewToModel((JTextComponent)((Object)this), (Point)points.first(), new Position.Bias[1]);
        int pos2 = this.getUI().viewToModel((JTextComponent)((Object)this), (Point)points.second(), new Position.Bias[1]);
        int tmp = pos;
        if (pos > pos2) {
            pos = pos2;
            pos2 = tmp;
        }
        if ((line1 = (defaultRootElement = (doc = this.getDocument()).getDefaultRootElement()).getElementIndex(pos)) == (line2 = defaultRootElement.getElementIndex(pos2))) {
            return false;
        }
        System.out.println("Line1: " + line1 + ", line2: " + line2 + ", pos: " + pos + ", pos2:" + pos2);
        return true;
    }

    public void replaceSelection(String text) {
        if (!this.isColumnSelection()) {
            super.replaceSelection(text);
            return;
        }
        TextPaneUtil.replaceColumnSelection(this, text);
    }

    public void replaceSelectionWithColumnSelection(String text) {
        TextPaneUtil.replaceColumnSelectionWithColumnSelection(this, a -> text);
    }

    public Tuple<Point, Point> getPoints() {
        return Tuple.of((Object)this.caret.lastPoint, (Object)this.caret.lastPointRelease);
    }

    public synchronized void addKeyListener(KeyListener l) {
        if (l.getClass().getCanonicalName() != null && l.getClass().getCanonicalName().contains("javax.swing.ToolTipManager.AccessibilityKeyListener")) {
            return;
        }
        super.addKeyListener(l);
    }

    public Tuple<String, Boolean> getSelection() {
        Highlighter.Highlight[] selections = this.getHighlighter().getHighlights();
        int cnt = selections.length;
        if (cnt <= 1 || !this.isColumnSelection()) {
            String selected = super.getSelectedText();
            if (selected == null || selected.length() == 0) {
                return Tuple.of((Object)"", (Object)false);
            }
            if ("\r".equals(selected.substring(selected.length() - 1))) {
                return Tuple.of((Object)selected.substring(0, selected.length() - 1), (Object)false);
            }
            return Tuple.of((Object)selected, (Object)false);
        }
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < cnt) {
            int start = selections[i].getStartOffset();
            int end = selections[i].getEndOffset();
            String selectedText = "";
            try {
                String s2;
                String s;
                if (end >= start && ("\n".equals(s = this.getDocument().getText(end, 1)) || "\r".equals(s)) && end > start && ("\n".equals(s2 = this.getDocument().getText(end - 1, 1)) || "\r".equals(s2))) {
                    --end;
                }
                selectedText = end < start ? "" : this.getDocument().getText(start, end - start);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (i == 0) {
                text.append(selectedText);
            } else {
                text.append('\n').append(selectedText);
            }
            ++i;
        }
        return Tuple.of((Object)text.toString(), (Object)true);
    }

    public String getSelectedText() {
        Highlighter.Highlight[] selections = this.getHighlighter().getHighlights();
        int cnt = selections.length;
        if (cnt <= 1 || !this.isColumnSelection()) {
            String selected = super.getSelectedText();
            if (selected == null || selected.length() == 0) {
                return "";
            }
            if ("\r".equals(selected.substring(selected.length() - 1))) {
                return selected.substring(0, selected.length() - 1);
            }
            return selected;
        }
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < cnt) {
            int start = selections[i].getStartOffset();
            int end = selections[i].getEndOffset();
            String selectedText = "";
            try {
                String s2;
                String s;
                if (end >= start && ("\n".equals(s = this.getDocument().getText(end, 1)) || "\r".equals(s)) && end > start && ("\n".equals(s2 = this.getDocument().getText(end - 1, 1)) || "\r".equals(s2))) {
                    --end;
                }
                selectedText = end < start ? "" : this.getDocument().getText(start, end - start);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (i == 0) {
                text.append(selectedText);
            } else {
                text.append('\n').append(selectedText);
            }
            ++i;
        }
        return text.toString();
    }

    public void copy() {
        Tuple<String, Boolean> t = this.getSelection();
        if (((Boolean)t.second()).booleanValue()) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents((Transferable)((Object)new ColumnSelectedText((String)t.first(), (String)t.first())), (a, b) -> {});
        } else {
            ClipboardUtils.setStringDataToClipboard(this.getSelectedText());
        }
    }

    class ColumnSelectionCaret
    extends ConfigurableCaret
    implements KeyListener {
        Point lastPoint;
        Point lastPointRelease;
        boolean altDown;
        boolean moving;
        private final ZeroWidthPainter painter;

        public ColumnSelectionCaret() {
            this.lastPoint = new Point(0, 0);
            this.lastPointRelease = new Point(0, 0);
            this.altDown = false;
            this.moving = false;
            this.painter = new ZeroWidthPainter(null);
        }

        public ColumnSelectionCaret(CaretStyle style) {
            super(style);
            this.lastPoint = new Point(0, 0);
            this.lastPointRelease = new Point(0, 0);
            this.altDown = false;
            this.moving = false;
            this.painter = new ZeroWidthPainter(null);
        }

        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1 && !e.isShiftDown()) {
                this.getComponent().getHighlighter().removeAllHighlights();
                this.getComponent().requestFocusInWindow();
            }
            super.mouseClicked(e);
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.lastPoint = new Point(e.getX(), e.getY());
            this.altDown = e.isAltDown();
        }

        protected void moveCaret(MouseEvent e) {
            if (!this.moving) {
                if (!e.isShiftDown()) {
                    this.getComponent().getHighlighter().removeAllHighlights();
                }
                this.moving = true;
            }
            if (this.altDown || e.isAltDown()) {
                Point pt = new Point(e.getX(), e.getY());
                Position.Bias[] biasRet = new Position.Bias[1];
                int pos = this.getComponent().getUI().viewToModel(this.getComponent(), pt, biasRet);
                if (pos >= 0) {
                    this.setDot(pos);
                    Point start = new Point(Math.min(this.lastPoint.x, pt.x), Math.min(this.lastPoint.y, pt.y));
                    Point end = new Point(Math.max(this.lastPoint.x, pt.x), Math.max(this.lastPoint.y, pt.y));
                    this.customHighlight(start, end);
                }
            } else {
                super.moveCaret(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.moving = false;
            super.mouseReleased(e);
            this.lastPointRelease = e.getPoint();
        }

        protected void customHighlight(Point start, Point end) {
            JTextComponent comp = this.getComponent();
            comp.getHighlighter().removeAllHighlights();
            int y = start.y;
            int firstX = start.x;
            int lastX = end.x;
            int pos1 = comp.getUI().viewToModel(comp, new Point(firstX, y));
            int pos2 = comp.getUI().viewToModel(comp, new Point(lastX, y));
            try {
                comp.getHighlighter().addHighlight(pos1, pos2, pos1 == pos2 ? this.painter : this.getSelectionPainter());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++y;
            while (y <= end.y) {
                int pos1new = comp.getUI().viewToModel(comp, new Point(firstX, y));
                int pos2new = comp.getUI().viewToModel(comp, new Point(lastX, y));
                if (pos1 != pos1new) {
                    pos1 = pos1new;
                    pos2 = pos2new;
                    try {
                        comp.getHighlighter().addHighlight(pos1, pos2, pos1 == pos2 ? this.painter : this.getSelectionPainter());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++y;
            }
        }

        public String toString() {
            return "Point" + this.lastPoint + "lastpoint" + this.lastPointRelease + ", altdown:" + this.altDown + " moving: " + this.moving;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.altDown && ListUtils.in((Object)e.getKeyCode(), (Object[])new Integer[]{37, 39, 38, 34, 33})) {
                this.altDown = false;
                if (RSQLSyntaxTextArea.this.getHighlighter().getHighlights().length > 1) {
                    RSQLSyntaxTextArea.this.getHighlighter().removeAllHighlights();
                }
            }
        }
    }

    public static class ZeroWidthPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public ZeroWidthPainter(Color c) {
            super(c);
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            Rectangle alloc = bounds.getBounds();
            try {
                TextUI mapper = c.getUI();
                Rectangle p0 = mapper.modelToView(c, offs0);
                Rectangle p1 = mapper.modelToView(c, offs1);
                Color color = this.getColor();
                if (color == null) {
                    g.setColor(c.getSelectionColor());
                } else {
                    g.setColor(color);
                }
                if (p0.y == p1.y) {
                    Rectangle r = p0.union(p1);
                    r.width = 1;
                    g.fillRect(r.x, r.y, r.width, r.height);
                } else {
                    int p0ToMarginWidth = alloc.x + alloc.width - p0.x;
                    p0ToMarginWidth = 1;
                    g.fillRect(p0.x, p0.y, p0ToMarginWidth, p0.height);
                    if (p0.y + p0.height != p1.y) {
                        g.fillRect(alloc.x, p0.y + p0.height, alloc.width, p1.y - (p0.y + p0.height));
                    }
                    g.fillRect(alloc.x, p1.y, p1.x - alloc.x, p1.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Rectangle r;
            Color color = this.getColor();
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    r = null;
                }
            }
            if (r != null) {
                r.width = Math.max(r.width, 1);
                r.width = 1;
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            return r;
        }
    }
}

