/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.storage;

import com.sigge.fileutils.IBuffer;
import com.sigge.fileutils.MemoryStorageMode;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import microsoft.sql.DateTimeOffset;

public abstract class AColumnHandler<T>
implements Closeable {
    protected static final int INITIAL_ARRAY_SIZE = 10;
    protected byte[] NULLs = new byte[10];
    protected Set<Integer> NULL_SET = new HashSet<Integer>();
    protected static final int NULL_INT = -2147483606;
    protected static final long NULL_LONG = -2147483606L;
    protected static final double NULL_DOUBLE = -2.147483606E9;
    protected static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected int counter = 0;
    protected int nullcounter = 0;
    protected boolean needsNullData;
    protected boolean sorted = false;
    protected MemoryStorageMode memoryMode = MemoryStorageMode.IN_MEMORY;

    public abstract T getRowValue(int var1);

    public abstract void trimToSize();

    public abstract long getByteSize();

    public void setSorting(boolean sort) {
        this.sorted = sort;
    }

    protected static int getGrowthValue(int oldCapacity) {
        if (oldCapacity < 200000) {
            return oldCapacity >> 1;
        }
        return oldCapacity + 100000;
    }

    protected void fixNulls() {
        if (!this.needsNullData) {
            this.NULLs = null;
            this.NULL_SET.clear();
        } else if (this.nullcounter >= 50000) {
            for (Integer key : this.NULL_SET) {
                this.NULLs[key.intValue()] = 1;
            }
            this.NULL_SET.clear();
            this.NULLs = Arrays.copyOf(this.NULLs, this.counter);
        } else {
            this.NULLs = null;
        }
    }

    public static byte[] grow(byte[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + AColumnHandler.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = AColumnHandler.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    public static <T> T[] grow(T[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + AColumnHandler.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = AColumnHandler.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    public static double[] grow(double[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + AColumnHandler.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = AColumnHandler.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    public static int[] grow(int[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + AColumnHandler.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = AColumnHandler.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    public static long[] grow(long[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + AColumnHandler.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = AColumnHandler.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    public static String[] grow(String[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + AColumnHandler.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = AColumnHandler.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    public static DateTimeOffset[] grow(DateTimeOffset[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + AColumnHandler.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = AColumnHandler.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public int getRowCount() {
        return this.counter;
    }

    @Override
    public void close() throws IOException {
        this.clearData();
    }

    protected void clearData() {
        this.NULLs = null;
        this.NULL_SET = null;
    }

    protected void closeBuffer(IBuffer br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected synchronized boolean setMemoryMode(MemoryStorageMode mode) {
        if (mode == null || !this.memoryMode.canChangeTo(mode)) {
            return false;
        }
        this.memoryMode = mode;
        return true;
    }
}

