/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.simple;

import com.sigge.filerunner.view.results.graph.GraphType;
import com.siggemannen.core.ListUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GraphHelper {
    private static final Map<GraphType, Set<String>> FIELDS = GraphHelper.prepareFields();
    private static final Map<GraphType, Set<String>> OPTIONAL_FIELDS = GraphHelper.prepareOptionalFields();

    public static Set<? extends String> getMandatoryFields(GraphType type) {
        return FIELDS.get(type);
    }

    public static Set<? extends String> getOptionalFields(GraphType type) {
        return OPTIONAL_FIELDS.get(type);
    }

    private static Map<GraphType, Set<String>> prepareOptionalFields() {
        LinkedHashMap<GraphType, Set<String>> map = new LinkedHashMap<GraphType, Set<String>>();
        GraphType[] graphTypeArray = GraphType.values();
        int n = graphTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphType graphType = graphTypeArray[n2];
            HashSet<String> optionalsfields = new HashSet<String>();
            if (ListUtils.in((Object)graphType, (Object[])new GraphType[]{GraphType.LINE, GraphType.POINTS})) {
                optionalsfields.add("IDENTIFIER");
            }
            if (ListUtils.in((Object)graphType, (Object[])new GraphType[]{GraphType.PIE, GraphType.BAR, GraphType.STACKED, GraphType.STACKEDAREA})) {
                optionalsfields.add("XAXIS");
            }
            map.put(graphType, optionalsfields);
            ++n2;
        }
        return map;
    }

    private static Map<GraphType, Set<String>> prepareFields() {
        LinkedHashMap<GraphType, Set<String>> map = new LinkedHashMap<GraphType, Set<String>>();
        GraphType[] graphTypeArray = GraphType.values();
        int n = graphTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphType graphType = graphTypeArray[n2];
            HashSet<String> fields = new HashSet<String>();
            fields.add("YAXIS");
            if (!ListUtils.in((Object)graphType, (Object[])new GraphType[]{GraphType.LINE, GraphType.POINTS})) {
                fields.add("IDENTIFIER");
            }
            if (!ListUtils.in((Object)graphType, (Object[])new GraphType[]{GraphType.PIE, GraphType.BAR, GraphType.STACKED, GraphType.STACKEDAREA})) {
                fields.add("XAXIS");
            }
            map.put(graphType, fields);
            ++n2;
        }
        return map;
    }
}

