/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo.options;

import com.sigge.filerunner.view.core.JFontChooser;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.GeometryHolder;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.graph.ColorPalette;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.PaletteManager;
import com.sigge.filerunner.view.results.graph.geo.ColorUtils;
import com.sigge.filerunner.view.results.graph.geo.FixedColorPalette;
import com.sigge.filerunner.view.results.graph.geo.GeoDisplaySettings;
import com.sigge.filerunner.view.results.graph.geo.GeoWaypoint;
import com.sigge.filerunner.view.results.graph.geo.IGeoManager;
import com.sigge.filerunner.view.results.graph.geo.RowDisplayType;
import com.sigge.filerunner.view.results.graph.geo.WaypointHolder;
import com.sigge.filerunner.view.results.graph.geo.options.AGeoHandler;
import com.sigge.filerunner.view.results.graph.geo.options.AGeoWaypointModel;
import com.sigge.filerunner.view.results.graph.geo.options.ColorSetting;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoTypeHandler;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import com.sigge.filerunner.view.results.graph.geo.options.SingleGeo;
import com.sigge.filerunner.view.results.graph.geo.options.SingleGeoView;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.RowSorter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class WaypointHandler
extends AGeoHandler
implements IGeoTypeHandler<IGeoSetting> {
    @Override
    public IGeoSetting create(IGeoManager manager, Container container, List<GraphResult> results, GraphResult lastResult, Optional<IGeoSetting> geo, Runnable listener, String id) {
        return this.createInner(manager, null, geo, container, results, lastResult, listener, id);
    }

    protected boolean needsMagicLabels() {
        return true;
    }

    private SingleGeo createInner(IGeoManager manager, SingleGeoView prevView, Optional<IGeoSetting> optgeo, Container container, final List<GraphResult> results, GraphResult lastResult, final Runnable listener, String id) {
        List<TextListItem<Integer>> labels;
        if (prevView != null) {
            container.remove(prevView);
        }
        WaypointModel model = new WaypointModel();
        SingleGeo geo = optgeo.orElse(null);
        if (geo == null) {
            geo = new SingleGeo();
            geo.setType(GeoType.WAYPOINT);
        }
        SingleGeoView view = new SingleGeoView();
        container.add(view);
        List<TextListItem<Integer>> columnsEmpty = this.getColumns(lastResult.getResultSet(), true, new GraphHandler.VALUE_TYPE[0]);
        List<TextListItem<Integer>> columnsOnly = this.getColumns(lastResult.getResultSet(), false, new GraphHandler.VALUE_TYPE[0]);
        final List<TextListItem<Integer>> columnsNumbers = this.getColumns(lastResult.getResultSet(), false, GraphHandler.VALUE_TYPE.NUMBER);
        final List<TextListItem<Integer>> columnsGeos = this.getColumns(lastResult.getResultSet(), false, GraphHandler.VALUE_TYPE.GEO);
        List<TextListItem<Integer>> list = this.isLabelNumberOnly() ? columnsNumbers : (labels = this.isLabelMandatory() ? columnsOnly : columnsEmpty);
        if (this.needsMagicLabels()) {
            labels.add(new TextListItem<Integer>(-2, "<Row number>"));
            labels.add(new TextListItem<Integer>(-3, "<Graph id>"));
        }
        final AtomicBoolean suspend = new AtomicBoolean(true);
        SingleGeo geo2 = geo;
        geo.setId(id);
        APresenter<SingleGeo, WaypointModel, SingleGeoView> presenter = new APresenter<SingleGeo, WaypointModel, SingleGeoView>(model, view){

            protected void initBindings() {
                this.bind(((SingleGeoView)this.view).resultsCombo).to(results, ((WaypointModel)this.model).resultSet);
                this.bind(((SingleGeoView)this.view).latitudeCombo).to(columnsNumbers, ((WaypointModel)this.model).latitude);
                this.bind(((SingleGeoView)this.view).longitudeCombo).to(columnsNumbers, ((WaypointModel)this.model).longitude);
                this.bind(((SingleGeoView)this.view).geometryCombo).to(columnsGeos, ((WaypointModel)this.model).geometry);
                this.bind(((SingleGeoView)this.view).colorSettingCombo).to(Arrays.asList(ColorSetting.values()), ((WaypointModel)this.model).colorSetting);
                ((SingleGeoView)this.view).latitudeCombo.setEnabled(columnsNumbers.size() > 1);
                ((SingleGeoView)this.view).longitudeCombo.setEnabled(columnsNumbers.size() > 1);
                ((SingleGeoView)this.view).latLonRadio.setEnabled(columnsNumbers.size() > 1);
                ((SingleGeoView)this.view).geometryCombo.setEnabled(columnsGeos.size() > 1);
                ((SingleGeoView)this.view).geoRadio.setEnabled(columnsGeos.size() > 0 && (Integer)((TextListItem)columnsGeos.get(0)).getValue() != -1);
                this.bind(((SingleGeoView)this.view).labelCombo).to(labels, ((WaypointModel)this.model).labelToDisplay);
                this.bind(((SingleGeoView)this.view).extraLabel).to(labels, ((WaypointModel)this.model).extraLabelToDisplay);
                this.bind(((SingleGeoView)this.view).identifierCombo).to(labels, ((WaypointModel)this.model).identifier);
                ((SingleGeoView)this.view).fontChangeHyperLink.setAction((Action)new AbstractAction("Change"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int result;
                        JFontChooser fontChooser = new JFontChooser(8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 26, 28, 30, 35, 40, 50);
                        if (((WaypointModel)(this).model).font.getValue() != null) {
                            fontChooser.setSelectedFontFamily((String)((WaypointModel)(this).model).font.getValue());
                        }
                        if (((WaypointModel)(this).model).fontSize.getValue() != null) {
                            fontChooser.setSelectedFontSize((Integer)((WaypointModel)(this).model).fontSize.getValue());
                        }
                        if (((WaypointModel)(this).model).fontColor.getValue() != null) {
                            fontChooser.setSelectedFontColor((Color)((WaypointModel)(this).model).fontColor.getValue());
                        }
                        if ((result = fontChooser.showDialog(null)) == 0) {
                            Font font = fontChooser.getSelectedFont();
                            ((WaypointModel)(this).model).font.setValue((Object)font.getFontName());
                            ((WaypointModel)(this).model).fontSize.setValue((Object)fontChooser.getSelectedFontSize());
                            ((WaypointModel)(this).model).fontColor.setValue((Object)fontChooser.getSelectedFontColor());
                            ((SingleGeoView)(this).view).fontLabelPreview.setFont(font);
                            ((SingleGeoView)(this).view).fontLabelPreview.setForeground((Color)((WaypointModel)(this).model).fontColor.getValue());
                        }
                    }
                });
                this.bind(((SingleGeoView)this.view).geoColorLabel, (JComponent)this.view).to(((WaypointModel)this.model).geoColor);
                this.bind(((SingleGeoView)this.view).displayStyleCombo).to(Arrays.asList(PointVisualizer.values()), ((WaypointModel)this.model).pointIcon);
                ((SingleGeoView)this.view).geoRadio.addActionListener(l -> {
                    if (((Boolean)((WaypointModel)this.model).latLonChosen.getValue()).booleanValue()) {
                        ((SingleGeoView)this.view).changeGeoView();
                        ((WaypointModel)this.model).latLonChosen.setValue((Object)false);
                    }
                });
                ((SingleGeoView)this.view).latLonRadio.addActionListener(l -> {
                    if (!((Boolean)((WaypointModel)this.model).latLonChosen.getValue()).booleanValue()) {
                        ((SingleGeoView)this.view).changeGeoView();
                        ((WaypointModel)this.model).latLonChosen.setValue((Object)true);
                    }
                });
                this.addListenersToProperties(() -> {
                    if (!suspend.get()) {
                        listener.run();
                    }
                }, new IProperty[]{((WaypointModel)this.model).geometry, ((WaypointModel)this.model).labelToDisplay, ((WaypointModel)this.model).extraLabelToDisplay, ((WaypointModel)this.model).latLonChosen, ((WaypointModel)this.model).latitude, ((WaypointModel)this.model).longitude, ((WaypointModel)this.model).pointIcon, ((WaypointModel)this.model).colorSetting, ((WaypointModel)this.model).identifier, ((WaypointModel)this.model).font, ((WaypointModel)this.model).fontSize, ((WaypointModel)this.model).fontColor, ((WaypointModel)this.model).geoColor});
            }
        };
        presenter.setObject((Object)geo);
        view.resultsCombo.setRenderer(new LabelledCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index == -1 && comp.getText().length() > 150) {
                    comp.setText(String.valueOf(comp.getText().substring(0, 147)) + "...");
                }
                return comp;
            }
        });
        this.adjustCombo(view.latitudeCombo, view.longitudeCombo, view.labelCombo, view.extraLabel, view.geometryCombo, view.resultsCombo, view.identifierCombo);
        this.init(model, lastResult, presenter, columnsNumbers, columnsGeos, labels, view, !optgeo.isPresent());
        suspend.set(false);
        view.resultsCombo.addActionListener(a -> {
            suspend.set(true);
            this.createInner(manager, view, manager.loadPrevious((GraphResult)singleGeoView.resultsCombo.getSelectedItem(), Optional.of(geo2.getType())), container, results, (GraphResult)singleGeoView.resultsCombo.getSelectedItem(), listener, id);
        });
        this.adaptView(view);
        return geo;
    }

    protected boolean isLabelMandatory() {
        return false;
    }

    protected boolean isLabelNumberOnly() {
        return false;
    }

    protected void adaptView(SingleGeoView view) {
    }

    private void init(WaypointModel model, GraphResult result, APresenter<SingleGeo, WaypointModel, SingleGeoView> presenter, List<TextListItem<Integer>> numbers, List<TextListItem<Integer>> geo, List<TextListItem<Integer>> labels, SingleGeoView view, boolean init) {
        model.resultSet.setValue((Object)result);
        if (init) {
            model.latitude.setValue(numbers.get(0));
            model.longitude.setValue(numbers.get(0));
            model.geometry.setValue(geo.get(0));
            if (numbers.size() > 1) {
                model.longitude.setValue(numbers.get(1));
                model.latLonChosen.setValue((Object)true);
            }
            if (geo.get(0).getValue() != -1 && numbers.size() < 2) {
                model.latLonChosen.setValue((Object)false);
                view.changeGeoView();
                view.geoRadio.doClick();
            }
            if (labels.size() > 0) {
                model.labelToDisplay.setValue(labels.get(0));
                model.extraLabelToDisplay.setValue(labels.get(0));
                model.identifier.setValue(labels.get(0));
            }
            SingleGeo previous = (SingleGeo)model.getObject();
            model.pointIcon.setValue((Object)(previous.getPointIcon() != null ? previous.getPointIcon() : PointVisualizer.WAYPOINT));
        } else if (((Boolean)model.latLonChosen.getValue()).booleanValue()) {
            if ((Integer)((TextListItem)model.geometry.getValue()).getValue() == -1) {
                model.geometry.setValue(geo.get(0));
            }
        } else {
            if ((Integer)((TextListItem)model.latitude.getValue()).getValue() == -1) {
                model.latitude.setValue(numbers.get(0));
                model.longitude.setValue(numbers.get(numbers.size() > 1 ? 1 : 0));
            }
            view.changeGeoView();
            view.geoRadio.doClick();
        }
        presenter.setObject((Object)((SingleGeo)model.getObject()));
    }

    @Override
    public WaypointHolder generateWayPoints(IGeoSetting setting, GeoDisplaySettings displaySettings) {
        ArrayList<GeoWaypoint> waypoints = new ArrayList<GeoWaypoint>();
        SingleGeo geo = (SingleGeo)setting;
        IResultSetTable resultSet = setting.getChosenResultSet();
        ResultSetTableModel tm = (ResultSetTableModel)resultSet;
        RowSorter rs = tm.getSorter();
        GeoWaypoint wp1 = null;
        HashMap<Object, Color> colorMap = new HashMap<Object, Color>();
        AtomicInteger ai = new AtomicInteger(0);
        int rowCount = this.getCountFromResultSet(resultSet, displaySettings.isFiltered());
        int labelColumn = geo.getLabelToDisplay().getValue();
        int extraLabelColumn = geo.getExtraLabelToDisplay().getValue();
        int identifier = geo.getIdentifier().getValue() >= 0 ? geo.getIdentifier().getValue() : labelColumn;
        int lat = geo.getLatitude().getValue();
        int lon = geo.getLongitude().getValue();
        int geom = geo.getGeometry().getValue();
        double maxLat = 84.0;
        double minLat = -84.0;
        RowDisplayType rd = displaySettings.getRowDisplay();
        int fromRounds = Math.max(0, displaySettings.getFrom() - 1);
        int toRounds = Math.min(rowCount, displaySettings.getTo());
        int fromGroupRounds = Math.max(1, displaySettings.getFrom());
        int toGroupRounds = Math.min(rowCount, displaySettings.getTo());
        if (rd == RowDisplayType.GROUPED_BY_IDENTIFIER) {
            if (identifier < 0) {
                rd = RowDisplayType.ROWS;
            } else {
                fromRounds = 0;
                toRounds = rowCount;
            }
        }
        if (rd == RowDisplayType.ROWS && displaySettings.getLagNumber() > 0) {
            if (displaySettings.isForward()) {
                fromRounds = Math.max(0, fromRounds - displaySettings.getLagNumber());
            } else {
                toRounds = Math.min(rowCount, toRounds + displaySettings.getLagNumber());
            }
        }
        Color fixedColor = geo.getGeoColor();
        ColorPalette cp2 = rd == RowDisplayType.GROUPED_BY_IDENTIFIER ? this.getColorScheme(geo, toGroupRounds - fromGroupRounds + 1) : this.getColorScheme(geo, rowCount);
        Number n1 = null;
        Number n2 = null;
        Geometry geometry = null;
        HashMap<Integer, Set> duplicateCheck = new HashMap<Integer, Set>();
        HashMap<Object, Integer> groups = new HashMap<Object, Integer>();
        int rowX = fromRounds;
        while (rowX < toRounds) {
            block34: {
                Color c;
                Object extraLabel;
                Object label;
                block37: {
                    int row;
                    block36: {
                        block35: {
                            block31: {
                                Object groupIdentifier;
                                block32: {
                                    Integer value;
                                    block33: {
                                        row = rowX;
                                        if (rs != null && displaySettings.isFiltered()) {
                                            row = rs.convertRowIndexToModel(row);
                                        }
                                        label = null;
                                        extraLabel = null;
                                        groupIdentifier = null;
                                        c = Color.GRAY;
                                        if (labelColumn >= 0) {
                                            label = resultSet.getAbbreviatedValueForDisplay(row, labelColumn);
                                        } else if (labelColumn == -2) {
                                            label = row;
                                        } else if (labelColumn == -3) {
                                            label = geo.getId();
                                        }
                                        if (extraLabelColumn >= 0) {
                                            extraLabel = resultSet.getAbbreviatedValueForDisplay(row, extraLabelColumn);
                                        } else if (extraLabelColumn == -2) {
                                            extraLabel = row;
                                        } else if (extraLabelColumn == -3) {
                                            extraLabel = geo.getId();
                                        }
                                        if (identifier < 0) break block31;
                                        groupIdentifier = resultSet.getValueAt(row, identifier);
                                        if (rd != RowDisplayType.GROUPED_BY_IDENTIFIER) break block32;
                                        value = (Integer)groups.get(groupIdentifier != null ? groupIdentifier : this);
                                        if (value != null) break block33;
                                        if (groups.size() >= toGroupRounds) break block34;
                                        groups.put(groupIdentifier, groups.size() + 1);
                                        if (groups.size() >= fromGroupRounds && groups.size() <= toGroupRounds) break block32;
                                        break block34;
                                    }
                                    if (value < fromGroupRounds || value > toGroupRounds) break block34;
                                }
                                if (groupIdentifier != null) {
                                    c = colorMap.computeIfAbsent(groupIdentifier, o -> cp2.getColor(Double.valueOf(ai.getAndIncrement())));
                                }
                                break block35;
                            }
                            c = cp2.getColor(Double.valueOf(ai.getAndIncrement()));
                        }
                        if (!geo.isLatLonChosen()) break block36;
                        n1 = (Number)resultSet.getValueAt(row, lat);
                        n2 = (Number)resultSet.getValueAt(row, lon);
                        if (n1 == null || n2 == null) break block34;
                        if (n1.doubleValue() > maxLat) {
                            n1 = maxLat;
                        } else if (n1.doubleValue() < minLat) {
                            n1 = minLat;
                        }
                        if (n2.doubleValue() > 1000.0) {
                            n2 = 1000.0;
                        } else if (n2.doubleValue() < -1000.0) {
                            n2 = -1000.0;
                        }
                        break block37;
                    }
                    GeometryHolder gg = (GeometryHolder)resultSet.getValueAt(row, geom);
                    if (gg == null || (geometry = gg.getGeo()) == null) break block34;
                    int sridGeos = gg.getSrid();
                    if (displaySettings.isDeleteDups() && !gg.getWkt().startsWith("POINT") && !gg.getWkt().startsWith("LINESTRING") && !duplicateCheck.computeIfAbsent(sridGeos, f -> new HashSet()).add(gg.getWkt())) break block34;
                }
                if (geo.isLatLonChosen()) {
                    geometry = ((GeometryFactory)WaypointHandler.getReaderFromSRID(4326).first()).createPoint(new Coordinate(n2.doubleValue(), n1.doubleValue()));
                }
                wp1 = new GeoWaypoint(this.getLabelFromLabels(label, extraLabel, extraLabelColumn), fixedColor != null ? fixedColor : c, geometry);
                waypoints.add(wp1);
            }
            ++rowX;
        }
        WaypointHolder waypointHolder = new WaypointHolder(waypoints);
        waypointHolder.setFont(geo.getFont());
        waypointHolder.setFontSize(geo.getFontSize());
        waypointHolder.setFontColor(geo.getFontColor());
        return waypointHolder;
    }

    String getLabelFromLabels(Object label1, Object label2, int extraLabelColumn) {
        StringBuilder sb = new StringBuilder();
        if (label1 != null) {
            sb.append(label1);
            if (label2 != null) {
                sb.append(" - ").append(label2);
            }
            return sb.toString();
        }
        if (label2 != null) {
            return label2.toString();
        }
        return null;
    }

    private ColorPalette getColorScheme(SingleGeo geo, int rowCount) {
        ColorPalette cp = new FixedColorPalette(ColorUtils.COLOR_PALETTE5, Color.GRAY);
        if (geo.getColorSetting() == ColorSetting.MONOCHROME) {
            cp = new FixedColorPalette(Arrays.asList(Color.BLACK), Color.BLACK);
        } else if (rowCount > 20) {
            cp = PaletteManager.create(rowCount, Arrays.asList(Color.BLACK, Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED), Color.GRAY, 255);
        } else if (rowCount > 10) {
            cp = new FixedColorPalette(ColorUtils.COLOR_PALETTE20, Color.BLACK);
        } else if (rowCount > 5) {
            cp = new FixedColorPalette(ColorUtils.COLOR_PALETTE11, Color.BLACK);
        }
        return cp;
    }

    private static class WaypointModel
    extends AGeoWaypointModel<SingleGeo> {
        private WaypointModel() {
        }
    }
}

