/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo.options;

import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.geo.GeoDisplaySettings;
import com.sigge.filerunner.view.results.graph.geo.IGeoManager;
import com.sigge.filerunner.view.results.graph.geo.LayerWaypoint;
import com.sigge.filerunner.view.results.graph.geo.WaypointHolder;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.sigge.filerunner.view.results.graph.geo.options.SingleGeo;
import com.sigge.filerunner.view.results.graph.geo.options.SingleGeoView;
import com.sigge.filerunner.view.results.graph.geo.options.WaypointHandler;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.RowSorter;
import org.jxmapviewer.viewer.Waypoint;

public class HeatmapHandler
extends WaypointHandler {
    private static final double MIN_LAT_HEAT = -86.0;
    private static final double MAX_LAT_HEAT = 86.0;

    @Override
    public WaypointHolder<Waypoint> generateWayPoints(IGeoSetting setting, GeoDisplaySettings displaySettings) {
        ArrayList<LayerWaypoint> waypoints = new ArrayList<LayerWaypoint>();
        SingleGeo geo = (SingleGeo)setting;
        IResultSetTable resultSet = setting.getChosenResultSet();
        ResultSetTableModel tm = (ResultSetTableModel)resultSet;
        RowSorter rs = tm.getSorter();
        LayerWaypoint wp1 = null;
        int rowCount = this.getCountFromResultSet(resultSet, displaySettings.isFiltered());
        int identifier = geo.getLabelToDisplay().getValue();
        int lat = geo.getLatitude().getValue();
        int lon = geo.getLongitude().getValue();
        double maxLat = 86.0;
        double minLat = -86.0;
        int fromRounds = Math.max(0, displaySettings.getFrom() - 1);
        int toRounds = Math.min(rowCount, displaySettings.getTo());
        if (displaySettings.getLagNumber() > 0) {
            if (displaySettings.isForward()) {
                fromRounds = Math.max(0, fromRounds - displaySettings.getLagNumber());
            } else {
                toRounds = Math.min(rowCount, toRounds + displaySettings.getLagNumber());
            }
        }
        Number n1 = null;
        Number n2 = null;
        int rowX = fromRounds;
        while (rowX < toRounds) {
            int row = rowX;
            if (rs != null && displaySettings.isFiltered()) {
                row = rs.convertRowIndexToModel(row);
            }
            n1 = (Number)resultSet.getValueAt(row, lat);
            n2 = (Number)resultSet.getValueAt(row, lon);
            if (n1 != null && n2 != null) {
                if (n1.doubleValue() > maxLat) {
                    n1 = maxLat;
                } else if (n1.doubleValue() < minLat) {
                    n1 = minLat;
                }
                if (n2.doubleValue() > 1000.0) {
                    n2 = 1000.0;
                } else if (n2.doubleValue() < -1000.0) {
                    n2 = -1000.0;
                }
                Object label = null;
                label = resultSet.getValueAt(row, identifier);
                if (label != null && label instanceof Number && setting.getMathBuilder().isPresent()) {
                    geo.getMathBuilder().get().accept((Number)label);
                }
                wp1 = new LayerWaypoint(n1.doubleValue(), n2.doubleValue(), label == null ? null : Double.valueOf(((Number)label).doubleValue()));
                waypoints.add(wp1);
            }
            ++rowX;
        }
        return new WaypointHolder<Waypoint>(waypoints);
    }

    @Override
    public IGeoSetting create(IGeoManager manager, Container container, List<GraphResult> results, GraphResult lastResult, Optional<IGeoSetting> optgeo, Runnable listener, String id) {
        IGeoSetting geo = super.create(manager, container, results, lastResult, optgeo, listener, id);
        ((SingleGeo)geo).setType(GeoType.HEATMAP);
        return geo;
    }

    @Override
    protected boolean needsMagicLabels() {
        return false;
    }

    @Override
    protected void adaptView(SingleGeoView view) {
        super.adaptView(view);
        view.geoRadio.setEnabled(false);
        view.displayStyleCombo.setEnabled(false);
        view.displayStyleCombo.setSelectedItem(null);
        view.labelLabel.setText("Value to display:");
        view.identifierCombo.setEnabled(false);
        view.identifierCombo.setVisible(false);
        view.identifierLabel.setVisible(false);
        view.fontChangeHyperLink.setVisible(false);
        view.fontLabelPreview.setVisible(false);
        view.extraLabel.setVisible(false);
        view.geoColorLabel.setEnabled(false);
        view.extraLabelLabel.setVisible(false);
    }

    @Override
    protected boolean isLabelMandatory() {
        return true;
    }

    @Override
    protected boolean isLabelNumberOnly() {
        return true;
    }
}

