/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.view.results.graph.geo.options.AWaypointRenderer;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryCollection {
    private static final String COLOR_ATTRIBUTE = "color";
    private static final String LABEL_PROPERTY = "label";
    SimpleFeatureBuilder featureBuilder;
    List<SimpleFeature> features = new ArrayList<SimpleFeature>();
    SimpleFeatureCollection collection;
    Style shpStyle;
    Layer shpLayer;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryCollection.class);

    public GeometryCollection(String type, int srid, int zoom, PointVisualizer icon, String font, Integer size, Color fontColor) {
        try {
            SimpleFeatureType featureType = DataUtilities.createType((String)"Location", (String)("the_geom:" + type + ":srid=" + srid + ",label:String,color:String"));
            this.featureBuilder = new SimpleFeatureBuilder(featureType);
            this.collection = new ListFeatureCollection(featureType, this.features);
            this.shpStyle = icon == PointVisualizer.EMPTY ? SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{AWaypointRenderer.createLabelStyle(zoom, LABEL_PROPERTY, font, size, fontColor)}) : (type.equals("Point") ? AWaypointRenderer.createPointStyle(icon, zoom, COLOR_ATTRIBUTE, LABEL_PROPERTY, font, size, fontColor) : (type.equals("LineString") ? AWaypointRenderer.createLineStyle(zoom, COLOR_ATTRIBUTE, 0.9f, 2.0f, LABEL_PROPERTY, font, size, fontColor) : AWaypointRenderer.createPolygonStyle(zoom, Color.BLACK, COLOR_ATTRIBUTE, 0.5f, LABEL_PROPERTY, font, size, fontColor)));
            this.shpLayer = new FeatureLayer((FeatureCollection)this.collection, this.shpStyle);
        }
        catch (Exception ex) {
            LOGGER.error("Error creating feature layer", (Throwable)ex);
        }
    }
}

