/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.IGraphSetting;
import com.sigge.filerunner.view.results.graph.ResultColumnMapper;
import com.sigge.filerunner.view.results.graph.geo.GeoConfig;
import com.sigge.filerunner.view.results.graph.geo.IGeoManager;
import com.sigge.filerunner.view.results.graph.geo.PlaySpeed;
import com.sigge.filerunner.view.results.graph.geo.options.FromToGeo;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.sigge.filerunner.view.results.graph.geo.options.SingleGeo;
import com.siggemannen.backgroundrunner.AccumulatedBackgroundRunner;
import com.siggemannen.core.Tuple;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoManager
implements IGeoManager {
    private static final String FILENAME = "db/geo.json";
    private final int MAX_SETTINGS = 500;
    private GeoType lastType = null;
    private PlaySpeed lastPlaySpeed = PlaySpeed.FAST;
    private static final String SETTING_FILE_ENCODING = "UTF-8";
    private final List<IGeoSetting> settings = new ArrayList<IGeoSetting>();
    private static final Gson GSON_WRITER = GsonFactory.forWriting();
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoManager.class);

    public GeoManager() {
        new Thread(this::init).start();
    }

    @Override
    public synchronized void store(IGeoSetting setting) {
        this.settings.add(0, (IGeoSetting)setting.toStorage());
        if (this.settings.size() > 500) {
            this.settings.remove(this.settings.size() - 1);
        }
        this.lastType = setting.getType();
        this.storeInternal();
    }

    @Override
    public Optional<IGeoSetting> loadPrevious(GraphResult gr, Optional<GeoType> preferredtype) {
        ResultColumnMapper fcm = new ResultColumnMapper(gr, false);
        for (IGeoSetting setting : this.settings) {
            Optional<IGeoSetting> res;
            if (preferredtype.isPresent() && preferredtype.get() != setting.getType() || !(res = setting.resolveFromStorage(fcm)).isPresent() || !res.map(IGraphSetting::isValid).orElse(false).booleanValue()) continue;
            return res;
        }
        return Optional.empty();
    }

    private void storeInternal() {
        AccumulatedBackgroundRunner.schedule((String)"saveGeoStorage", () -> this.store(), (int)300, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void init() {
        GeoConfig CONFIG;
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FILENAME), SETTING_FILE_ENCODING);){
                CONFIG = (GeoConfig)GsonFactory.forReading().fromJson((Reader)reader, GeoConfig.class);
                if (CONFIG == null) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonSyntaxException jsonE) {
            LOGGER.error("Couldn't load config file", (Throwable)jsonE);
            return;
        }
        catch (FileNotFoundException fe) {
            return;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't load config file", (Throwable)e);
            return;
        }
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        list.addAll(CONFIG.heatMapGeos.stream().map(x -> Tuple.of((Object)((Integer)x.first()), (Object)((IGeoSetting)x.second()))).collect(Collectors.toList()));
        list.addAll(CONFIG.singleGeos.stream().map(x -> Tuple.of((Object)((Integer)x.first()), (Object)((IGeoSetting)x.second()))).collect(Collectors.toList()));
        list.addAll(CONFIG.tripGeos.stream().map(x -> Tuple.of((Object)((Integer)x.first()), (Object)((IGeoSetting)x.second()))).collect(Collectors.toList()));
        this.lastPlaySpeed = CONFIG.playSpeed != null ? CONFIG.playSpeed : PlaySpeed.FAST;
        list.sort(Comparator.comparing(Tuple::first));
        for (Tuple t : list) {
            this.settings.add((IGeoSetting)t.second());
        }
        if (this.settings.size() > 0) {
            this.lastType = this.settings.get(0).getType();
        }
    }

    private synchronized void store() {
        GeoConfig CONFIG = new GeoConfig();
        int i2 = 0;
        while (i2 < this.settings.size()) {
            IGeoSetting set = this.settings.get(i2);
            if (set instanceof SingleGeo && set.getType() == GeoType.WAYPOINT) {
                CONFIG.singleGeos.add((Tuple<Integer, SingleGeo>)Tuple.of((Object)i2, (Object)((SingleGeo)set)));
            } else if (set instanceof SingleGeo && set.getType() == GeoType.HEATMAP) {
                CONFIG.heatMapGeos.add((Tuple<Integer, SingleGeo>)Tuple.of((Object)i2, (Object)((SingleGeo)set)));
            } else {
                CONFIG.tripGeos.add((Tuple<Integer, FromToGeo>)Tuple.of((Object)i2, (Object)((FromToGeo)set)));
            }
            ++i2;
        }
        CONFIG.playSpeed = this.lastPlaySpeed;
        try {
            Throwable i2 = null;
            Object var3_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(FILENAME), SETTING_FILE_ENCODING);){
                GSON_WRITER.toJson((Object)CONFIG, (Appendable)writer);
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save geo file for some reason", (Throwable)e);
        }
    }

    public GeoType getLastType() {
        return this.lastType;
    }

    public PlaySpeed getLastPlaySpeed() {
        return this.lastPlaySpeed;
    }

    public void setLastPlaySpeed(PlaySpeed lastPlaySpeed) {
        this.lastPlaySpeed = lastPlaySpeed;
    }
}

