/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph;

import com.sigge.filerunner.view.results.graph.ColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaletteManager {
    public static ColorPalette create(int range, Color from, Color to) {
        return PaletteManager.create(range, from, to, null, 50);
    }

    public static ColorPalette create(int range, Color from, Color to, Color defaultColor, int opacity) {
        PaletteManager paletteManager = new PaletteManager();
        paletteManager.getClass();
        return new Palette(paletteManager.new Range(0.0, (double)range * 1.0, from, to, defaultColor, opacity));
    }

    public static ColorPalette create(int range, List<Color> colors, Color defaultColor, int opacity) {
        return new MultiPalette(range, colors, defaultColor, opacity);
    }

    public static ColorPalette create(int range) {
        return PaletteManager.create(range, Color.RED, Color.GREEN);
    }

    static class MultiPalette
    implements ColorPalette {
        private final List<Range> ranges = new ArrayList<Range>();
        private final Color defaultColor;
        private final int split;

        MultiPalette(int range, List<Color> colors, Color defaultColor, int opacity) {
            this.defaultColor = defaultColor;
            this.split = (int)Math.ceil((double)range / (double)(colors.size() - 1));
            double prev = 0.0;
            Color c = colors.get(0);
            int i = 1;
            while (i < colors.size()) {
                Color c2 = colors.get(i);
                PaletteManager paletteManager = new PaletteManager();
                paletteManager.getClass();
                this.ranges.add(paletteManager.new Range(prev, prev + (double)this.split - 1.0, c, c2, defaultColor, opacity));
                c = c2;
                prev += (double)this.split;
                ++i;
            }
        }

        @Override
        public Color getColor(Double value) {
            if (value == null) {
                return this.defaultColor;
            }
            int rangeIndex = this.getIndex(value);
            return this.ranges.get(rangeIndex).interpolate(value);
        }

        private int getIndex(Double value) {
            int split = (int)Math.floor(value / (double)this.split);
            if (split >= this.ranges.size()) {
                return this.ranges.size() - 1;
            }
            return split;
        }
    }

    static class Palette
    implements ColorPalette {
        private final Range range;

        Palette(Range r) {
            this.range = r;
        }

        @Override
        public Color getColor(Double value) {
            return this.range.interpolate(value);
        }
    }

    public class Range {
        Double from;
        Double to;
        Color fromColor;
        Color toColor;
        private final Map<Integer, Color> COLOR_CACHE = new HashMap<Integer, Color>();
        private final Color defaultColor;
        private final int opacity;

        Range(Double from, Double to, Color fromColor, Color toColor, Color defaultColor, int opacity) {
            this.from = from;
            this.to = to;
            this.fromColor = fromColor;
            this.toColor = toColor;
            this.defaultColor = defaultColor;
            this.opacity = opacity;
        }

        Color interpolate(Double value) {
            if (this.fromColor == null || this.toColor == null || value == null || value < this.from || value > this.to) {
                return this.defaultColor;
            }
            return this.gradientColor(value, this.from, this.to, this.fromColor, this.toColor);
        }

        private Color gradientColor(Double x, Double minX, Double maxX, Color from, Color to) {
            Double range = maxX - minX;
            Double p = (x - minX) / range;
            int r = this.getColor(from.getRed(), to.getRed(), p);
            int g = this.getColor(from.getGreen(), to.getGreen(), p);
            int b = this.getColor(from.getBlue(), to.getBlue(), p);
            return this.COLOR_CACHE.computeIfAbsent(r + g * 1000 + b * 1000000, z -> new Color(r, g, b, this.opacity));
        }

        private int getColor(int colorFrom, int colorTo, Double p) {
            return (int)((double)colorTo * p + (double)colorFrom * (1.0 - p));
        }
    }
}

