/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph;

import com.google.common.reflect.TypeToken;
import com.sigge.filerunner.core.JsonStorer;
import com.sigge.filerunner.core.StoreItem;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.siggemannen.backgroundrunner.AccumulatedBackgroundRunner;
import com.siggemannen.core.ListUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AGraphManager<T> {
    protected final int MAX_SETTINGS = 500;
    protected List<T> settings = new ArrayList<T>();
    protected JsonStorer<List<T>> STORER = null;
    protected StoreItem<List<T>> storeItem;
    private final String type;

    public AGraphManager(String type, TypeToken<List<T>> tt) {
        this.type = type;
        try {
            this.STORER = new JsonStorer(type, tt.getType());
            new Thread(this::init).start();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public AGraphManager(String type, int version, JsonStorer.JsonUpgrader tt) {
        this.type = type;
        try {
            this.STORER = new JsonStorer(type, version, tt);
            new Thread(this::init).start();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public synchronized void store(T setting) {
        this.settings.add(setting);
        if (this.settings.size() > 500) {
            this.settings.remove(0);
        }
        this.storeInternal();
    }

    protected void storeInternal() {
        if (this.STORER == null) {
            return;
        }
        AccumulatedBackgroundRunner.schedule((String)this.type, () -> this.store(), (int)300, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected void init() {
        List<StoreItem<List<T>>> items = this.STORER.listItems();
        if (items != null && items.size() > 0) {
            this.storeItem = items.get(0);
            List<T> item = this.storeItem.getItem();
            this.settings = new ArrayList<T>(item);
        } else {
            this.settings = new ArrayList<T>();
            this.storeItem = new StoreItem<List<T>>(this.settings);
        }
    }

    protected synchronized void store() {
        this.STORER.updateItem(this.storeItem.updateItem(this.settings));
    }

    protected List<TextListItem<Integer>> getColumns(IResultSetTable m, boolean onlyNumbers) {
        ArrayList<TextListItem<Integer>> cols = new ArrayList<TextListItem<Integer>>();
        int i = 0;
        while (i < m.getColumnCount()) {
            FieldType fieldType = m.getFieldType(i);
            if (!onlyNumbers || ListUtils.in((Object)((Object)fieldType), (Object[])new FieldType[]{FieldType.SQLLONG, FieldType.SQLFLOAT, FieldType.SQLINTEGER, FieldType.SQLBOOLEAN})) {
                cols.add(new TextListItem<Integer>(i, m.getColumnName(i)));
            }
            ++i;
        }
        return cols;
    }
}

