/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.export;

import com.sigge.filerunner.sql.RunContext;
import com.sigge.filerunner.sql.Server;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.results.IResultSetTable;
import java.io.File;

public class FileResult
implements ILabel {
    private final IResultSetTable rstm;
    private final File file;
    private final String path;
    private final String server;
    private final String database;
    private final String label;

    public FileResult(IResultSetTable rstm, File file, RunContext context) {
        this(rstm, null, file, context.getServer());
    }

    public FileResult(String label, File file, RunContext context) {
        this(null, label, file, context.getServer());
    }

    public FileResult(IResultSetTable rstm, String label, File file, Server server) {
        this.rstm = rstm;
        this.label = label;
        this.file = file;
        this.path = file.getAbsolutePath();
        this.server = server != null && server.getDatabase() != null ? server.getDatabase().getLabel() : "";
        this.database = server.getDatabases().size() > 0 ? server.getDatabases().get(0) : "";
    }

    public IResultSetTable getResultSet() {
        return this.rstm;
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.getModelDescription(this.rstm);
    }

    private String getModelDescription(IResultSetTable model) {
        StringBuilder sb = new StringBuilder();
        sb.append("Rows: ").append(model.getRowCount());
        sb.append(", Columns: ");
        for (int col = 0; col < model.getColumnCount(); ++col) {
            sb.append(model.getColumnName(col));
            if (col >= model.getColumnCount() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getServer() {
        return this.server;
    }

    public String getDatabase() {
        return this.database;
    }
}

