/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.sigge.dbrunner.SQLRunnerException;
import com.siggemannen.core.Tuple;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class ResultSetPresenterHelper {
    public static String getExceptionTraceFromException(Exception exception) {
        return (String)ResultSetPresenterHelper.getExceptionInformationFromException(exception).second();
    }

    public static Tuple<Long, String> getExceptionInformationFromException(Exception exception) {
        long line = 0L;
        if (exception instanceof SQLServerException) {
            SQLServerException error = (SQLServerException)exception;
            String exceptionError = "State: " + error.getSQLState() + ", error code: " + error.getErrorCode();
            String exceptionMessage = error.getMessage();
            if (error.getSQLServerError() != null) {
                line = error.getSQLServerError().getLineNumber();
                exceptionError = String.valueOf(exceptionError) + ", Line: " + line + ", ProcName:" + error.getSQLServerError().getProcedureName();
                exceptionMessage = error.getSQLServerError().getErrorMessage();
            }
            exceptionError = String.valueOf(exceptionError) + "\n" + exceptionMessage;
            return Tuple.of((Object)line, (Object)exceptionError);
        }
        if (exception instanceof SQLRunnerException) {
            SQLRunnerException error = (SQLRunnerException)exception;
            String exceptionError = "State: " + error.getSQLState() + ", error code: " + error.getErrorCode();
            if (error.getErrorSeverity() > 0) {
                line = error.getLineNumber();
                exceptionError = String.valueOf(exceptionError) + ", Line: " + line + ", ProcName:" + error.getProcedureName();
            }
            exceptionError = String.valueOf(exceptionError) + "\n" + error.getMessage();
            return Tuple.of((Object)line, (Object)exceptionError);
        }
        if (exception instanceof SQLException) {
            SQLException error = (SQLException)exception;
            return Tuple.of((Object)line, (Object)(String.valueOf(error.getMessage()) + "\nState: " + error.getSQLState() + ", error code: " + error.getErrorCode()));
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter sw = new PrintWriter(stringWriter);
        exception.printStackTrace(sw);
        return Tuple.of((Object)line, (Object)stringWriter.toString());
    }
}

