/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.export.ExportResult;
import com.sigge.filerunner.sql.IOutput;
import com.sigge.filerunner.sql.IResultSetProcessor;
import com.sigge.filerunner.sql.OutputBuilder;
import com.sigge.filerunner.sql.OutputFormat;
import com.sigge.filerunner.sql.RunContext;
import com.sigge.filerunner.sql.Server;
import com.sigge.filerunner.sql.sqlserver.SQLServerResultSetProcessor;
import com.sigge.filerunner.view.DefaultTableTransferHandler;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.AggregatedMouseListener;
import com.sigge.filerunner.view.core.ButtonTabComponent;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.IResultView;
import com.sigge.filerunner.view.results.InlineResultView;
import com.sigge.filerunner.view.results.MouseDoubleClickOnTableAdaptor;
import com.sigge.filerunner.view.results.MultiResultPane;
import com.sigge.filerunner.view.results.ResultSetData;
import com.sigge.filerunner.view.results.ResultSetPresenterHelper;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.ResultSetTableSortController;
import com.sigge.filerunner.view.results.ResultSetTextPresenter;
import com.sigge.filerunner.view.results.ResultTableHandler;
import com.sigge.filerunner.view.results.TimeStampWrapperHandler;
import com.sigge.filerunner.view.results.export.FileResult;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.tabs.ITabManagerSwitcher;
import com.sigge.filerunner.view.tabs.TabSwitcherListener;
import com.sigge.filerunner.view.tabs.TabUtils;
import com.siggemannen.core.MapBuilder;
import com.siggemannen.core.Tuple;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.oxbow.swingbits.table.filter.PredicateFactory;
import org.oxbow.swingbits.table.filter.TableRowFilterSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetPresenter {
    public static final String ERROR_LINE_ATTRIBUTE = "ERROR_LINE";
    private static final ImageIcon CLOSE_ICON = IconUtils.getSmallIcon("close.png");
    private final IResultView view;
    private final Map<Server, MultiResultPane> servers = new HashMap<Server, MultiResultPane>();
    private Tuple<RunContext, IResultSetTable> selectedModel = null;
    private final List<Tuple<RunContext, IResultSetTable>> models = new ArrayList<Tuple<RunContext, IResultSetTable>>();
    private final List<Server> tabs = new ArrayList<Server>();
    private boolean results = false;
    private boolean qp = false;
    private boolean files = false;
    private boolean errors = false;
    private boolean aborted = false;
    private boolean switched = false;
    private static final SimpleAttributeSet ERROR_STYLE = ResultSetPresenter.createErrorStyle();
    private static final SimpleAttributeSet WARNING_STYLE = ResultSetPresenter.createWarningStyle();
    private static final SimpleAttributeSet RUNNING_HEADER_STYLE = ResultSetPresenter.createRunningHeaderStyle();
    private final ResultSetTextPresenter rstp = new ResultSetTextPresenter();
    private final ResultTableHandler tableHandler;
    private RunContext previousContext = null;
    private final Map<String, IResultSetTable> repository;
    private static final Map<String, IResultSetProcessor> PROCESSORS = ResultSetPresenter.createProcessors();
    private static Logger LOGGER = LoggerFactory.getLogger(ResultSetPresenter.class);

    public ResultSetPresenter(IResultView view, ITabManagerSwitcher tabManagerSwitcher, ResultTableHandler tableHandler, Map<String, IResultSetTable> repository) {
        this.view = view;
        this.tableHandler = tableHandler;
        this.repository = repository;
        this.view.getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                final JTabbedPane pane = ResultSetPresenter.this.view.getView();
                final int tabNr = TabUtils.getTabForMouseEvent(pane, me);
                if (tabNr == -1) {
                    return;
                }
                if (ButtonUtils.isRightClick(me)) {
                    JPopupMenu pp = new JPopupMenu("Close tab");
                    JMenuItem menuItem = new JMenuItem(new AbstractAction("Close tab", CLOSE_ICON){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            pane.remove(tabNr);
                            ResultSetPresenter.this.removeTab((Server)ResultSetPresenter.this.tabs.get(tabNr));
                        }
                    });
                    pp.add(menuItem);
                    MultiResultPane s = (MultiResultPane)ResultSetPresenter.this.servers.get(ResultSetPresenter.this.tabs.get(tabNr));
                    if (s != null && s.isStarted()) {
                        menuItem.setEnabled(false);
                    }
                    pp.show(pane, me.getX(), me.getY());
                } else if (me.getButton() == 2) {
                    pane.remove(tabNr);
                    ResultSetPresenter.this.removeTab((Server)ResultSetPresenter.this.tabs.get(tabNr));
                }
            }
        });
        tabManagerSwitcher.register(this.view.getView());
        this.view.getView().addContainerListener(new TabSwitcherListener(tabManagerSwitcher));
    }

    private static Map<String, IResultSetProcessor> createProcessors() {
        return new MapBuilder().append((Object)"MSSQL", (Object)new SQLServerResultSetProcessor()).build();
    }

    private static SimpleAttributeSet createRunningHeaderStyle() {
        SimpleAttributeSet runningHeaderStyle = new SimpleAttributeSet();
        StyleConstants.setItalic(runningHeaderStyle, true);
        return runningHeaderStyle;
    }

    private static SimpleAttributeSet createWarningStyle() {
        SimpleAttributeSet warning = new SimpleAttributeSet();
        StyleConstants.setBold(warning, true);
        return warning;
    }

    private static SimpleAttributeSet createErrorStyle() {
        SimpleAttributeSet errorStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(errorStyle, Color.RED);
        StyleConstants.setBackground(errorStyle, Color.YELLOW);
        StyleConstants.setBold(errorStyle, true);
        return errorStyle;
    }

    public void serverFinished(RunContext context) {
        this.previousContext = null;
        MultiResultPane pane = this.servers.get(context.getServer());
        if (pane != null) {
            LocalDateTime serverFinished = context.getServerFinished();
            LocalDateTime serverStarted = context.getServerStarted();
            String text = "-- Finished " + DateUtils.formatLocalDate(serverFinished != null ? serverFinished : LocalDateTime.now());
            if (serverFinished != null && serverStarted != null) {
                text = String.valueOf(text) + ", took: " + DateUtils.dateDiff(serverStarted, serverFinished);
            }
            String text2 = text;
            SwingUtilities.invokeLater(() -> TextPaneUtil.addText(pane.getTextOutput(), text2));
            pane.finishExecution();
            pane.highlightResultsTab(this.results);
            if (this.errors || this.results && context.getOutputFormat().getFormat() == OutputFormat.TEXT || !this.results && !this.qp && !this.files) {
                pane.selectMessageTab();
            } else if (this.qp && !this.results) {
                pane.selectQPTab();
            } else if (this.files) {
                pane.selectFileTab();
            } else {
                pane.selectResultsTab();
            }
        }
    }

    public void serverStarted(RunContext context) {
        Server server = context.getServer();
        if (ResultSetPresenter.clearResultBeforeExec().booleanValue() && this.servers.containsKey(server)) {
            LOGGER.error("Shouldn't reach here, but did for context {}", (Object)context);
            int index = this.tabs.indexOf(server);
            if (index > -1) {
                this.view.getView().remove(index);
            }
            this.removeTab(server);
        }
        this.results = false;
        this.qp = false;
        this.files = false;
        this.errors = false;
        this.aborted = false;
        this.switched = false;
        if (!this.servers.containsKey(server)) {
            this.createRunningTab(server);
        } else if (this.models.size() > 0) {
            MultiResultPane pane = this.servers.get(server);
            pane.startNewExecution();
        }
        TextPaneUtil.addText(this.servers.get(server).getTextOutput(), "-----------------------------------------------------------------------------------------");
        TextPaneUtil.addText(this.servers.get(server).getTextOutput(), "-- Started  " + DateUtils.formatLocalDate(context.getServerStarted() != null ? context.getServerStarted() : LocalDateTime.now()));
    }

    private void createRunningTab(final Server server) {
        JPanel panel = new JPanel();
        BoxLayout b = new BoxLayout(panel, 1);
        panel.setLayout(b);
        MultiResultPane pane = new MultiResultPane();
        panel.add(pane.getPane());
        pane.startNewExecution();
        JPopupMenu clearResultMenu = new JPopupMenu("Clear results");
        clearResultMenu.add(new JMenuItem(new AbstractAction("Clear results", CLOSE_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultSetPresenter.this.removeResults(server);
            }
        }));
        this.view.getView().addTab(server.toString(), panel);
        this.tabs.add(server);
        JLabel tabLabel = new JLabel(server.toString());
        this.view.getView().setTabComponentAt(this.view.getView().getTabCount() - 1, new ButtonTabComponent(this.view.getView(), tabLabel, e -> {
            this.view.getView().remove((int)e);
            this.removeTab(this.tabs.get((int)e));
        }));
        this.view.getView().setSelectedIndex(this.view.getView().getTabCount() - 1);
        this.servers.put(server, pane);
    }

    public ResultSetData present(Statement s, RunContext context, Exception exception, boolean result) {
        Integer index = this.tabs.indexOf(context.getServer());
        if (index != -1) {
            this.view.getView().setSelectedIndex(index);
        }
        MultiResultPane pane = this.servers.get(context.getServer());
        Optional<IResultSetProcessor> pr = Optional.ofNullable(PROCESSORS.get(context.getServer().getDatabase().getDatabaseProvider()));
        JTextComponent logOutputPane = pane.getTextOutput();
        if (!context.equals(this.previousContext)) {
            TextPaneUtil.addText(logOutputPane, "-- Running @" + context.getDatabase(), RUNNING_HEADER_STYLE);
            if (context.getFile() != null) {
                TextPaneUtil.addText(logOutputPane, "-- File: " + context.getFile().getAbsolutePath(), RUNNING_HEADER_STYLE);
            }
        }
        StringBuilder sb = new StringBuilder(context.getOutputFormat().getFormat() == OutputFormat.TEXT ? 1000000 : 100);
        ValueHolder<SQLWarning> lastWarning = new ValueHolder<SQLWarning>();
        if (exception != null) {
            this.errors = true;
            if (s != null) {
                try {
                    this.addWarningsToPane(s.getWarnings(), lastWarning, pane, sb, pr);
                    s.clearWarnings();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            Tuple<Long, String> exceptionStacktrace = ResultSetPresenterHelper.getExceptionInformationFromException(exception);
            this.addErrorText((String)exceptionStacktrace.second(), (Long)exceptionStacktrace.first(), context.getOptions(), pane);
            pane.selectMessageTab();
        }
        this.previousContext = context;
        int resultSets = 0;
        int resultRows = 0;
        int cnt = 0;
        int loopcount = 0;
        boolean innerResult = result;
        if (s != null) {
            block10: while (true) {
                try {
                    while (true) {
                        this.addWarningsToPane(s.getWarnings(), lastWarning, pane, sb, pr);
                        s.clearWarnings();
                        if (loopcount > 0) {
                            innerResult = s.getMoreResults();
                            this.addWarningsToPane(s.getWarnings(), lastWarning, pane, sb, pr);
                        }
                        ++loopcount;
                        s.clearWarnings();
                        if (innerResult) {
                            ResultSet r = s.getResultSet();
                            if (r == null) continue;
                            this.addWarningsToPane(r.getWarnings(), lastWarning, pane, sb, pr);
                            LocalDateTime dt = DateUtils.getTimeAtUTC();
                            if (context.getOutputFormat().getFormat() == OutputFormat.SCRIPT) {
                                OutputBuilder.ScriptOutput so = (OutputBuilder.ScriptOutput)context.getOutputFormat();
                                so.getPreferences().setCancelled(() -> context.getOptions().isCancelled());
                                Optional<File> x = so.getScripter().script(so, context.getServer().getDatabase(), r);
                                if (x.isPresent()) {
                                    pane.addFilePane(new FileResult(this.getLabelFromMeta(r.getMetaData()), x.get(), context));
                                    this.files = true;
                                }
                            } else {
                                boolean res;
                                ResultSetTableModel rstm = null;
                                Exception exp = null;
                                try {
                                    rstm = new ResultSetTableModel(r, context.getOptions());
                                }
                                catch (Exception ex) {
                                    exp = ex;
                                }
                                pane.getPane().setTitleAt(0, "Results ");
                                if (!context.getOptions().isDebugging() && rstm != null) {
                                    rstm.process(r, context.getOptions(), e -> {
                                        if (DateUtils.isOlderThan(dt, 3000L)) {
                                            pane.getPane().setTitleAt(0, "Results (" + e + " rows) ");
                                        }
                                    });
                                    rstm.fireTableDataChanged();
                                }
                                boolean bl = res = rstm != null && this.addResultSetToPane(rstm, pane, context, sb, pr);
                                if (res) {
                                    if (context.getOptions().isDebugging()) {
                                        rstm.process(r, context.getOptions(), e -> {
                                            if (DateUtils.isOlderThan(dt, 3000L)) {
                                                pane.getPane().setTitleAt(0, "Results (" + e + " rows) ");
                                            }
                                        });
                                        rstm.fireTableDataChanged();
                                    }
                                    this.models.add((Tuple<RunContext, IResultSetTable>)new Tuple((Object)context, (Object)rstm));
                                    this.repository.put(rstm.getIdentifier(), rstm);
                                    ++resultSets;
                                    cnt += rstm.getRowCount();
                                    resultRows += rstm.getRowCount();
                                }
                                if (exp != null) {
                                    throw exp;
                                }
                            }
                            if (cnt > 20000 || sb.length() > 500000) {
                                cnt = 0;
                                this.flushStringBuilder(sb, pane);
                            }
                            break;
                        }
                        int updateCount = s.getUpdateCount();
                        if (updateCount == -1) break block10;
                        this.flushStringBuilder(sb, pane);
                        int updateCount2 = updateCount;
                        SwingUtilities.invokeLater(() -> TextPaneUtil.addText(logOutputPane, "-- Affected row(s): " + updateCount2));
                    }
                }
                catch (Exception e2) {
                    try {
                        this.addWarningsToPane(s.getWarnings(), lastWarning, pane, sb, pr);
                        s.clearWarnings();
                    }
                    catch (SQLException dt) {
                        // empty catch block
                    }
                    this.flushStringBuilder(sb, pane);
                    Tuple<Long, String> exceptionStacktrace = ResultSetPresenterHelper.getExceptionInformationFromException(e2);
                    this.addErrorText((String)exceptionStacktrace.second(), (Long)exceptionStacktrace.first(), context.getOptions(), pane);
                    pane.selectMessageTab();
                    this.errors = true;
                    try {
                        if (s.getConnection().isClosed()) {
                        }
                    }
                    catch (Exception ex) {}
                    break;
                    if (loopcount > 0 && innerResult && resultSets == 0) break;
                }
                this.flushStringBuilder(sb, pane);
            }
            this.flushStringBuilder(sb, pane);
        }
        SwingUtilities.invokeLater(() -> {
            this.view.getView().invalidate();
            this.view.refresh();
        });
        return new ResultSetData(resultSets, resultRows, this.errors || this.aborted);
    }

    private void removeTab(Server server) {
        MultiResultPane pane = this.servers.remove(server);
        pane.cleanUp();
        this.tabs.remove(server);
        this.removeResults(server);
    }

    private void removeResults(Server server) {
        int i = this.models.size() - 1;
        while (i >= 0) {
            Tuple<RunContext, IResultSetTable> context = this.models.get(i);
            if (this.selectedModel != null && Objects.equals(this.selectedModel.first(), context.first())) {
                this.selectedModel = null;
            }
            if (Objects.equals(((RunContext)context.first()).getServer(), server)) {
                this.models.remove(i);
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try {
                        IResultSetTable r = this.repository.remove(((IResultSetTable)context.second()).getIdentifier());
                        if (r != null) {
                            r.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            --i;
        }
    }

    private String getLabelFromMeta(ResultSetMetaData md) {
        StringBuilder sb = new StringBuilder();
        sb.append("Rows: ").append("?");
        sb.append(", Columns: ");
        try {
            int i = 0;
            while (i < md.getColumnCount()) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(md.getColumnName(i + 1));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private static Boolean clearResultBeforeExec() {
        return ConfigHandler.getConfig().getBooleanConfigValue("query.clear_result_before_exec", true);
    }

    private boolean addResultSetToPane(final ResultSetTableModel rstm, MultiResultPane pane, final RunContext context, StringBuilder sb, Optional<IResultSetProcessor> pr) {
        if (this.presentQueryPlan(rstm, pane, pr)) {
            return false;
        }
        this.results = true;
        IOutput outputFormat = context.getOutputFormat();
        if (outputFormat.getFormat() == OutputFormat.TEXT) {
            try {
                this.rstp.present(rstm, sb, x -> this.flushStringBuilder((StringBuilder)x, pane));
                this.results = false;
            }
            catch (Exception e) {
                this.addErrorText(e.getMessage(), pane);
            }
            return true;
        }
        if (outputFormat.getFormat() == OutputFormat.FILE) {
            this.results = false;
            OutputBuilder.FileOutput fo = (OutputBuilder.FileOutput)outputFormat;
            try {
                ExportResult er = fo.getExporter().export(fo.generateNextFile().getAbsolutePath(), Arrays.asList(rstm), false, fo.getPreferences(), (percentage, message, ex) -> {});
                pane.addFilePane(new FileResult(rstm, er.filesExported().get(0), context));
                this.files = true;
                fo.addExported();
            }
            catch (Exception e1) {
                LOGGER.error("Error while exportin'", (Throwable)e1);
            }
            return false;
        }
        if (outputFormat.getFormat() == OutputFormat.SCRIPT) {
            this.results = false;
            OutputBuilder.ScriptOutput so = (OutputBuilder.ScriptOutput)outputFormat;
            IOutput io = so.getActualOutput();
            switch (io.getFormat()) {
                default: 
            }
            return false;
        }
        VTable jt = new VTable((TableModel)((Object)rstm), rstm.getTableColumnModel(), rstm.getTableRowSelectionModel()){

            public String getStringAt(int row, int column) {
                return rstm.getValueForDisplay(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
            }
        };
        jt.setRowSorter((RowSorter)((Object)new ResultSetTableSortController(rstm)));
        jt.setTransferHandler(new DefaultTableTransferHandler());
        jt.setFillsViewportHeight(true);
        jt.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        jt.setAutoResizeMode(0);
        jt.setHorizontalScrollEnabled(true);
        jt.setCellSelectionEnabled(true);
        jt.setColumnSelectionAllowed(true);
        jt.setColumnControlVisible(true);
        jt.addMouseListener(new MouseDoubleClickOnTableAdaptor());
        HashMap<Integer, BiFunction<String, String, Predicate>> predicators = new HashMap<Integer, BiFunction<String, String, Predicate>>();
        if (jt.getRowSorter() instanceof DefaultRowSorter) {
            DefaultRowSorter sorter = (DefaultRowSorter)jt.getRowSorter();
            int i = 0;
            while (i < rstm.getColumnCount()) {
                FieldType fieldType = rstm.getFieldType(i);
                if (fieldType == FieldType.SQLFLOAT) {
                    sorter.setComparator(i, Comparator.naturalOrder());
                    predicators.put(i, (b, c) -> PredicateFactory.createNumberIshPredicator((String)b, (String)c));
                } else if (fieldType == FieldType.SQLLONG) {
                    sorter.setComparator(i, Comparator.naturalOrder());
                    predicators.put(i, (b, c) -> PredicateFactory.createNumberIshPredicator((String)b, (String)c));
                } else if (fieldType == FieldType.SQLINTEGER || fieldType == FieldType.SQLBOOLEAN) {
                    sorter.setComparator(i, Comparator.naturalOrder());
                    predicators.put(i, (b, c) -> PredicateFactory.createNumberIshPredicator((String)b, (String)c));
                } else if (fieldType == FieldType.SQLDATE) {
                    sorter.setComparator(i, TimeStampWrapperHandler::compareTo);
                    predicators.put(i, (b, c) -> PredicateFactory.createDatePredicator((String)b, (String)c));
                } else {
                    predicators.put(i, (b, c) -> PredicateFactory.createToStringPredicator((String)b, (String)c));
                }
                ++i;
            }
            rstm.setSorter(sorter);
        }
        GraphResult results2 = new GraphResult(rstm);
        SwingUtilities.invokeLater(() -> {
            pane.addResultTable((JTable)((Object)jt), context);
            pane.addGraphPane(results2);
        });
        TableRowFilterSupport.forTable((JTable)((Object)jt)).useTableRenderers(true).predicator((a, b, c) -> predicators.getOrDefault(a, (x, y) -> null).apply((String)b, (String)c)).searchable(true).apply();
        new AggregatedMouseListener(jt.getTableHeader());
        pane.scrollToTheBottom();
        jt.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (ResultSetPresenter.this.selectedModel != null && ((IResultSetTable)ResultSetPresenter.this.selectedModel.second()).equals(rstm)) {
                    ResultSetPresenter.this.selectedModel = null;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                ResultSetPresenter.this.selectedModel = new Tuple((Object)context, (Object)rstm);
            }
        });
        this.tableHandler.handle((JTable)((Object)jt), pane, context.getServer(), context.getContent());
        return true;
    }

    private boolean presentQueryPlan(IResultSetTable rstm, MultiResultPane pane, Optional<IResultSetProcessor> pr) {
        if (pr.map(e -> e.handleQueryPlan(rstm, pane)).orElse(false).booleanValue()) {
            this.qp = true;
            return true;
        }
        return false;
    }

    private void addErrorText(String error, long line, SQLOptions so, MultiResultPane textPane) {
        SimpleAttributeSet s = ResultSetPresenter.createErrorStyle();
        if ((line <= (long)(1 + so.getCurrentBatchLineEnd() - so.getCurrentBatchLineStart()) || so.getCurrentBatchLineEnd() == 0) && line > 0L) {
            long b = line + (long)so.getCurrentBatchLineStart() - 1L;
            s.addAttribute(ERROR_LINE_ATTRIBUTE, Math.max(0L, b));
        }
        SwingUtilities.invokeLater(() -> TextPaneUtil.addText(textPane.getTextOutput(), error, s));
    }

    private void addErrorText(String error, MultiResultPane textPane) {
        SwingUtilities.invokeLater(() -> TextPaneUtil.addText(textPane.getTextOutput(), error, ERROR_STYLE));
    }

    private void addWarningsToPane(SQLWarning warning, ValueHolder<SQLWarning> lastWarning, MultiResultPane pane, StringBuilder sb, Optional<IResultSetProcessor> pr) {
        SQLWarning processWarning = warning;
        if (processWarning == null) {
            return;
        }
        this.flushStringBuilder(sb, pane);
        IResultSetProcessor ir = pr.orElse(null);
        while (processWarning != null) {
            if (lastWarning.compareAndSet(processWarning) && (ir == null || ir.displayWarning(processWarning))) {
                SQLWarning processWarning2 = processWarning;
                SwingUtilities.invokeLater(() -> TextPaneUtil.addText(pane.getTextOutput(), processWarning2.getMessage(), WARNING_STYLE));
                if (!this.switched) {
                    pane.selectMessageTab();
                    this.switched = true;
                }
                if (pane.getTextOutput().getDocument().getLength() > 3000000) {
                    pane.setTextArea();
                }
            }
            processWarning = processWarning.getNextWarning();
        }
    }

    private void flushStringBuilder(StringBuilder sb, MultiResultPane textpane) {
        int length = sb.length();
        if (length > 0) {
            if (length > 3000000 || textpane.getTextOutput().getDocument().getLength() > 3000000) {
                textpane.setTextArea();
            }
            try {
                String string = sb.toString();
                sb.setLength(0);
                SwingUtilities.invokeLater(() -> TextPaneUtil.addText(textpane.getTextOutput(), string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (length > 10000) {
                sb.ensureCapacity(100000);
            }
        }
    }

    public void exportDataWithOptions() {
        this.exportData(false, true);
    }

    public void exportData() {
        this.exportData(false, false);
    }

    private void exportData(boolean selected, boolean options) {
        Optional<ExportResult> res;
        if (this.models.size() == 0) {
            return;
        }
        int ix = this.view.getView().getSelectedIndex();
        MultiResultPane mp = null;
        if (ix >= 0) {
            Server ser = this.tabs.get(ix);
            mp = this.servers.get(ser);
        }
        if (this.models.size() > 1 || options) {
            Optional<ExportResult> res2 = this.tableHandler.exportDataWithOptions(this.models.stream().map(Tuple::second).collect(Collectors.toList()), selected, options);
            if (res2.isPresent() && mp != null) {
                for (File f : res2.get().filesExported()) {
                    mp.addFilePane(new FileResult(null, "", f, this.tabs.get(ix)));
                }
            }
            return;
        }
        Optional<IResultSetTable> model = Optional.ofNullable(this.selectedModel).map(l -> (IResultSetTable)l.second());
        if (!model.isPresent()) {
            model = this.models.stream().findFirst().map(l -> (IResultSetTable)l.second());
        }
        if (model.isPresent() && (res = this.tableHandler.exportData(Arrays.asList(model.get()), selected)).isPresent() && mp != null) {
            for (File f : res.get().filesExported()) {
                mp.addFilePane(new FileResult(null, "", f, this.tabs.get(ix)));
            }
        }
    }

    public void executionAborted(RunContext context) {
        MultiResultPane multiResultPane = this.servers.get(context.getServer());
        this.aborted = true;
        if (multiResultPane != null) {
            TextPaneUtil.addText(multiResultPane.getTextOutput(), "Execution aborted", WARNING_STYLE);
            multiResultPane.selectMessageTab();
        }
    }

    public JPanel getView() {
        return (InlineResultView)this.view;
    }

    public void clearPresentation(boolean clearOnly) {
        int i = 0;
        while (i < this.tabs.size()) {
            this.view.getView().remove(0);
            Server s = this.tabs.get(i);
            this.removeTab(s);
            if (!clearOnly) {
                this.createRunningTab(s);
            }
            ++i;
        }
    }

    public void started() {
        if (ResultSetPresenter.clearResultBeforeExec().booleanValue()) {
            this.clearPresentation(true);
            this.tableHandler.removeMessages();
        }
    }

    public List<Tuple<RunContext, IResultSetTable>> getResults() {
        return this.models;
    }
}

