/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.sql.RunContext;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.core.TableRowUtilities;
import com.sigge.filerunner.view.core.WheelScrollLayerUI;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.QueryPlanPanel;
import com.sigge.filerunner.view.results.export.FileExportHandler;
import com.sigge.filerunner.view.results.export.FileResult;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.tabs.TabUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;
import org.jdesktop.swingx.VerticalLayout;

public class MultiResultPane {
    private final JTabbedPane pane;
    Boolean editorPaneActive;
    RTextArea messagePane;
    JTextPane je;
    JXMultiSplitPane sp;
    MultiSplitLayout.Split s = new MultiSplitLayout.Split();
    List<MultiSplitLayout.Node> nodes = new ArrayList<MultiSplitLayout.Node>();
    int nodecount = 0;
    JScrollPane multiPane;
    JScrollPane singlePane;
    JPanel resultPanel = new JPanel();
    JPanel queryPlanPanel;
    private boolean qpenabled = true;
    boolean multiadded = false;
    private JTable firstTable = null;
    private JScrollPane firstPane = null;
    private boolean scrolled = true;
    private final JPanel messagePanel;
    private boolean qplanTabAdded;
    private boolean started;
    private JScrollPane queryPlanPane;
    private volatile GraphHandler handler = new GraphHandler();
    private FileExportHandler fileHandler = new FileExportHandler();
    private boolean graphAdded;
    private boolean fileAdded;
    private int filePane;
    private int qpPane;
    private int graphPane;
    JPopupMenu onResultTab = null;
    private final Map<String, IResultSetTable> qpRepo = new HashMap<String, IResultSetTable>();

    public MultiResultPane() {
        this.s.setRowLayout(false);
        this.pane = new JTabbedPane();
        this.messagePanel = new JPanel();
        this.je = new JTextPane();
        this.je.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (ButtonUtils.isRightClick(me)) {
                    JPopupMenu pp = new JPopupMenu("Clear output");
                    pp.add(new JMenuItem(new AbstractAction("Clear output", IconUtils.getSmallIcon("close.png")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            (this).MultiResultPane.this.je.setText("");
                        }
                    }));
                    pp.show(MultiResultPane.this.je, me.getX(), me.getY());
                }
            }
        });
        ComponentUtils.removeTravelsalForComponent(this.je, true);
        this.je.setName("SQL OUTPUT TEXT");
        this.messagePanel.setLayout(new BorderLayout());
        this.setTextEditor();
        this.pane.addTab("Results ", IconUtils.getSmallIcon("table.png"), this.resultPanel);
        this.pane.addTab("Messages ", IconUtils.getSmallIcon("text.png"), this.messagePanel);
        this.sp = new JXMultiSplitPane();
        this.sp.setPreferredSize(new Dimension(300, 300));
        ((MultiSplitLayout)this.sp.getLayout()).setFloatingDividers(true);
        this.multiPane = new JScrollPane((Component)this.sp);
        this.multiPane.setPreferredSize(new Dimension(300, 300));
        this.multiPane.setVerticalScrollBarPolicy(22);
        this.singlePane = new JScrollPane();
        this.resultPanel.setLayout(new BorderLayout());
        this.s.setChildren(this.nodes);
        this.sp.setModel((MultiSplitLayout.Node)this.s);
        this.pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (!ButtonUtils.isRightClick(me)) {
                    return;
                }
                int tabNr = TabUtils.getTabForMouseEvent(MultiResultPane.this.pane, me);
                JPopupMenu menu = null;
                if (tabNr == 0 && MultiResultPane.this.onResultTab != null) {
                    menu = MultiResultPane.this.onResultTab;
                }
                if (MultiResultPane.this.qplanTabAdded && tabNr == MultiResultPane.this.getQpPane()) {
                    menu = MultiResultPane.this.createPopupForQueryPlan();
                } else if (tabNr == 1) {
                    menu = MultiResultPane.this.createPopupForMessagePane();
                }
                if (menu != null) {
                    menu.show(MultiResultPane.this.pane, me.getX(), me.getY());
                }
            }
        });
    }

    private int getQpPane() {
        return this.qpPane;
    }

    private int getGraphPane() {
        return this.graphPane + (this.qpPane > 0 ? 1 : 0);
    }

    private int getFilePane() {
        return this.filePane + (this.qpPane > 0 ? 1 : 0) + (this.graphPane > 0 ? 1 : 0);
    }

    public void setTextArea() {
        if (this.editorPaneActive != null && !this.editorPaneActive.booleanValue()) {
            return;
        }
        this.messagePanel.removeAll();
        this.messagePane = new RTextArea();
        TextPaneUtil.disableUndo(this.messagePane);
        if (this.je != null) {
            this.messagePane.setText(this.je.getText());
            this.je.setText("");
        }
        this.messagePane.setHighlightCurrentLine(false);
        this.messagePane.setFont(new Font("Consolas", 0, 13));
        this.messagePane.setEditable(false);
        this.messagePane.setCursor(new Cursor(2));
        ComponentUtils.removeTravelsalForComponent((JComponent)this.messagePane, true);
        this.messagePane.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (ButtonUtils.isRightClick(me)) {
                    MultiResultPane.this.createPopupForMessagePane().show((Component)MultiResultPane.this.messagePane, me.getX(), me.getY());
                }
            }
        });
        RTextScrollPane messageScroll = new RTextScrollPane(this.messagePane);
        messageScroll.setVerticalScrollBarPolicy(22);
        messageScroll.setHorizontalScrollBarPolicy(32);
        this.messagePanel.add((Component)messageScroll);
        this.editorPaneActive = false;
    }

    private JPopupMenu createPopupForMessagePane() {
        JPopupMenu pp = new JPopupMenu("Clear output");
        pp.add(new JMenuItem(new AbstractAction("Clear output", IconUtils.getSmallIcon("close.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiResultPane.this.getTextOutput().setText("");
            }
        }));
        return pp;
    }

    public void setTextEditor() {
        if (this.editorPaneActive != null && this.editorPaneActive.booleanValue()) {
            return;
        }
        this.messagePanel.removeAll();
        if (this.messagePane != null) {
            this.je.setText(this.messagePane.getText());
            this.messagePane.setText("");
        }
        JScrollPane messageScroll = new JScrollPane(this.je);
        messageScroll.setVerticalScrollBarPolicy(22);
        messageScroll.setHorizontalScrollBarPolicy(32);
        this.messagePanel.add(messageScroll);
        this.je.setFont(new Font("Consolas", 0, 13));
        this.je.setEditable(false);
        this.editorPaneActive = true;
    }

    public void selectMessageTab() {
        this.pane.setSelectedIndex(1);
    }

    public void selectQPTab() {
        this.pane.setSelectedIndex(this.getQpPane());
    }

    public void selectResultsTab() {
        this.pane.setSelectedIndex(0);
    }

    public void highlightResultsTab(boolean results) {
        JLabel label = (JLabel)this.pane.getTabComponentAt(0);
        if (label != null) {
            label.setFont(label.getFont().deriveFont(results ? 1 : 0));
        }
    }

    public JTabbedPane getPane() {
        return this.pane;
    }

    public JTextComponent getTextOutput() {
        return this.editorPaneActive != false ? this.je : this.messagePane;
    }

    public void removeResults() {
        this.resultPanel.removeAll();
        this.nodecount = 0;
        this.singlePane.removeAll();
        this.firstTable = null;
        this.firstPane = null;
        this.nodes.clear();
        this.sp.removeAll();
        this.sp.revalidate();
        this.sp.repaint();
        this.s.setChildren(new MultiSplitLayout.Node[0]);
        this.resultPanel.revalidate();
        this.resultPanel.repaint();
        this.multiadded = false;
    }

    public void addResultTable(JTable table, RunContext context) {
        table.setMinimumSize(new Dimension(table.getMinimumSize().width, 400));
        JScrollPane pane = new JScrollPane();
        if (this.nodecount == 0) {
            this.singlePane.setViewportView(table);
            this.singlePane.setRowHeaderView(table.getTableHeader());
            this.firstTable = table;
            this.firstPane = pane;
            this.attachContextToNumberTable(TableRowUtilities.addNumberColumn(table, 1, true, ""), context);
            table.getTableHeader().addMouseListener(this.columnClickListener(table));
            this.resultPanel.add(this.singlePane);
        }
        if (this.nodecount > 0 && !this.multiadded) {
            this.multiadded = true;
            this.resultPanel.remove(this.singlePane);
            this.singlePane.remove(this.firstTable);
            this.firstPane.setViewportView(this.firstTable);
            this.firstPane.setRowHeaderView(this.firstTable.getTableHeader());
            this.attachContextToNumberTable(TableRowUtilities.addNumberColumn(this.firstTable, 1, true, context.getDatabase()), context);
            this.resultPanel.add(this.multiPane);
        }
        MultiSplitLayout.Leaf l = new MultiSplitLayout.Leaf(String.valueOf(this.nodecount));
        if (this.nodecount != 0) {
            MultiSplitLayout.Divider divider = new MultiSplitLayout.Divider();
            this.nodes.add((MultiSplitLayout.Node)divider);
        }
        this.nodes.add((MultiSplitLayout.Node)l);
        this.s.setChildren(this.nodes);
        if (this.multiadded) {
            pane.setRowHeaderView(table.getTableHeader());
            pane.setViewportView(table);
            this.attachContextToNumberTable(TableRowUtilities.addNumberColumn(table, 1, true, context.getDatabase()), context);
            table.getTableHeader().addMouseListener(this.columnClickListener(table));
        }
        this.setOptimalTableScrollbarSize(pane, table);
        this.sp.add((Component)pane, (Object)String.valueOf(this.nodecount));
        ++this.nodecount;
        this.sp.setPreferredSize(null);
        this.sp.revalidate();
        this.sp.repaint();
        this.resultPanel.revalidate();
        this.resultPanel.repaint();
    }

    private MouseAdapter columnClickListener(final JTable table) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e) || !e.isControlDown()) {
                    return;
                }
                e.consume();
                int columnIndex = table.getTableHeader().columnAtPoint(e.getPoint());
                if (columnIndex != -1) {
                    boolean invertSelection = false;
                    if (!e.isShiftDown()) {
                        int[] nArray = table.getSelectedColumns();
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int i = nArray[n2];
                            if (i == columnIndex && table.getSelectedRowCount() > 1) {
                                invertSelection = true;
                                break;
                            }
                            ++n2;
                        }
                        if (table.getSelectedRowCount() == 1 && table.getSelectedColumn() != columnIndex && table.getSelectedColumns().length == 1) {
                            table.removeColumnSelectionInterval(table.getSelectedColumn(), table.getSelectedColumn());
                        }
                    }
                    if (invertSelection) {
                        table.removeColumnSelectionInterval(columnIndex, columnIndex);
                        if (table.getSelectedColumns().length == 0) {
                            table.removeRowSelectionInterval(0, table.getRowSorter().getViewRowCount() - 1);
                        } else {
                            table.addRowSelectionInterval(0, table.getRowSorter().getViewRowCount() - 1);
                        }
                    } else {
                        table.addColumnSelectionInterval(columnIndex, columnIndex);
                        table.addRowSelectionInterval(0, table.getRowSorter().getViewRowCount() - 1);
                    }
                }
            }
        };
    }

    private MouseAdapter QPListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (ButtonUtils.isRightClick(me)) {
                    MultiResultPane.this.createPopupForQueryPlan().show(MultiResultPane.this.queryPlanPanel, me.getX(), me.getY());
                }
            }
        };
    }

    private JPopupMenu createPopupForQueryPlan() {
        JPopupMenu pp = new JPopupMenu("Clear query plans");
        pp.add(ActionUtils.createMenuAction("Clear output", IconUtils.getSmallIcon("close.png"), e -> this.clearQueryPlans()));
        if (this.isStarted()) {
            pp.addSeparator();
            pp.add(ActionUtils.createMenuAction(this.qpenabled ? "Disable query plans" : "Enable query plans", IconUtils.getSmallIcon("up_down_question.png"), e -> {
                this.qpenabled = !this.qpenabled;
            }, this.qpenabled));
        }
        return pp;
    }

    public void clearQueryPlans() {
        this.cleanUpQueryPlans();
        this.queryPlanPanel.removeAll();
        this.queryPlanPanel.revalidate();
        this.queryPlanPane.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueryPlan(QueryPlanPanel qp, IResultSetTable p) {
        if (!this.qplanTabAdded) {
            this.queryPlanPane = new JScrollPane();
            this.queryPlanPanel = new JPanel();
            this.queryPlanPanel.setLayout((LayoutManager)new VerticalLayout(0));
            this.queryPlanPane.setViewportView(this.queryPlanPanel);
            MultiResultPane multiResultPane = this;
            synchronized (multiResultPane) {
                this.qpPane = 2;
                this.pane.insertTab("Query plan ", IconUtils.getSmallIcon("up_down_question.png"), new JLayer<JScrollPane>(this.queryPlanPane, new WheelScrollLayerUI()), null, this.getQpPane());
            }
            this.qplanTabAdded = true;
            this.queryPlanPanel.addMouseListener(this.QPListener());
        }
        qp.addMouseListener(this.QPListener());
        this.queryPlanPanel.add(qp);
        this.qpRepo.put(p.getIdentifier(), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphPane(GraphResult results) {
        if (this.handler == null || results == null || results.getResultSet().getRowCount() == 0) {
            return;
        }
        if (!this.graphAdded) {
            MultiResultPane multiResultPane = this;
            synchronized (multiResultPane) {
                this.graphPane = 2;
                this.pane.insertTab("Visualize ", IconUtils.getSmallIcon("chart.png"), this.handler.getView(), null, this.getGraphPane());
            }
            ChangeListener l = new ChangeListener(){
                private boolean fired = false;

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!this.fired && MultiResultPane.this.pane.getSelectedIndex() == MultiResultPane.this.getGraphPane()) {
                        this.fired = true;
                        MultiResultPane.this.handler.generateGraph(true);
                        MultiResultPane.this.pane.removeChangeListener(this);
                    }
                }
            };
            this.pane.addChangeListener(l);
            this.graphAdded = true;
        }
        this.handler.handle(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilePane(FileResult results) {
        if (!this.fileAdded) {
            MultiResultPane multiResultPane = this;
            synchronized (multiResultPane) {
                this.filePane = 2;
                this.pane.insertTab("Exports ", IconUtils.getSmallIcon("export2.png"), this.fileHandler.getView(), null, this.getFilePane());
            }
            this.fileAdded = true;
        }
        this.fileHandler.addResult(results);
    }

    private void setOptimalTableScrollbarSize(JScrollPane jsp, JTable table) {
        int howManyRows = Math.max(Math.min(table.getModel().getRowCount(), 15), 1);
        int height = 50 + table.getRowHeight() * howManyRows;
        int minheight = 50 + table.getRowHeight() * 0;
        jsp.setMinimumSize(new Dimension(this.sp.getPreferredSize().width, minheight));
        jsp.setPreferredSize(new Dimension(this.sp.getPreferredSize().width, height));
    }

    private void attachContextToNumberTable(JTable numberTable, RunContext context) {
        numberTable.getTableHeader().setToolTipText(String.valueOf(context.getFile() != null ? "File: " + context.getFile() : "script") + "@" + context.getDatabase());
    }

    public void scrollToTheBottom() {
        if (this.scrolled) {
            return;
        }
        this.resultPanel.validate();
        JScrollBar vertical = this.multiPane.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum() + 1);
        this.scrolled = true;
    }

    public void startNewExecution() {
        this.scrolled = false;
        this.started = true;
    }

    public void cleanUp() {
        this.handler.dispose();
        this.handler = null;
        this.cleanUpQueryPlans();
        try {
            this.fileHandler.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String key : this.qpRepo.keySet()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    IResultSetTable rs = this.qpRepo.get(key);
                    if (rs == null) continue;
                    rs.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.qpRepo.clear();
        this.fileHandler = null;
    }

    private void cleanUpQueryPlans() {
        if (this.queryPlanPanel != null) {
            int i = 0;
            while (i < this.queryPlanPanel.getComponentCount()) {
                QueryPlanPanel qpp;
                Component cp = this.queryPlanPanel.getComponent(i);
                if (cp instanceof QueryPlanPanel && (qpp = (QueryPlanPanel)cp).getGraph() != null) {
                    try {
                        qpp.getGraph().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            for (String key : this.qpRepo.keySet()) {
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try {
                        IResultSetTable rs = this.qpRepo.get(key);
                        if (rs == null) continue;
                        rs.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.qpRepo.clear();
        }
    }

    public void finishExecution() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void selectFileTab() {
        this.pane.setSelectedIndex(this.getFilePane());
    }

    public boolean isQpenabled() {
        return this.qpenabled;
    }

    public void setQpenabled(boolean qpenabled) {
        this.qpenabled = qpenabled;
    }

    public Map<String, IResultSetTable> getQueryPlanRepo() {
        return this.qpRepo;
    }
}

