/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class MathBuilder
implements Consumer<Number> {
    private final List<Number> numbers = new ArrayList<Number>();
    private double sum = 0.0;
    private Double min;
    private Double max;
    private boolean sorted = false;

    @Override
    public void accept(Number t) {
        this.numbers.add(t);
        if (t != null) {
            this.sum += t.doubleValue();
            if (this.min == null || t.doubleValue() < this.min) {
                this.min = t.doubleValue();
            }
            if (this.max == null || t.doubleValue() > this.max) {
                this.max = t.doubleValue();
            }
        }
    }

    public void reset() {
        this.sum = 0.0;
        this.numbers.clear();
        this.min = null;
        this.max = null;
        this.sorted = false;
    }

    @Override
    public void accept(Collection<Number> numbers) {
        for (Number n : numbers) {
            this.accept(n);
        }
    }

    public double sum() {
        return this.sum;
    }

    public double average() {
        if (this.numbers.size() == 0) {
            return 0.0;
        }
        return this.sum / (double)this.numbers.size();
    }

    public Double max() {
        return this.max;
    }

    public Double min() {
        return this.min;
    }

    public int count() {
        return this.numbers.size();
    }

    public double percentile(double percentile) {
        if (!this.sorted) {
            this.numbers.sort((a, b) -> Double.compare(a.doubleValue(), b.doubleValue()));
            this.sorted = true;
        }
        if (this.numbers.size() == 0) {
            return 0.0;
        }
        return this.numbers.get((int)Math.round(percentile / 100.0 * (double)(this.numbers.size() - 1))).doubleValue();
    }
}

