/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.view.results.AResultSetConverter;

public class MarkdownConverter
extends AResultSetConverter {
    private static final String COLUMN_SEPARATOR = "|";

    @Override
    protected void columnHeader(StringBuilder sb, int col, int colCount, String colName) {
        if (col != 0) {
            sb.append(" ");
        }
        sb.append(COLUMN_SEPARATOR).append(" ").append(colName.replace(COLUMN_SEPARATOR, "\\|"));
    }

    @Override
    protected void afterLastColumn(StringBuilder sb) {
        sb.append(" ").append(COLUMN_SEPARATOR).append(System.lineSeparator());
    }

    @Override
    protected void postHeader(StringBuilder sb, int colcount) {
        sb.append(COLUMN_SEPARATOR);
        int i = 0;
        while (i < colcount) {
            sb.append(" ----- |");
            ++i;
        }
        sb.append(System.lineSeparator());
    }

    @Override
    protected void rowStart(StringBuilder sb) {
        sb.append(COLUMN_SEPARATOR);
    }

    @Override
    protected void row(StringBuilder sb, int row, int col, String displayValue) {
        sb.append(" ").append(displayValue == null ? "NULL" : displayValue.replace(COLUMN_SEPARATOR, "\\|")).append(" ").append(COLUMN_SEPARATOR);
    }

    @Override
    protected void postRow(StringBuilder sb, boolean last) {
        sb.append(System.lineSeparator());
    }
}

