/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.microsoft.sqlserver.jdbc.Geography;
import com.microsoft.sqlserver.jdbc.Geometry;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.graph.geo.options.AGeoHandler;
import java.sql.SQLException;
import org.geotools.geometry.jts.WKTReader2;
import org.locationtech.jts.io.ParseException;

public class GeometryHolder {
    private int srid;
    private org.locationtech.jts.geom.Geometry geo;
    private String wkt;
    private boolean parsed = false;
    private FieldType fieldType;

    public GeometryHolder(byte[] byteData, FieldType fieldType, String provider) throws SQLException {
        this.fieldType = fieldType;
        block3 : switch (provider) {
            case "MSSQL": {
                switch (fieldType) {
                    case SQLGEOGRAPHY: {
                        Geography g = Geography.deserialize((byte[])byteData);
                        this.wkt = g.toString();
                        this.srid = g.getSrid() == 0 ? 4236 : g.getSrid();
                        break block3;
                    }
                    case SQLGEOMETRY: {
                        Geometry gg = Geometry.deserialize((byte[])byteData);
                        this.wkt = gg.toString();
                        this.srid = gg.getSrid() == 0 ? 4236 : gg.getSrid();
                        break block3;
                    }
                }
                this.parsed = true;
                break;
            }
            default: {
                this.parsed = true;
            }
        }
    }

    public String getWkt() {
        return this.wkt;
    }

    public int getSrid() {
        return this.srid;
    }

    public org.locationtech.jts.geom.Geometry getGeo() {
        if (!this.parsed) {
            WKTReader2 reader = (WKTReader2)AGeoHandler.getReaderFromSRID(this.srid).second();
            try {
                org.locationtech.jts.geom.Geometry geometry = this.geo = reader.read(this.wkt);
                return geometry;
            }
            catch (ParseException e) {
                return null;
            }
            finally {
                this.parsed = true;
            }
        }
        return this.geo;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String toString() {
        return this.wkt == null ? "" : this.wkt;
    }
}

