/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.project;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.executors.BackgroundExecutor;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.editors.ALookupEditor;
import com.sigge.filerunner.view.project.DefaultProjectFilter;
import com.sigge.filerunner.view.project.IProjectFilter;
import com.siggemannen.core.Tuple;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.io.file.SimplePathVisitor;
import org.jdesktop.swingx.JXTree;

@Singleton
public class ProjectTreeHandler {
    private static final ImageIcon FOLDER_ICON = IconUtils.getSmallIcon("folder.png");
    private static final ImageIcon SMALL_ICON = IconUtils.getSmallIcon("text.png");
    private Map<DefaultMutableTreeNode, List<File>> mapNodes = new ConcurrentHashMap<DefaultMutableTreeNode, List<File>>();
    private Action add = ActionUtils.createAction("Add", "plus.png", true, this::add);
    private Action remove = ActionUtils.createAction("Remove", "delete_trash.png", true, this::remove);
    private Action quickOpener = ActionUtils.createAction("Open quickly", this::quickOpen);
    private Action filter = ActionUtils.createAction("Filter...", "filter.png", true, this::filter);
    private Action expand = ActionUtils.createAction("Expand/collapse", "expand.png", true, this::expandCollapse);
    private JXTree tree;
    private DefaultMutableTreeNode dn;
    private BackgroundExecutor be;
    private JFrame mainFrame;
    private AtomicInteger outstandingCalls = new AtomicInteger(0);
    List<Runnable> callbacks = new ArrayList<Runnable>();
    private Consumer<File> fileConsumer;
    static final String CONFIG_PROJECT_TREE_PATHS = "viewConfig.ProjectTreeHandler.projectPaths";
    private List<File> paths = new ArrayList<File>();
    private IProjectFilter projectFilter;

    @Inject
    public ProjectTreeHandler(Consumer<File> fileConsumer) {
        this.fileConsumer = fileConsumer;
        this.dn = new DefaultMutableTreeNode();
        this.be = BackgroundExecutor.EXECUTOR;
    }

    public void bindTo(JXTree tree, JFrame mainFrame) {
        this.tree = tree;
        this.mainFrame = mainFrame;
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object obj;
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (obj = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof File) {
                    File f = (File)obj;
                    if (!f.isDirectory() || node.getParent() != ProjectTreeHandler.this.dn) {
                        this.setText(f.getName());
                    }
                    if (!f.isDirectory()) {
                        this.setIcon(SMALL_ICON);
                    } else {
                        this.setIcon(FOLDER_ICON);
                    }
                }
                return this;
            }
        });
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!e.isConsumed() && e.getKeyCode() == 10) {
                    ProjectTreeHandler.this.runSelectedItems();
                    e.consume();
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isConsumed() && e.getClickCount() == 2 && e.getButton() == 1) {
                    ProjectTreeHandler.this.runSelectedItems();
                    e.consume();
                }
            }
        });
        DefaultTreeModel df = new DefaultTreeModel(this.dn);
        this.tree.setModel((TreeModel)df);
        this.tree.addTreeSelectionListener(tl -> this.expand.setEnabled(this.tree.getSelectionCount() == 1));
        this.expand.setEnabled(false);
        List<String> initialPaths = ConfigHandler.getConfig().getListValues(CONFIG_PROJECT_TREE_PATHS);
        this.projectFilter = this.loadFilter();
        this.addFilesToTree(initialPaths.stream().map(a -> {
            try {
                File f = new File((String)a);
                return f;
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void runSelectedItems() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath tp = treePathArray[n2];
            Object obj = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (obj instanceof File && ((File)obj).isFile()) {
                this.fileConsumer.accept((File)obj);
            }
            ++n2;
        }
        SwingUtilities.invokeLater(() -> {
            boolean bl = this.tree.requestFocusInWindow();
        });
    }

    private IProjectFilter loadFilter() {
        return new DefaultProjectFilter();
    }

    public void filter() {
    }

    public void expandCollapse() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath tp = treePathArray[n2];
            Object obj = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (obj instanceof File && ((File)obj).isDirectory()) {
                if (this.tree.isCollapsed(tp)) {
                    this.tree.expandPath(tp);
                } else {
                    this.tree.collapsePath(tp);
                }
            }
            ++n2;
        }
    }

    public void add() {
        List<File> f = FileUtils.openDirs(this.mainFrame);
        this.addFilesToTree(f);
    }

    private void addFilesToTree(List<File> f) {
        if (f != null) {
            BackgroundExecutor.CancellationToken token = new BackgroundExecutor.CancellationToken();
            for (File file : f) {
                DefaultMutableTreeNode nd = new DefaultMutableTreeNode(file);
                this.dn.add(nd);
                this.be.execute(ct -> {
                    this.outstandingCalls.incrementAndGet();
                    return this.traverseDirInOrder(file, token);
                }, res -> this.addNodes(nd, (Tuple<List<DefaultMutableTreeNode>, List<File>>)res));
            }
        }
    }

    public Tuple<List<DefaultMutableTreeNode>, List<File>> traverseDirInOrder(File f, final BackgroundExecutor.CancellationToken token) {
        final Stack currentNode = new Stack();
        final ArrayList allFiles = new ArrayList();
        final ArrayList children = new ArrayList();
        try {
            Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimplePathVisitor(){

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (token.isCancelled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    File filedir = dir.toFile();
                    if (!ProjectTreeHandler.this.projectFilter.filter(new Item(filedir))) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Node n = new Node(filedir);
                    currentNode.push(n);
                    return super.preVisitDirectory((Object)dir, attrs);
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (token.isCancelled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    Node dirNode = (Node)currentNode.pop();
                    DefaultMutableTreeNode n = dirNode.build(currentNode.size() == 0);
                    if (currentNode.size() > 0) {
                        ((Node)currentNode.peek()).addDir(n);
                    } else {
                        children.addAll(dirNode.children);
                    }
                    return super.postVisitDirectory((Object)dir, exc);
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (token.isCancelled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    File file2 = file.toFile();
                    if (!ProjectTreeHandler.this.projectFilter.filter(new Item(file2))) {
                        return FileVisitResult.CONTINUE;
                    }
                    allFiles.add(file2);
                    ((Node)currentNode.peek()).addFile(file2);
                    return super.visitFile((Object)file, attrs);
                }

                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (token.isCancelled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    return super.visitFileFailed((Object)file, exc);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Tuple.of(children, allFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodes(DefaultMutableTreeNode node, Tuple<List<DefaultMutableTreeNode>, List<File>> subnodes) {
        this.paths.add((File)node.getUserObject());
        this.saveConfig();
        for (DefaultMutableTreeNode sub : (List)subnodes.first()) {
            node.add(sub);
        }
        this.mapNodes.put(node, (List)subnodes.second());
        ProjectTreeHandler projectTreeHandler = this;
        synchronized (projectTreeHandler) {
            block10: {
                if (this.outstandingCalls.decrementAndGet() == 0 && this.callbacks.size() > 0) {
                    try {
                        try {
                            this.callbacks.get(this.callbacks.size() - 1).run();
                        }
                        catch (Exception exception) {
                            this.callbacks.clear();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        this.callbacks.clear();
                        throw throwable;
                    }
                    this.callbacks.clear();
                }
            }
        }
        this.getModel().reload();
        this.tree.expandPath(new TreePath(node.getPath()));
    }

    private void saveConfig() {
        ConfigHandler.getConfig().setConfigStringValues(CONFIG_PROJECT_TREE_PATHS, this.paths.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
    }

    public void remove() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath tp = treePathArray[n2];
            DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)tp.getLastPathComponent();
            this.getModel().removeNodeFromParent(lastPathComponent);
            if (this.mapNodes.containsKey(lastPathComponent)) {
                this.mapNodes.remove(lastPathComponent);
            }
            if (lastPathComponent.getUserObject() instanceof File) {
                File f = (File)lastPathComponent.getUserObject();
                this.paths.remove(f);
                this.saveConfig();
            }
            ++n2;
        }
    }

    private Object quickOpen() {
        new ProjectTreeLookup(e -> {
            if (e.fileItem != null) {
                this.fileConsumer.accept(e.fileItem);
            }
        }, this.mainFrame, "Open project file", new ALookupEditor.CallbackLookup<List<Item>>(){

            public Boolean apply0(ThrowingConsumer<List<Item>> t) throws Throwable {
                return this.applyInnerToBeAbleToBreakpoint(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Boolean applyInnerToBeAbleToBreakpoint(ThrowingConsumer<List<Item>> t) {
                ProjectTreeHandler projectTreeHandler = ProjectTreeHandler.this;
                synchronized (projectTreeHandler) {
                    if (ProjectTreeHandler.this.outstandingCalls.get() > 0) {
                        ProjectTreeHandler.this.callbacks.add(() -> t.accept(this.collectFiles()));
                        return false;
                    }
                    t.accept(this.collectFiles());
                    return true;
                }
            }

            private List<Item> collectFiles() {
                return ProjectTreeHandler.this.mapNodes.values().stream().flatMap(Collection::stream).map(file -> new Item((File)file)).collect(Collectors.toList());
            }
        }, true).present("");
        return null;
    }

    DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    public Action getAddAction() {
        return this.add;
    }

    public Action getRemoveAction() {
        return this.remove;
    }

    public Action getQuickProjectOpenerAction() {
        return this.quickOpener;
    }

    public Action getFilterAction() {
        return this.filter;
    }

    public Action getExpandAction() {
        return this.expand;
    }

    public class Item
    implements ILabel {
        File fileItem;

        public Item(File f) {
            this.fileItem = f;
        }

        @Override
        public String getLabel() {
            return this.fileItem.getAbsolutePath();
        }
    }

    class Node {
        DefaultMutableTreeNode node;
        List<File> files = new ArrayList<File>();
        List<DefaultMutableTreeNode> dirs = new ArrayList<DefaultMutableTreeNode>();
        List<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();

        Node(File f) {
            this.node = new DefaultMutableTreeNode(f);
        }

        Node addDir(DefaultMutableTreeNode dir) {
            this.dirs.add(dir);
            return this;
        }

        Node addFile(File f) {
            this.files.add(f);
            return this;
        }

        DefaultMutableTreeNode build(boolean buildAll) {
            List<File> filesx = this.files.stream().sorted(Comparator.comparing(f -> f.getAbsolutePath().toLowerCase())).collect(Collectors.toList());
            List<DefaultMutableTreeNode> dirsx = this.dirs.stream().sorted(Comparator.comparing(f -> ((File)f.getUserObject()).getAbsolutePath().toLowerCase())).collect(Collectors.toList());
            dirsx.forEach(d -> {
                if (!buildAll) {
                    this.node.add((MutableTreeNode)d);
                } else {
                    this.children.add((DefaultMutableTreeNode)d);
                }
            });
            filesx.forEach(f -> {
                if (!buildAll) {
                    this.node.add(new DefaultMutableTreeNode(f));
                } else {
                    this.children.add(new DefaultMutableTreeNode(f));
                }
            });
            return this.node;
        }
    }

    private final class ProjectTreeLookup
    extends ALookupEditor<Item> {
        private ProjectTreeLookup(ThrowingConsumer<Item> consumerObject, JFrame mainFrame, String title, ALookupEditor.CallbackLookup<List<Item>> lookup, boolean modal) {
            super(consumerObject, mainFrame, title, lookup, modal);
        }

        @Override
        protected String resolveDescription(Item so) {
            return "";
        }
    }
}

