/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.AMarkerAction;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.OutputFormat;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.RunnerPresenter;
import com.sigge.filerunner.view.activity.ActivityPresenter;
import com.sigge.filerunner.view.activity.MonitorPanel;
import com.sigge.filerunner.view.core.ITableSerializer;
import com.sigge.filerunner.view.editors.ObjectExplorer;
import com.sigge.filerunner.view.jobs.JobAction;
import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.Menu;
import com.sigge.filerunner.view.menu.MenuItem;
import com.sigge.filerunner.view.menu.MenuItemBuilder;
import com.sigge.filerunner.view.menu.MenuItemGroup;
import com.sigge.filerunner.view.menu.MenuType;
import com.sigge.filerunner.view.project.ProjectTreeHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

@Singleton
public class QueryMenu
implements Provider<IMenu> {
    private final RunnerPresenter runnerPresenter;
    private final ClearResultForExecutionAction clearResultsAction;
    private final ResultsToTextAction textAction;
    private final ResultsToGridAction gridAction;
    private final ResultsToFileAction fileAction;
    private final ResultsToScriptAction scriptAction;
    private final ClearExecutionAction clearExecutionAction;
    private final ObjectBrowseAction browseAction;
    private final ActivityAction activityAction;
    private final JobAction jobAction;
    private QuickOpenAction quickOpen;

    @Inject
    QueryMenu(RunnerPresenter runnerPresenter, ClearResultForExecutionAction clearResultsAction, ResultsToTextAction textAction, ResultsToGridAction gridAction, ClearExecutionAction clearExecutionAction, ObjectBrowseAction browseAction, ActivityAction activityAction, ResultsToFileAction fileAction, ResultsToScriptAction scriptAction, JobAction jobAction, QuickOpenAction quickOpen) {
        this.runnerPresenter = runnerPresenter;
        this.clearResultsAction = clearResultsAction;
        this.textAction = textAction;
        this.gridAction = gridAction;
        this.fileAction = fileAction;
        this.clearExecutionAction = clearExecutionAction;
        this.browseAction = browseAction;
        this.activityAction = activityAction;
        this.scriptAction = scriptAction;
        this.jobAction = jobAction;
        this.quickOpen = quickOpen;
    }

    public IMenu get() {
        Menu menu = new Menu(MenuType.QUERY);
        Object newbieItem = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("Confirm before executing").configSetting("query.newbiemode", false, false).build();
        Object clearItem = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("Clear results before execution").key(ConfigHandler.getForCommand(this.clearResultsAction, null)).configSetting("query.clear_result_before_exec", true, false).build();
        Object sticky = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("\"Sticky\" database per tab").configSetting("query.sticky_database", true, false).build();
        Object breakOnError = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("Cancel batch execution on first error").configSetting("query.cancel_batch_execution_on_error", false, false).build();
        menu.addItem(new MenuItem((JMenuItem)newbieItem), 0);
        menu.addItem(new MenuItem((JMenuItem)clearItem), 0);
        menu.addItem(new MenuItem((JMenuItem)sticky), 0);
        menu.addItem(new MenuItem((JMenuItem)breakOnError), 0);
        Object activity = new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("Show activity...").action(this.activityAction).icon(IconUtils.getSmallIcon("activity.png")).key(ConfigHandler.getForCommand(this.activityAction, null)).build();
        Object browse = new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("Browse objects...").action(this.browseAction).key(ConfigHandler.getForCommand(this.browseAction, null)).build();
        Object jobs = new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("Manage jobs...").action(this.jobAction).icon(IconUtils.getSmallIcon("jobs.png")).key(ConfigHandler.getForCommand(this.jobAction, null)).build();
        menu.addItemGroup(new MenuItemGroup(Arrays.asList(new MenuItem((JMenuItem)activity), new MenuItem((JMenuItem)browse), new MenuItem((JMenuItem)jobs))), 1);
        Object quick = new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("Quick open...").action(this.quickOpen).key(ConfigHandler.getForCommand(this.quickOpen, null)).build();
        menu.addItem(new MenuItem((JMenuItem)quick), 20);
        ButtonGroup group = new ButtonGroup();
        Object textMode = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("View results as text").icon(IconUtils.getSmallIcon("text.png")).action(this.saveOutputConfig(OutputFormat.TEXT)).defaultValue(this.getOutputConfig(OutputFormat.TEXT)).key(ConfigHandler.getForCommand(this.textAction, null)).build();
        Object gridMode = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("View results as grid").icon(IconUtils.getSmallIcon("table.png")).action(this.saveOutputConfig(OutputFormat.TABLE)).defaultValue(this.getOutputConfig(OutputFormat.TABLE)).key(ConfigHandler.getForCommand(this.gridAction, null)).build();
        Object fileMode = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("Export results directly to file").icon(IconUtils.getSmallIcon("export2.png")).action(this.saveOutputConfig(OutputFormat.FILE)).defaultValue(this.getOutputConfig(OutputFormat.FILE)).key(ConfigHandler.getForCommand(this.fileAction, null)).build();
        Object scriptMode = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("Script results").icon(IconUtils.getSmallIcon("text.png")).action(this.saveOutputConfig(OutputFormat.SCRIPT)).defaultValue(this.getOutputConfig(OutputFormat.SCRIPT)).key(ConfigHandler.getForCommand(this.scriptAction, null)).build();
        group.add((AbstractButton)textMode);
        group.add((AbstractButton)gridMode);
        group.add((AbstractButton)fileMode);
        group.add((AbstractButton)scriptMode);
        MenuItemGroup resultGroup = new MenuItemGroup(Arrays.asList(new MenuItem((JMenuItem)textMode), new MenuItem((JMenuItem)gridMode), new MenuItem((JMenuItem)fileMode), new MenuItem((JMenuItem)scriptMode)));
        menu.addItemGroup(resultGroup, 30);
        menu.addItem(new MenuItem((JMenuItem)new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("Clear current execution tab").action(l -> this.runnerPresenter.clearCurrentTabResults()).key(ConfigHandler.getForCommand(this.clearExecutionAction, null)).build()), 30);
        return menu;
    }

    private ActionListener saveOutputConfig(OutputFormat format) {
        return a -> {
            ConfigHandler.getConfig().setOutputFormat(format);
            ConfigHandler.saveInBackground();
        };
    }

    private Supplier<Boolean> getOutputConfig(OutputFormat format) {
        return () -> ConfigHandler.getConfig().getOutputFormat() == format;
    }

    @Singleton
    static class ActivityAction
    implements FileRunnerAction {
        private final JFrame mainFrame;
        private ITableSerializer serializer;

        @Inject
        ActivityAction(@Named(value="mainFrame") JFrame mainFrame, ITableSerializer serializer) {
            this.mainFrame = mainFrame;
            this.serializer = serializer;
        }

        @Override
        public String id() {
            return "activity";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActivityPresenter ap = new ActivityPresenter(DatabaseManager.getServerDatabases().stream().map(l -> l.getDb()).distinct().collect(Collectors.toList()), this.serializer);
            ap.present(this.mainFrame, new MonitorPanel());
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(65, 512);
        }
    }

    @Singleton
    static class ClearExecutionAction
    extends AMarkerAction {
        ClearExecutionAction() {
            super("clear-execution-tab", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        }
    }

    @Singleton
    static class ClearResultForExecutionAction
    extends AMarkerAction {
        ClearResultForExecutionAction() {
            super("clear-result-execution");
        }
    }

    @Singleton
    static class ObjectBrowseAction
    implements FileRunnerAction {
        private final ObjectExplorer explorer;
        private final RunnerModel model;

        @Inject
        ObjectBrowseAction(ObjectExplorer explorer, RunnerModel model) {
            this.explorer = explorer;
            this.model = model;
        }

        @Override
        public String id() {
            return "browse-objects";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = (String)this.model.getSelectedScript().getValue();
            if (s == null || s.length() == 0) {
                try {
                    Object o = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    if (o != null) {
                        s = o.toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (s != null && s.length() > 0) {
                    if (s.matches("(?s).*[\n\r].*")) {
                        s = "";
                    }
                } else {
                    s = "";
                }
            }
            this.explorer.present(s.trim());
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
    }

    @Singleton
    static class QuickOpenAction
    implements FileRunnerAction {
        private ProjectTreeHandler handler;

        @Inject
        QuickOpenAction(ProjectTreeHandler handler) {
            this.handler = handler;
        }

        @Override
        public String id() {
            return "quickopen";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> this.handler.getQuickProjectOpenerAction().actionPerformed(e));
        }

        @Override
        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
    }

    @Singleton
    static class ResultsToFileAction
    extends AMarkerAction {
        ResultsToFileAction() {
            super("results-to-file", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        }
    }

    @Singleton
    static class ResultsToGridAction
    extends AMarkerAction {
        ResultsToGridAction() {
            super("results-to-grid", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        }
    }

    @Singleton
    static class ResultsToScriptAction
    extends AMarkerAction {
        ResultsToScriptAction() {
            super("results-to-script");
        }
    }

    @Singleton
    static class ResultsToTextAction
    extends AMarkerAction {
        ResultsToTextAction() {
            super("results-to-text", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        }
    }
}

