/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.sigge.filerunner.action.MenuAction;
import com.sigge.filerunner.commands.FileCommands;
import com.sigge.filerunner.commands.TabCommands;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.Encoding;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.IMenuItem;
import com.sigge.filerunner.view.menu.IMenuItemGroup;
import com.sigge.filerunner.view.menu.Menu;
import com.sigge.filerunner.view.menu.MenuItem;
import com.sigge.filerunner.view.menu.MenuItemGroup;
import com.sigge.filerunner.view.menu.MenuType;
import com.sigge.filerunner.view.menu.RecentMenuHandler;
import com.siggemannen.core.Tuple;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

@Singleton
public class FileMenu
implements Provider<IMenu>,
IMenu.ChangeListener {
    private final IMenu fileMenu = new Menu(MenuType.FILE);
    private final MenuItemGroup newOpenGroup;
    private final MenuItemGroup saveGroup;
    private final Consumer<File> openFileConsumer;
    private final RecentMenuHandler recentMenuHandler;
    private final FileCommands.OpenHistoryAction openHistory;
    private final FileCommands.ExitAction exitAction;
    private final FileCommands.BrowseFileHistoryAction browseHistory;

    @Inject
    FileMenu(RecentMenuHandler recentMenuHandler, TabCommands.NewTabAction newFile, TabCommands.OpenTabAction openFile, TabCommands.SaveFileAction saveFile, TabCommands.SaveAsFileAction saveAsFile, TabCommands.SaveWithEncodingAction saveWithEncodingAction, Consumer<File> openFileConsumer, FileCommands.OpenHistoryAction openHistory, FileCommands.ExitAction exitAction, FileCommands.BrowseFileHistoryAction browseHistory, TabCommands.OpenDirectoryAction openDir) {
        this.openFileConsumer = openFileConsumer;
        this.recentMenuHandler = recentMenuHandler;
        this.openHistory = openHistory;
        this.exitAction = exitAction;
        this.browseHistory = browseHistory;
        MenuItem newFileItem = new MenuItem(new MenuAction("New file", IconUtils.getSmallIcon("document_add.png"), (Integer)78, ConfigHandler.getForCommand(newFile, null), newFile));
        MenuItem openFileItem = new MenuItem(new MenuAction("Open file", IconUtils.getSmallIcon("folder.png"), (Integer)79, ConfigHandler.getForCommand(openFile, null), openFile));
        MenuItem openDirItem = new MenuItem(new MenuAction("Open directory...", IconUtils.getSmallIcon("folder.png"), null, ConfigHandler.getForCommand(openDir, null), openDir));
        this.newOpenGroup = new MenuItemGroup(Arrays.asList(newFileItem, openFileItem, openDirItem));
        MenuItem saveFileItem = new MenuItem(new MenuAction("Save file", IconUtils.getSmallIcon("save.png"), (Integer)83, ConfigHandler.getForCommand(saveFile, null), saveFile));
        MenuItem saveAsFileItem = new MenuItem(new MenuAction("Save as...", IconUtils.getSmallIcon("saveAs.png"), (Integer)65, ConfigHandler.getForCommand(saveAsFile, null), saveAsFile));
        IMenuItem saveWithEncoding = this.createSaveWithEncoding(saveWithEncodingAction);
        this.saveGroup = new MenuItemGroup(Arrays.asList(saveFileItem, saveAsFileItem, saveWithEncoding));
        recentMenuHandler.addListener(this);
    }

    private IMenuItem createSaveWithEncoding(final TabCommands.SaveWithEncodingAction saveWithEncodingAction2) {
        ArrayList<IMenuItemGroup> groups = new ArrayList<IMenuItemGroup>();
        MenuItem mu = new MenuItem(new JMenu("Save with encoding..."), groups);
        LinkedHashMap charsets = new LinkedHashMap();
        Arrays.asList(Encoding.values()).stream().filter(f -> !f.equals(Encoding.AUTO_DETECT)).forEachOrdered(c -> {
            String string = charsets.put(c.getEncoding(), c.getLabel());
        });
        groups.add(new MenuItemGroup(charsets.keySet().stream().map(f -> new MenuItem(new JMenuItem(new AbstractAction((String)charsets.get(f), (String)f){
            private final /* synthetic */ String val$f;
            {
                this.val$f = string;
                super($anonymous0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                saveWithEncodingAction2.actionPerformed(new ActionEvent(e.getSource(), e.getID(), this.val$f, e.getWhen(), e.getModifiers()));
            }
        }))).collect(Collectors.toList())));
        return mu;
    }

    public IMenu get() {
        this.recreateMenu();
        return this.fileMenu;
    }

    private void recreateMenu() {
        if (this.fileMenu == null) {
            return;
        }
        this.fileMenu.clear();
        this.fileMenu.addItemGroup(this.newOpenGroup, 0);
        this.fileMenu.addItemGroup(this.saveGroup, 10);
        List<File> files = this.recentMenuHandler.getItems();
        if (files.size() > 0) {
            ArrayList<IMenuItemGroup> groups = new ArrayList<IMenuItemGroup>();
            MenuItem mu = new MenuItem(new JMenu("Recent files"), groups);
            groups.add(new MenuItemGroup(files.stream().map(f -> new MenuItem(new JMenuItem(new AbstractAction(f.getAbsolutePath(), (File)f){
                private final /* synthetic */ File val$f;
                {
                    this.val$f = file;
                    super($anonymous0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FileMenu.this.openFileConsumer.accept(this.val$f);
                    }
                    catch (Exception ex) {
                        FileUtils.displayFileMessages(Arrays.asList(Tuple.of((Object)this.val$f, (Object)ex.getMessage())));
                    }
                }
            }))).collect(Collectors.toList())));
            ArrayList<IMenuItem> historyItems = new ArrayList<IMenuItem>();
            JMenuItem jmx = new JMenuItem(new MenuAction("Open history", null, null, ConfigHandler.getForCommand(this.openHistory, null), this.openHistory));
            jmx.setFont(jmx.getFont().deriveFont(1));
            JMenuItem browser = new JMenuItem(new MenuAction("Browse files", null, null, ConfigHandler.getForCommand(this.browseHistory, null), this.browseHistory));
            historyItems.add(new MenuItem(browser));
            historyItems.add(new MenuItem(jmx));
            groups.add(new MenuItemGroup(historyItems));
            this.fileMenu.addItem(mu, 20);
        }
        this.fileMenu.addItemGroup(new MenuItemGroup(new MenuItem(new MenuAction("Exit", IconUtils.getSmallIcon("close.png"), (Integer)88, ConfigHandler.getForCommand(this.exitAction, null), this.exitAction))), 30);
        this.fileMenu.triggerReload();
    }

    @Override
    public void changed(IMenu menu) {
        this.recreateMenu();
    }
}

