/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobHistory;
import com.sigge.filerunner.view.jobs.IJobResult;
import com.sigge.filerunner.view.jobs.JobResultType;
import com.siggemannen.view.ListTableElementModel;
import java.time.LocalDateTime;
import java.util.Objects;

public class JobViewModel
extends ListTableElementModel<IJob, String> {
    public static final int SERVER = 0;
    public static final int JOB_NAME = 1;
    public static final int LAST_EXEC = 2;
    public static final int LAST_EXEC_FINISHED = 3;
    public static final int DURATION = 4;
    public static final int LAST_RESULT = 5;
    public static final int NEXT_RUN = 6;
    public static final int SPECIAL = 999;
    public static LocalDateTime DUMMY_DATE = LocalDateTime.MIN;
    public static LocalDateTime DUMMY_DATE_MAX = LocalDateTime.MAX;

    public Object getValueAt(int row, int column) {
        IJob ij = (IJob)this.getValueAt(row);
        if (ij == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return ij.getJobServer();
            }
            case 1: {
                return ij.getLabel();
            }
            case 2: {
                return ij.getLastRun().map(IJobHistory::getLastRun).orElse(DUMMY_DATE);
            }
            case 3: {
                return ij.getLastRun().map(IJobHistory::getLastFinished).orElse(null);
            }
            case 4: {
                return ij.getLastRun().map(IJobHistory::getExecutionDurationInMs).orElse(null);
            }
            case 5: {
                return ij.getLastRun().map(a -> new JobResultWrapper(a.getResult())).orElse(null);
            }
            case 6: {
                return ij.getLastRun().map(IJobHistory::getNextRun).orElse(DUMMY_DATE_MAX);
            }
            case 999: {
                return ij;
            }
        }
        throw new RuntimeException("Unsupported column: " + column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        throw new UnsupportedOperationException("Cannot set values");
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    static class JobResultWrapper
    implements IJobResult {
        private IJobResult obj;

        JobResultWrapper(IJobResult obj) {
            this.obj = obj;
        }

        @Override
        public JobResultType getResult() {
            return this.obj.getResult();
        }

        @Override
        public String getResultMessage() {
            return this.obj.getResultMessage();
        }

        public int hashCode() {
            return Objects.hash(this.obj.getResult());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobResultWrapper other = (JobResultWrapper)obj;
            return this.getResult() == other.getResult();
        }
    }
}

