/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.executors.RecurringExecutionContext;
import com.sigge.filerunner.view.IconCache;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.core.LabelProvider;
import com.sigge.filerunner.view.jobs.HistoryRenderer;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobLogRecord;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.JobHistoryParams;
import com.sigge.filerunner.view.jobs.JobHistoryView;
import com.sigge.filerunner.view.jobs.StandardJobCommand;
import java.awt.Color;
import java.awt.Component;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class JobHistoryViewer {
    private final List<IJob> jobs;
    private final RecurringExecutionContext context;
    private static final List<String> COLUMNS = Arrays.asList("Start time", "Duration", "Server", "Job", "Step", "Message");
    private Action stopAction;
    private DefaultTreeTableModel model = new DefaultTreeTableModel((TreeTableNode)new DefaultMutableTreeTableNode(), COLUMNS);

    public JobHistoryViewer(List<IJob> jobs) {
        this.jobs = new ArrayList<IJob>(jobs);
        this.jobs.sort(Comparator.comparing(k -> ((IJob)k).getJobServer().getId()).thenComparing(k -> ((IJob)k).getLabel().toLowerCase()));
        this.context = new RecurringExecutionContext();
    }

    public void display(List<IJobObject> selectedDefault) {
        JMemoryFrame jd = new JMemoryFrame("Job history", "job-history-dialog");
        if (!jd.isSizeSetFromSettings()) {
            jd.setSize(800, 600);
        }
        JobHistoryView view = new JobHistoryView();
        view.historyLogTable.setRootVisible(false);
        view.historyLogTable.setGridColor(new Color(223, 220, 214));
        view.historyLogTable.setShowGrid(true, true);
        view.refreshButton.setAction(ActionUtils.createAction("Refresh", "refresh.png", true, () -> {
            ArrayList<IJobObject> jobs = new ArrayList<IJobObject>();
            jobs.addAll(this.getSelectedDatabases(jobHistoryView.objectTree.getCheckedPaths(), IJob.class));
            this.loadTable(jobs, view);
        }, KeyStroke.getKeyStroke(116, 0)));
        this.stopAction = ActionUtils.createAction("Stop", "stop.png", true, () -> {
            this.context.cancel();
            this.stopAction.setEnabled(false);
        });
        view.stopButton.setAction(this.stopAction);
        this.stopAction.setEnabled(false);
        jd.setDefaultCloseOperation(2);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Jobs");
        DefaultTreeModel model = new DefaultTreeModel(root);
        HashMap<IJobServer, List> jobMap = new HashMap<IJobServer, List>();
        for (IJob job : this.jobs) {
            jobMap.computeIfAbsent(job.getJobServer(), js -> new ArrayList()).add(job);
        }
        ArrayList<TreePath> checked = new ArrayList<TreePath>();
        for (IJobServer server : jobMap.keySet()) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(server);
            root.add(child);
            for (IJob job : (List)jobMap.get(server)) {
                DefaultMutableTreeNode jobNode = new DefaultMutableTreeNode(job);
                child.add(jobNode);
                if (!selectedDefault.contains(job)) continue;
                checked.add(new TreePath(jobNode.getPath()));
            }
        }
        view.objectTree.setTreeRenderer(new LabelProvider<Object>(){

            @Override
            public String getLabel(Object o) {
                if (o instanceof String) {
                    return (String)o;
                }
                if (o instanceof ILabel) {
                    return ((ILabel)o).getLabel();
                }
                if (o != null) {
                    return o.toString();
                }
                return "<null>";
            }
        });
        view.objectTree.setModel(model);
        view.objectTree.setCheckStatus(checked, true);
        view.objectTree.expandAll();
        view.objectTree.addCheckChangeEventListener(l -> {
            ArrayList<IJobObject> jobs = new ArrayList<IJobObject>();
            jobs.addAll(this.getSelectedDatabases(jobHistoryView.objectTree.getCheckedPaths(), IJob.class));
            this.loadTable(jobs, view);
        });
        view.historyLogTable.setTreeTableModel((TreeTableModel)this.model);
        jd.getContentPane().add(view);
        jd.centerOnCorrectScreen(null);
        jd.setVisible(true);
        this.loadTable(selectedDefault, view);
    }

    private <E> List<E> getSelectedDatabases(TreePath[] treePaths, Class<E> classType) {
        ArrayList<Object> db = new ArrayList<Object>();
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Object[] objectArray = path.getPath();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object p = objectArray[n4];
                DefaultMutableTreeNode o = (DefaultMutableTreeNode)p;
                if (classType.isAssignableFrom(o.getUserObject().getClass())) {
                    db.add(o.getUserObject());
                }
                ++n4;
            }
            ++n2;
        }
        return db;
    }

    private void loadTable(List<IJobObject> jobs, JobHistoryView view) {
        view.historyLogTable.setTreeCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                IJobLogRecord treeValue;
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof LogRecordNode && (treeValue = (IJobLogRecord)((LogRecordNode)((Object)value)).getUserObject()) != null) {
                    LocalDateTime time = treeValue.getLogDate();
                    label.setText(DateUtils.formatLocalDate(time, false));
                    if (treeValue.getJobResult() != null) {
                        this.setIcon(IconCache.getCachedSmallIcon(treeValue.getJobResult().getIcon()));
                    }
                }
                return label;
            }
        });
        if (jobs.size() == 0) {
            view.historyLogTable.setTreeTableModel((TreeTableModel)this.model);
            this.setTableRenderer(view);
            return;
        }
        HashMap<IJobServer, List> jobServers = new HashMap<IJobServer, List>();
        for (IJobObject job : jobs) {
            jobServers.computeIfAbsent(((IJob)job).getJobServer(), js -> new ArrayList()).add(job);
        }
        this.stopAction.setEnabled(true);
        this.context.execute(() -> {
            List records = Collections.synchronizedList(new ArrayList());
            for (IJobServer server : jobServers.keySet()) {
                server.execute(StandardJobCommand.HISTORY, new JobHistoryParams(null, records::addAll), (List)jobServers.get(server), null);
            }
            return records;
        }, records -> SwingUtilities.invokeLater(() -> {
            jobHistoryView.historyLogTable.setTreeTableModel((TreeTableModel)this.getModelFromRecords((List<IJobLogRecord>)records));
            this.setTableRenderer(view);
            jobHistoryView.historyLogTable.packAll();
            jobHistoryView.historyLogTable.requestFocusInWindow();
            this.stopAction.setEnabled(false);
        }));
    }

    private void setTableRenderer(JobHistoryView view) {
        for (String identifier : COLUMNS) {
            view.historyLogTable.getColumnExt(identifier).setCellRenderer((TableCellRenderer)new HistoryRenderer());
        }
    }

    private DefaultTreeTableModel getModelFromRecords(List<IJobLogRecord> records) {
        LogRecordNode root = new LogRecordNode();
        DefaultTreeTableModel model = new DefaultTreeTableModel((TreeTableNode)root, COLUMNS);
        this.addRecords(root, records);
        return model;
    }

    private void addRecords(LogRecordNode root, List<IJobLogRecord> records) {
        for (IJobLogRecord record : records) {
            LogRecordNode child = new LogRecordNode(record);
            root.add((MutableTreeTableNode)child);
            this.addRecords(child, record.getDetails());
        }
    }

    class LogRecordNode
    extends AbstractMutableTreeTableNode {
        public static final int DATE = 0;
        public static final int DURATION = 1;
        public static final int SERVER = 2;
        public static final int JOB = 3;
        public static final int STEP = 4;
        public static final int MESSAGE = 5;

        public LogRecordNode() {
        }

        public LogRecordNode(IJobLogRecord record) {
            super((Object)record);
        }

        public Object getValueAt(int column) {
            IJobLogRecord record = (IJobLogRecord)this.userObject;
            if (record == null) {
                return null;
            }
            switch (column) {
                case 0: {
                    return record.getLogDate();
                }
                case 1: {
                    return DateUtils.getDuration(record.getDurationInMs());
                }
                case 2: {
                    return record.getServer();
                }
                case 3: {
                    return record.getObject();
                }
                case 4: {
                    return record.getStepId() + " " + record.getStepName();
                }
                case 5: {
                    return record.getMessage();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return COLUMNS.size();
        }
    }
}

