/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.view.activity.ObjectMonitor;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.JobViewModel;
import com.siggemannen.core.Tuple;
import java.io.Closeable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class JobHandler
implements Closeable {
    private final JobViewModel model;
    private int pollTime;
    private int effectivePollTime;
    private int decayTime;
    private final List<Monitorer> monitorers = new ArrayList<Monitorer>();
    private final ScheduledExecutorService sXs = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService ex = Executors.newWorkStealingPool();
    private ScheduledFuture future;
    private ScheduledFuture futureX;

    JobHandler(JobViewModel model, List<ObjectMonitor<IJobServer>> list, int pollTime, int decayTime) {
        this.model = model;
        this.pollTime = pollTime;
        this.effectivePollTime = pollTime;
        this.decayTime = decayTime;
        this.setMonitorServers(list);
    }

    public void setMonitorServers(List<ObjectMonitor<IJobServer>> dbs) {
        ArrayList<IJobServer> monitorList = new ArrayList<IJobServer>();
        for (ObjectMonitor<IJobServer> objectMonitor : dbs) {
            ObjectMonitor<IJobServer> newServer = new ObjectMonitor<IJobServer>(objectMonitor.getObject());
            if (objectMonitor.getRefreshRate() != null) {
                newServer.setRefreshRate(objectMonitor.getRefreshRate());
            }
            newServer.setMonitor(objectMonitor.isMonitor());
            monitorList.add(newServer.getObject());
            Optional<Monitorer> s = this.monitorers.stream().filter(monitor -> ((IJobServer)((Monitorer)monitor).server.getObject()).equals(newServer.getObject())).findFirst();
            if (s.isPresent()) {
                Monitorer m = s.get();
                if (m.server.isMonitor() && !newServer.isMonitor()) {
                    this.updateDb(objectMonitor.getObject(), Collections.EMPTY_LIST);
                }
                m.server = newServer;
                continue;
            }
            this.monitorers.add(new Monitorer(newServer));
        }
        if (dbs.size() != this.monitorers.size()) {
            for (int i = this.monitorers.size() - 1; i >= 0; --i) {
                Monitorer monitorer = this.monitorers.get(i);
                if (monitorList.contains(monitorer.server.getObject())) continue;
                this.updateDb((IJobServer)monitorer.server.getObject(), Collections.EMPTY_LIST);
                this.monitorers.remove(i);
            }
        }
        this.reschedule();
    }

    private void reschedule() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        if (this.futureX != null) {
            this.futureX.cancel(false);
        }
        this.effectivePollTime = this.getEffectivePollTime();
        this.future = this.sXs.scheduleWithFixedDelay(this::update, 0L, this.effectivePollTime, TimeUnit.MILLISECONDS);
    }

    private int getEffectivePollTime() {
        int minValue = Integer.MAX_VALUE;
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (Monitorer mon : this.monitorers) {
            ObjectMonitor monitor = mon.server;
            int val = monitor.getRefreshRate() != null && monitor.getRefreshRate() > 0 ? monitor.getRefreshRate() * 1000 : this.pollTime;
            if ((val = val / 100 * 100) == 0) continue;
            minValue = Math.min(minValue, val);
            values.add(val);
        }
        if (minValue == Integer.MAX_VALUE) {
            return this.pollTime;
        }
        if (minValue <= 500) {
            return 500;
        }
        int gcd = 0;
        for (int i = minValue / 100; i > 0; --i) {
            boolean allGood = true;
            for (Integer ix : values) {
                if (ix % (i * 100) == 0) continue;
                allGood = false;
                break;
            }
            if (!allGood) continue;
            gcd = i * 100;
            break;
        }
        return gcd > 0 ? gcd : 1000;
    }

    private void update() {
        for (Monitorer mon : this.monitorers) {
            if (!mon.fireTime(this.pollTime)) continue;
            this.ex.execute(() -> ((IJobServer)mon.server.getObject()).getJobs(x -> SwingUtilities.invokeLater(() -> this.updateDb((IJobServer)mon.server.getObject(), (List<IJob>)x))));
        }
    }

    private void updateDb(IJobServer d, List<IJob> activities) {
        ArrayList<Tuple> rowsToUpdate = new ArrayList<Tuple>();
        ArrayList<Integer> rowsToDelete = new ArrayList<Integer>();
        for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
            IJob acp = (IJob)this.model.getValueAt(i);
            if (!acp.getJobServer().equals(d)) continue;
            boolean changed = false;
            for (int j = activities.size() - 1; j >= 0; --j) {
                IJob acx = activities.get(j);
                if (!acx.equals(acp)) continue;
                activities.remove(j);
                rowsToUpdate.add(Tuple.of((Object)i, (Object)acx));
                changed = true;
                break;
            }
            if (changed) continue;
            rowsToDelete.add(i);
        }
        this.model.replaceRows(rowsToUpdate);
        Iterator iterator = rowsToDelete.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.model.removeRow(i);
        }
        this.model.insertRows(activities);
    }

    public void setDefaultRate(int i) {
        this.pollTime = i;
        this.reschedule();
    }

    @Override
    public void close() {
        this.ex.shutdownNow();
    }

    public void changeDecayRate(int i) {
        this.decayTime = i;
        this.reschedule();
    }

    private class Monitorer {
        private ObjectMonitor<IJobServer> server;
        private LocalDateTime lastCheck;

        Monitorer(ObjectMonitor<IJobServer> server) {
            this.server = server;
        }

        boolean fireTime(int effectivePollTime) {
            int pollTime;
            if (!this.server.isMonitor()) {
                return false;
            }
            if (this.lastCheck == null) {
                this.lastCheck = DateUtils.getTimeAtUTC();
                return true;
            }
            int n = pollTime = this.server.getRefreshRate() != null && this.server.getRefreshRate() > 0 ? this.server.getRefreshRate() * 1000 : effectivePollTime;
            if (DateUtils.isOlderThan(this.lastCheck, pollTime - 200)) {
                this.lastCheck = DateUtils.getTimeAtUTC();
                return true;
            }
            return false;
        }
    }
}

