/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.activity.ObjectMonitor;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.core.ITableSerializer;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.jobs.DefaultJobRenderer;
import com.sigge.filerunner.view.jobs.EnableDisableJobAction;
import com.sigge.filerunner.view.jobs.ICommand;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.IJobServerManager;
import com.sigge.filerunner.view.jobs.JobEditor;
import com.sigge.filerunner.view.jobs.JobHandler;
import com.sigge.filerunner.view.jobs.JobHistoryViewer;
import com.sigge.filerunner.view.jobs.JobResultRenderer;
import com.sigge.filerunner.view.jobs.JobServerEditor;
import com.sigge.filerunner.view.jobs.JobServerRenderer;
import com.sigge.filerunner.view.jobs.JobServerResult;
import com.sigge.filerunner.view.jobs.JobSetting;
import com.sigge.filerunner.view.jobs.JobSettings;
import com.sigge.filerunner.view.jobs.JobView;
import com.sigge.filerunner.view.jobs.JobViewModel;
import com.sigge.filerunner.view.jobs.StandardJobCommand;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import com.siggemannen.view.multiple.MultipleUIBackgroundRunner;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.DefaultRowSorter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXStatusBar;
import org.oxbow.swingbits.table.filter.TableRowFilterSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JobAction
implements FileRunnerAction {
    private final JFrame mainFrame;
    private final Map<String, IJobServerManager> managers;
    static final String VIEW_CONFIG_JOB_MONITOR_REFRESH_RATE = "viewConfig.Jobs.refreshRate";
    private static final String FILENAME = "db/jobs.json";
    private JobSettings jobSettings;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobAction.class);
    private final MultipleUIBackgroundRunner runner;
    private ITableSerializer serializer;

    @Inject
    JobAction(@Named(value="mainFrame") JFrame mainFrame, Map<String, IJobServerManager> managers, @Named(value="MULTIRUNNER") MultipleUIBackgroundRunner runner, ITableSerializer serializer) {
        this.mainFrame = mainFrame;
        this.managers = managers;
        this.runner = runner;
        this.serializer = serializer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final JMemoryFrame jd = new JMemoryFrame("Job manager", "job-manager");
        final JobView jv = new JobView();
        final FastTextFilter re = new FastTextFilter(jv.filterJobTextList);
        jv.editPane.setSelected(false);
        jd.getContentPane().add(jv);
        if (!jd.isSizeSetFromSettings()) {
            jd.pack();
        }
        jv.removeStep.setVisible(false);
        jv.editPane.setVisible(false);
        jd.setLocationRelativeTo(this.mainFrame == null ? new JFrame() : new JFrame(this.mainFrame.getGraphicsConfiguration()));
        jv.runJobButton.setIcon(IconUtils.getSmallIcon("job_start.png"));
        jv.stopJobButton.setIcon(IconUtils.getSmallIcon("job_stop.png"));
        jv.addServerButton.setIcon(IconUtils.getSmallIcon("data_add.png"));
        jv.addJobButton.setIcon(IconUtils.getSmallIcon("plus.png"));
        jv.removeJobButton.setIcon(IconUtils.getSmallIcon("delete_trash.png"));
        jv.enableDisableButton.setIcon(IconUtils.getSmallIcon("block.png"));
        jv.editJobButton.setIcon(IconUtils.getSmallIcon("job_edit.png"));
        jv.historyButton.setIcon(IconUtils.getSmallIcon("clock2.png"));
        final JobViewModel jm = new JobViewModel();
        jm.setColumns(Arrays.asList("Server", "Job name", "Started", "Finished", "Duration", "Last result", "Next run"));
        JLabel refresh = new JLabel();
        jv.jobStatusBar.add((Component)refresh, (Object)new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL));
        jv.jobStatusBar.setOpaque(false);
        jv.jobStatusBar.repaint();
        jv.jobTable.setModel((TableModel)((Object)jm));
        jv.jobTable.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        jm.addTableModelListener(tl -> refresh.setText("Last refreshed: " + DateUtils.formatLocalDate(LocalDateTime.now(), true)));
        DefaultJobRenderer cellRenderer = new DefaultJobRenderer();
        int col = 0;
        while (col < jm.getColumnCount()) {
            if (jv.jobTable.getRowSorter() instanceof DefaultRowSorter) {
                DefaultRowSorter sorter = (DefaultRowSorter)jv.jobTable.getRowSorter();
                sorter.setComparator(col, col == 2 ? Comparator.reverseOrder() : Comparator.naturalOrder());
            }
            TableColumn tc = jv.jobTable.getColumn(col);
            if (col == 1) {
                tc.setCellRenderer(new JobServerRenderer(jm));
            } else if (col == 5) {
                tc.setCellRenderer(new JobResultRenderer());
            } else if (col == 4) {
                tc.setCellRenderer(new DefaultJobRenderer(){

                    @Override
                    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (value != null) {
                            this.setText(DateUtils.getDuration((Long)value));
                        }
                        return this;
                    }
                });
            } else {
                tc.setCellRenderer(cellRenderer);
            }
            ++col;
        }
        this.load();
        if (this.jobSettings == null) {
            this.jobSettings = new JobSettings();
        }
        ArrayList<ObjectMonitor<IJobServer>> servers = new ArrayList<ObjectMonitor<IJobServer>>();
        for (IJobServerManager manager : this.managers.values()) {
            List<IJobServer> jobservers = manager.load();
            for (IJobServer server : jobservers) {
                ObjectMonitor<IJobServer> monitor = new ObjectMonitor<IJobServer>(server);
                for (JobSetting setting : this.jobSettings.getJobSettings()) {
                    if (!setting.getId().equals(server.getId())) continue;
                    monitor.setMonitor(setting.isEnabled());
                    monitor.setRefreshRate(setting.getRefreshRate());
                    break;
                }
                servers.add(monitor);
            }
        }
        int refreshRate = this.jobSettings.getRefreshRate() > 0 ? this.jobSettings.getRefreshRate() : 5000;
        final JobHandler handler = new JobHandler(jm, servers, refreshRate, 0);
        jd.setDefaultCloseOperation(0);
        jd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JobAction.this.serializer.saveSettings((JTable)((Object)jv.jobTable), "jobAction.jobTable");
                handler.close();
                jd.setVisible(false);
                JobAction.this.store();
                for (IJobServerManager manager : JobAction.this.managers.values()) {
                    manager.cleanup();
                }
                jd.dispose();
            }
        });
        jv.editPane.addActionListener(l -> this.togglePane(jv));
        jv.editPane.setSelected(this.jobSettings.isToggleEditPane());
        jv.addJobButton.addActionListener(al -> {
            ArrayList<IJobServer> jobServers = new ArrayList<IJobServer>(servers.stream().map(mo -> (IJobServer)mo.getObject()).collect(Collectors.toList()));
            Optional<IJobServer> js = JobAction.getSelectedJobs((JTable)((Object)jobView.jobTable), jm).keySet().stream().findFirst();
            new JobEditor(jd).edit(new ArrayList<IJobServerManager>(this.managers.values()), jobServers, js, true);
        });
        jv.addServerButton.addActionListener(al -> {
            ArrayList<IJobServerManager> serversForEdit = new ArrayList<IJobServerManager>(this.managers.values());
            new JobServerEditor(jd).edit(serversForEdit, servers, (ThrowingConsumer<JobServerResult>)((ThrowingConsumer)res -> {
                List<ObjectMonitor<IJobServer>> list2 = res.getServers();
                if (res.getFailed() > 0) {
                    JOptionPane.showMessageDialog(jd, res.getFailed() + " servers couldn't be saved");
                }
                servers.clear();
                servers.addAll(list2);
                handler.setMonitorServers(servers);
                this.jobSettings.getJobSettings().clear();
                this.jobSettings.getJobSettings().addAll(servers.stream().map(JobSetting::fromMonitorObject).collect(Collectors.toList()));
            }));
        });
        Runnable runJob = () -> this.executeCommand(jd, StandardJobCommand.RUN, "Do you want to run: {count} jobs?", (JTable)((Object)jobView.jobTable), jm);
        jv.runJobButton.addActionListener(al -> runJob.run());
        jv.stopJobButton.addActionListener(al -> this.executeCommand(jd, StandardJobCommand.STOP, "Do you want to stop: {count} jobs?", (JTable)((Object)jobView.jobTable), jm));
        jv.removeJobButton.addActionListener(al -> this.executeCommand(jd, StandardJobCommand.DELETE, "Do you want to delete: {count} jobs?", (JTable)((Object)jobView.jobTable), jm));
        jv.editJobButton.addActionListener(al -> this.executeCommand(jd, StandardJobCommand.EDIT, null, (JTable)((Object)jobView.jobTable), jm));
        jv.enableDisableButton.addActionListener(new EnableDisableJobAction(this.runner, jd, jv, jm));
        jv.jobTable.getSelectionModel().addListSelectionListener(e1 -> {
            if (!e1.getValueIsAdjusting()) {
                this.updateSelectionStatus(jv);
            }
        });
        jv.jobTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int row = jv.jobTable.rowAtPoint(point);
                if (mouseEvent.getClickCount() >= 2 && mouseEvent.getButton() == 1 && row != -1 && jv.jobTable.getSelectedRow() != -1 && jv.jobTable.getSelectedRowCount() == 1) {
                    JobAction.this.executeCommand(jd, StandardJobCommand.EDIT, null, (JTable)((Object)jv.jobTable), jm);
                }
            }
        });
        TableRowFilterSupport.forTable((JTable)((Object)jv.jobTable)).useTableRenderers(true).searchable(true).apply();
        jv.historyButton.addActionListener(al -> new JobHistoryViewer(jm.getDataVector()).display(JobAction.getSelectedJobList((JTable)((Object)jobView.jobTable), jm)));
        this.updateSelectionStatus(jv);
        jv.filterJobTextList.getDocument().addDocumentListener((DocumentListener)new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                JobAction.this.filterFromText(jv, jv.filterJobTextList.getText(), true, re);
            }
        });
        JListUtils.bindArrowsToFilter(jv.filterJobTextList, (JComponent)((Object)jv.jobTable), runJob);
        jv.jobTable.setRowFilter(re);
        this.serializer.restoreSettings((JTable)((Object)jv.jobTable), "jobAction.jobTable");
        jd.setVisible(true);
        SwingUtilities.invokeLater(() -> this.togglePane(jv));
    }

    private void filterFromText(JobView view, String text, boolean scrollTo, FastTextFilter re) {
        ILabel sd;
        String regexFromString = FilterHelper.getRegexFromString2(text);
        int index = view.jobTable.getSelectedRow();
        JobViewModel jobViewModel = (JobViewModel)((Object)view.jobTable.getModel());
        ILabel iLabel = sd = index > -1 ? (IJob)jobViewModel.getValueAt(view.jobTable.convertRowIndexToModel(index)) : null;
        if (sd == null || sd.getLabel().matches(regexFromString)) {
            sd = null;
        }
        view.jobTable.setRowFilter(view.jobTable.getRowFilter() != null ? view.jobTable.getRowFilter() : re);
        if (view.jobTable.getSelectedRow() == -1 && view.jobTable.getRowSorter().getViewRowCount() > 0) {
            view.jobTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (scrollTo) {
            view.jobTable.scrollRowToVisible(view.jobTable.getSelectedRow());
        }
    }

    private void executeCommand(Window w, ICommand command, String commandConfirmation, JTable jobTable, JobViewModel model) {
        Map<IJobServer, List<IJobObject>> jobs = JobAction.getSelectedJobs(jobTable, model);
        int count = this.getJobCount(jobs);
        boolean advancedCommand = false;
        for (IJobServer server : jobs.keySet()) {
            if (!server.needsParameters(command)) continue;
            advancedCommand = true;
            break;
        }
        if (advancedCommand) {
            ArrayList<ICommandResult<IJobObject>> results = new ArrayList<ICommandResult<IJobObject>>();
            for (IJobServer server : jobs.keySet()) {
                ICommandResult<IJobObject> result = server.execute(command, jobs.get(server), this.runner);
                results.add(result);
                if (result.isCancelled()) break;
                if (!result.isQueued()) continue;
                this.runner.setVisible(true);
            }
            return;
        }
        if (count == 0 || commandConfirmation != null && JOptionPane.showConfirmDialog(w, commandConfirmation.replace("{count}", "" + count), "Confirm", 0) == 1) {
            return;
        }
        UIBackgroundRunner.execute((UIOptionSupplier)((UIOptionSupplier)new UIOptionBuilderSupplier(() -> {
            ArrayList<ICommandResult<IJobObject>> results = new ArrayList<ICommandResult<IJobObject>>();
            for (IJobServer server : jobs.keySet()) {
                ICommandResult<IJobObject> result = server.execute(command, (List)jobs.get(server));
                results.add(result);
            }
            return results;
        }, cb -> System.out.println(cb)).build()));
    }

    private int getJobCount(Map<IJobServer, List<IJobObject>> jobs) {
        int count = jobs.values().stream().map(List::size).reduce(0, (a, b) -> a + b);
        return count;
    }

    public static List<IJobObject> getSelectedJobList(JTable table, JobViewModel jm) {
        ArrayList<IJobObject> jobs = new ArrayList<IJobObject>();
        int[] nArray = table.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            try {
                IJob job = (IJob)jm.getValueAt(table.convertRowIndexToModel(i));
                jobs.add(job);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return jobs;
    }

    public static Map<IJobServer, List<IJobObject>> getSelectedJobs(JTable table, JobViewModel jm) {
        HashMap<IJobServer, List<IJobObject>> jobs = new HashMap<IJobServer, List<IJobObject>>();
        int[] nArray = table.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            try {
                IJob job = (IJob)jm.getValueAt(table.convertRowIndexToModel(i));
                jobs.computeIfAbsent(job.getJobServer(), e -> new ArrayList()).add(job);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return jobs;
    }

    private void updateSelectionStatus(JobView view) {
        int selectedCount = view.jobTable.getSelectedRowCount();
        boolean selectedJobs = selectedCount > 0;
        view.editJobButton.setEnabled(selectedCount == 1);
        view.enableDisableButton.setEnabled(selectedJobs);
        view.removeJobButton.setEnabled(selectedJobs);
        view.runJobButton.setEnabled(selectedJobs);
        view.stopJobButton.setEnabled(selectedJobs);
    }

    private void togglePane(JobView jv) {
        if (this.jobSettings != null) {
            this.jobSettings.setToggleEditPane(jv.editPane.isSelected());
        }
        if (jv.editPane.isSelected()) {
            jv.jobSplitPane.setResizeWeight(0.5);
            jv.jobSplitPane.setDividerLocation(0.6);
        } else {
            jv.jobSplitPane.setResizeWeight(1.0);
            jv.jobSplitPane.setDividerLocation(1.0);
        }
    }

    private synchronized void load() {
        if (this.jobSettings == null) {
            try {
                Throwable throwable = null;
                Object var2_6 = null;
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FILENAME), "UTF-8");){
                    this.jobSettings = (JobSettings)GsonFactory.forReading().fromJson((Reader)reader, JobSettings.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JsonSyntaxException jsonE) {
                LOGGER.error("Couldn't load config file", (Throwable)jsonE);
            }
            catch (FileNotFoundException jsonE) {
            }
            catch (Exception ex) {
                LOGGER.error("Couldn't load config file", (Throwable)ex);
            }
        }
    }

    private synchronized void store() {
        GsonFactory.write(FILENAME, this.jobSettings);
    }

    @Override
    public String id() {
        return "jobs";
    }

    private final class FastTextFilter
    extends RowFilter<JobViewModel, Integer> {
        private final JTextField field;

        FastTextFilter(JTextField field) {
            this.field = field;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends JobViewModel, ? extends Integer> entry) {
            String text = this.field.getText();
            if (text.isEmpty()) {
                return true;
            }
            IJob j = (IJob)entry.getValue(999);
            return j == null || j.getLabel().matches(FilterHelper.getRegexFromString2(text));
        }
    }
}

