/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.completion.CompletionUtils;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.core.DocumentListenerAdapter;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.HighlightingFilter;
import com.sigge.filerunner.sql.CancellableCallback;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.view.DefaultListView;
import com.sigge.filerunner.view.EditorManager;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.core.RowFilterExtension;
import com.sigge.filerunner.view.editors.SQLObjectComparatorCreator;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.runners.IRunningState;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.APropertyListModel;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.ListModelClass;
import com.siggemannen.binding.SoftCopy;
import java.awt.Component;
import java.awt.Frame;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.sort.ListSortController;

@Singleton
public class ObjectExplorer {
    private final SQLManager manager;
    private final JFrame parent;
    private final EditorManager editorManager;
    private final RowFilterExtension<SQLObject> re;
    private final Comparator<SQLObject> comparator;
    private String lastFilter = "";
    private final IRunningState scriptReporter;

    @Inject
    public ObjectExplorer(SQLManager manager, EditorManager editorManager, @Named(value="mainFrame") JFrame parent, IRunningState scriptReporter) {
        this.manager = manager;
        this.editorManager = editorManager;
        this.parent = parent;
        this.scriptReporter = scriptReporter;
        this.comparator = new SQLObjectComparatorCreator(manager).createComparator();
        this.re = new RowFilterExtension<SQLObject>(10000000, this.comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLObject present(String preFilter) {
        DefaultListView tv;
        if (preFilter.length() > 0) {
            this.lastFilter = preFilter;
        }
        if (!(tv = new DefaultListView((Frame)this.parent, false, "Browse database objects", "objectBrowser")).isSizeSetFromSettings()) {
            tv.setSize(640, 480);
        }
        TextPaneUtil.configureSyntaxTextArea(tv.getItemDetail());
        BindingHolder t = new BindingHolder();
        final JXList itemList = tv.getItemList();
        itemList.setCellRenderer((ListCellRenderer)new SQLObjectCellRenderer(tv.getSearchField()::getText));
        final BindingModel aModel = new BindingModel();
        DatabaseContext ctx = this.manager.getCurrentContext();
        itemList.addListSelectionListener(e -> {
            SQLObject so = (SQLObject)itemList.getSelectedValue();
            tv.getOpenButton().setEnabled(so != null && !so.isBuiltIn());
        });
        t.setObjects(this.getObjectsFromContext());
        final AtomicBoolean manualChange = new AtomicBoolean(false);
        tv.getSearchField().getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> manualChange.set(true))));
        APresenter<BindingHolder, BindingModel, DefaultListView> presenter = new APresenter<BindingHolder, BindingModel, DefaultListView>(aModel, tv){

            protected void initBindings() {
                this.bind((JList)itemList).to(aModel.objectsModel);
                this.bind((JTextComponent)((DefaultListView)this.view).getItemDetail()).to(aModel.objectDescription);
                aModel.objectDescription.addListener(() -> SwingUtilities.invokeLater(() -> {
                    ((DefaultListView)this.view).getItemDetail().setCaretPosition(0);
                    ((DefaultListView)this.view).getItemDetail().discardAllEdits();
                }));
                ((DefaultListView)this.view).getItemDetail().setSyntaxEditingStyle("text/tsql");
                itemList.setSortable(true);
                itemList.setRowFilter((RowFilter)ObjectExplorer.this.re);
                ((DefaultListView)this.view).getSearchField().setHint("Search for objects...");
                ((DefaultListView)this.view).getSearchField().getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> this.filterText())));
                ((DefaultListView)this.view).getOpenButton().addActionListener(a -> this.openObject());
                JListUtils.bindArrowsToFilter(((DefaultListView)this.view).getSearchField(), (JComponent)((DefaultListView)this.view).getItemList(), this::openObject);
            }

            private void filterText() {
                ObjectExplorer.this.lastFilter = ((DefaultListView)this.view).getSearchField().getText();
                String regexFromString = FilterHelper.getRegexFromString2(ObjectExplorer.this.lastFilter);
                ObjectExplorer.this.re.filterOut(((BindingModel)this.model).objectsModel.getObject().parallelStream().filter(v -> v == null || ObjectExplorer.this.lastFilter.length() == 0 || v.getName().length() >= ObjectExplorer.this.lastFilter.length() && v.getName().matches(regexFromString) || v.getFullName().length() >= ObjectExplorer.this.lastFilter.length() && v.getFullName().matches(regexFromString)), null);
                itemList.setRowFilter((RowFilter)ObjectExplorer.this.re);
                if (itemList.getSelectedValue() == null && itemList.getRowSorter().getViewRowCount() > 0) {
                    itemList.setSelectedIndex(0);
                }
                itemList.ensureIndexIsVisible(itemList.getSelectedIndex());
            }

            protected void afterObjectSet() {
                ListSortController sorter = new ListSortController(((BindingModel)this.model).objectsModel);
                itemList.setRowSorter((RowSorter)sorter);
                if (!manualChange.get()) {
                    ObjectExplorer.this.setFilter((DefaultListView)this.view);
                }
                this.filterText();
                ((DefaultListView)this.view).getItemDetail().setCaretPosition(0);
            }

            private void openObject() {
                if (itemList.getRowSorter().getViewRowCount() == 0) {
                    return;
                }
                SQLObject selectedItem = this.getSelectedItem();
                if (selectedItem == null || selectedItem.isBuiltIn()) {
                    return;
                }
                ObjectExplorer.this.re.hit(selectedItem);
                Optional<SQLScriptState> state = ObjectExplorer.this.scriptReporter.getCurrentState();
                Consumer<String> definitionConsumer = !ObjectExplorer.this.editorManager.currentTab().isAFile() && ObjectExplorer.this.editorManager.getCurrentText().length() <= selectedItem.getFullName().length() + 3 && state.map(SQLScriptState::getLastRunResultsSets).orElse(0) == 0 && (ObjectExplorer.this.editorManager.getCurrentText().length() == 0 || state.map(SQLScriptState::getRunContext).orElse(null) == null) && ObjectExplorer.this.editorManager.getAreaForContent(ObjectExplorer.this.editorManager.currentTab()) != null ? s -> SwingUtilities.invokeLater(() -> {
                    if (s == null) {
                        return;
                    }
                    ObjectExplorer.this.editorManager.getCurrentTab().setText(s);
                    ObjectExplorer.this.editorManager.replaceCurrent(selectedItem.getName(), (String)s);
                    ObjectExplorer.this.editorManager.getCurrentTab().setCaretPosition(0);
                    ((DefaultListView)this.view).setVisible(false);
                    ((DefaultListView)this.view).dispose();
                }) : d -> SwingUtilities.invokeLater(() -> {
                    if (d == null) {
                        return;
                    }
                    ObjectExplorer.this.editorManager.newFile(selectedItem.getName(), (String)d);
                    ((DefaultListView)this.view).setVisible(false);
                    ((DefaultListView)this.view).dispose();
                });
                ObjectExplorer.this.manager.getObjectDefinition(selectedItem, definitionConsumer, e -> SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(ObjectExplorer.this.parent, "Cannot open object definition of: " + selectedItem.getFullName() + ". Error was: " + e.getMessage(), "Opening definition failed", 1)));
            }

            private SQLObject getSelectedItem() {
                return (SQLObject)((BindingModel)this.model).objectsModel.getSelectedItem();
            }
        };
        AtomicBoolean cancelled = new AtomicBoolean(false);
        CancellableCallback callback = new CancellableCallback(() -> this.lambda$3(cancelled, tv, t, (APresenter)presenter));
        if (ctx != null && !ctx.isLoaded(callback)) {
            AtomicBoolean atomicBoolean = cancelled;
            synchronized (atomicBoolean) {
                if (!cancelled.get()) {
                    tv.getBusyLabel().setText("Loading objects...");
                    tv.getBusyLabel().setVisible(true);
                    tv.getBusyLabel().setBusy(true);
                    this.setFilter(tv);
                }
            }
        } else {
            presenter.setObject((Object)t);
        }
        tv.setVisible(true);
        return (SQLObject)((BindingModel)presenter.getModel()).objectsModel.getSelectedItem();
    }

    private void setFilter(DefaultListView view) {
        if (!this.lastFilter.matches("(?s).*[\n\r].*")) {
            view.getSearchField().setText(this.lastFilter);
        }
        view.getSearchField().selectAll();
    }

    private List<SQLObject> getObjectsFromContext() {
        return this.manager.getByFilter(l -> true).sorted(this.comparator).collect(Collectors.toList());
    }

    private String resolve(SQLObject so) {
        if (so != null) {
            return this.manager.getObjectDefinition(so, e -> {}).orElse(so.getFullName());
        }
        return null;
    }

    private /* synthetic */ void lambda$3(AtomicBoolean atomicBoolean, DefaultListView defaultListView, BindingHolder bindingHolder, APresenter aPresenter) throws Throwable {
        SwingUtilities.invokeLater(() -> {
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            synchronized (atomicBoolean2) {
                atomicBoolean.set(true);
                defaultListView.getBusyLabel().setBusy(false);
                defaultListView.getBusyLabel().setVisible(false);
                List<SQLObject> obs = this.getObjectsFromContext();
                bindingHolder.setObjects(obs);
                aPresenter.setObject((Object)bindingHolder);
            }
        });
    }

    @SoftCopy
    class BindingHolder
    extends ListModelClass<SQLObject> {
        BindingHolder() {
        }
    }

    class BindingModel
    extends AModel<BindingHolder> {
        final IProperty<String> objectDescription = this.getProperty(l -> ObjectExplorer.access$0(ObjectExplorer.this, (SQLObject)l.getCurrent()));
        final AModel.BoundedListProperty<SQLObject> objects = this.getBoundListProperty("objects", "current", new IProperty[]{this.objectDescription});
        final APropertyListModel<SQLObject> objectsModel = new APropertyListModel(this.objects);

        BindingModel() {
        }
    }

    class SQLObjectCellRenderer
    extends DefaultListCellRenderer {
        private final Supplier<String> filterSupplier;
        HighlightingFilter prev;
        String prevString;
        private final Border DEFAULT_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);

        public SQLObjectCellRenderer(Supplier<String> filterSupplier) {
            this.filterSupplier = filterSupplier;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setBorder(this.DEFAULT_BORDER);
            if (value != null && value instanceof SQLObject) {
                boolean filterActive;
                SQLObject sl = (SQLObject)value;
                String name = String.valueOf(sl.getContext() != null && sl.getContext().needsSchema(sl) ? String.valueOf(sl.getSchemaName()) + "." : "") + sl.getName();
                boolean bl = filterActive = ObjectExplorer.this.re.getFilteredCount() < 200;
                if (filterActive) {
                    String filter = this.filterSupplier.get();
                    if (!filter.equals(this.prevString)) {
                        this.prev = new HighlightingFilter(filter);
                        this.prevString = filter;
                    }
                    name = this.prev.highlight(name);
                }
                if (!ObjectExplorer.this.manager.getCurrents().contains(sl.getContext().getDatabase())) {
                    name = String.valueOf(name) + " @" + sl.getContext().getDatabase();
                }
                if (filterActive) {
                    label.setText("<html>" + name + "</html>");
                } else {
                    label.setText(name);
                }
                label.setIcon(CompletionUtils.getIconForType(sl));
            }
            return label;
        }
    }
}

