/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.siggemannen.core.Tuple;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

class DotAndCommaFormatter
extends NumberFormat {
    private final NumberFormat childFormat1 = NumberFormat.getInstance();
    private final DecimalFormat childFormat2;

    public DotAndCommaFormatter() {
        this.childFormat1.setGroupingUsed(false);
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.childFormat2 = new DecimalFormat();
        this.childFormat2.setDecimalFormatSymbols(decimalFormatSymbols);
        this.childFormat2.setGroupingUsed(false);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        if (obj == null) {
            return new AttributedString("").getIterator();
        }
        return this.childFormat1.formatToCharacterIterator(obj);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return new StringBuffer("");
        }
        return this.childFormat1.format(obj, toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition pos) {
        if (source == null) {
            pos.setIndex(1);
            return null;
        }
        if (source.trim().equals("")) {
            pos.setIndex(1);
            return null;
        }
        Tuple<Boolean, Number> nx = this.parseInternal(source, pos, this.childFormat1);
        if (((Boolean)nx.first()).booleanValue()) {
            Tuple<Boolean, Number> nx2 = this.parseInternal(source, pos, this.childFormat2);
            return (Number)nx2.second();
        }
        return (Number)nx.second();
    }

    private Tuple<Boolean, Number> parseInternal(String source, ParsePosition pos, NumberFormat formatter) {
        Number val = formatter.parse(source, pos);
        boolean error = false;
        if (pos.getIndex() != source.length()) {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(0);
            error = true;
        }
        return Tuple.of((Object)error, (Object)val);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.childFormat1.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.childFormat1.format(number, toAppendTo, pos);
    }
}

