/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.database;

import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.database.AddDatabase;
import com.sigge.filerunner.view.database.AddDatabaseModel;
import com.sigge.filerunner.view.database.AddDatabasePresenter;
import com.sigge.filerunner.view.database.AddDatabaseView;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class AddDatabaseAction
implements ActionListener {
    private final JFrame mainFrame;
    private final RunnerModel model;
    private final DatabaseManager dbm;
    private final Runnable onReload;
    private final SQLManager manager;

    public AddDatabaseAction(JFrame mainFrame, RunnerModel model, DatabaseManager dbm, Runnable onReload, SQLManager manager) {
        this.mainFrame = mainFrame;
        this.model = model;
        this.dbm = dbm;
        this.onReload = onReload;
        this.manager = manager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AddDatabaseView chooser = new AddDatabaseView(this.mainFrame);
        AddDatabaseModel dbmodel = new AddDatabaseModel(GsonFactory.forReading());
        AddDatabasePresenter presenter = new AddDatabasePresenter(dbmodel, chooser, this.dbm, this.manager);
        AddDatabase a = new AddDatabase();
        List servers = (List)this.model.getServers().getValue();
        List<RunnerServerConfig> configs = servers.stream().map(RunnerServerConfig::new).collect(Collectors.toList());
        if (configs.isEmpty()) {
            configs.add(a.getServer());
        }
        a.setServers(configs);
        presenter.setObject(a);
        chooser.chooseDatabases();
        this.model.getServers().setValue(((AddDatabase)dbmodel.getObject()).getServers().stream().filter(this.dbm::isValid).collect(Collectors.toList()));
        if (presenter.hasSomeChanges()) {
            try {
                if (ConfigHandler.getConfig().isEncryptedData()) {
                    DatabaseManager.encrypt(true);
                }
                this.onReload.run();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mainFrame, "Couldn't save databases due to " + ex.getMessage(), "Error while saving / retrieving dbs", 0);
            }
        }
    }
}

