/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.view.core.FindColumnAction;
import com.sigge.filerunner.view.core.FixedSearchFactory;
import com.sigge.filerunner.view.core.MenuScroller;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableComponentTip;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnControlPopup;

public class VTable
extends JXTable {
    private static final String FIND_COLUMN_ACTION = "column..1.findColumns";
    private final FocusableComponentTip focusableTip = new FocusableComponentTip((JComponent)((Object)this), null);

    public VTable() {
        this.setGridColor();
    }

    public VTable(TableModel dm) {
        super(dm);
        this.setGridColor();
    }

    public VTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.setGridColor();
    }

    public VTable(TableModel dm, TableColumnModel cm, ListSelectionModel lsm) {
        super(dm, cm, lsm);
        this.setGridColor();
    }

    private void setGridColor() {
        this.setGridColor(new Color(223, 220, 214));
    }

    public String getToolTipText(MouseEvent event) {
        String tip = super.getToolTipText(event);
        if (tip != null) {
            return tip;
        }
        Point p = event.getPoint();
        int row = this.rowAtPoint(p);
        int column = this.columnAtPoint(p);
        if (row == -1 || column == -1) {
            return null;
        }
        TableCellRenderer renderer = this.getCellRenderer(row, column);
        Component c = renderer.getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(row, column), false, false, row, column);
        String text = null;
        if (c.getPreferredSize().width > this.getCellRect((int)row, (int)column, (boolean)false).width) {
            if (c instanceof JLabel) {
                text = ((JLabel)c).getText();
            }
            if (c instanceof JButton) {
                text = ((JButton)c).getText();
            }
        }
        if (text != null) {
            this.focusableTip.setImageBase(null);
            this.focusableTip.toolTipRequested(p, text);
        } else if (this.focusableTip != null) {
            this.focusableTip.possiblyDisposeOfTipWindow();
        }
        return null;
    }

    protected JComponent createDefaultColumnControl() {
        ActionMap map = this.getActionMap();
        map.put(FIND_COLUMN_ACTION, new FindColumnAction(this));
        this.getInputMap().put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), FIND_COLUMN_ACTION);
        return new VColumnControlButton(this);
    }

    static {
        SearchFactory.setInstance((SearchFactory)new FixedSearchFactory());
    }

    public class VColumnControlButton
    extends ColumnControlButton {
        public VColumnControlButton(JXTable table) {
            super(table);
        }

        public VColumnControlButton(JXTable table, Icon icon) {
            super(table, icon);
        }

        protected void populatePopup() {
            super.populatePopup();
            MenuScroller.setScrollerFor(((VColumnControlPopup)this.popup).getPopup(), 20, 150, 0, 4);
        }

        protected ColumnControlPopup createColumnControlPopup() {
            return new VColumnControlPopup();
        }

        public class VColumnControlPopup
        extends ColumnControlButton.DefaultColumnControlPopup {
            public VColumnControlPopup() {
                super((ColumnControlButton)VColumnControlButton.this);
            }

            public JPopupMenu getPopup() {
                return this.getPopupMenu();
            }
        }
    }
}

