/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.google.inject.Singleton;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.view.core.ITableSerializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

@Singleton
public class TableSerializer
implements ITableSerializer {
    private static final String DEFAULT_FILE = "db/tviews.json";
    private TableSettings mainSetting;
    private String file;

    public TableSerializer() {
        this(DEFAULT_FILE);
    }

    public TableSerializer(String filename) {
        this.file = filename;
        try {
            this.mainSetting = (TableSettings)GsonFactory.read(filename, TableSettings.class);
        }
        catch (Exception ex) {
            this.mainSetting = new TableSettings();
        }
    }

    @Override
    public synchronized void saveSettings(JTable jt, String identifier) {
        if (jt == null) {
            this.mainSetting.settings.remove(identifier);
        } else {
            Setting s = this.getSettingFromTable(jt, identifier);
            this.mainSetting.settings.put(s.identifier, s);
        }
        this.store();
    }

    protected Setting getSettingFromTable(JTable t, String id) {
        Setting s = new Setting();
        s.identifier = id;
        TableColumnModel columnModel = t.getColumnModel();
        List<TableColumn> columns = columnModel instanceof TableColumnModelExt ? ((TableColumnModelExt)columnModel).getColumns(true) : Collections.list(columnModel.getColumns());
        int i = 0;
        while (i < columns.size()) {
            TableColumn tc = columns.get(i);
            Column c = new Column();
            c.identifier = (String)tc.getIdentifier();
            c.modelIndex = i;
            c.viewIndex = t.convertColumnIndexToView(i);
            if (tc instanceof TableColumnExt) {
                TableColumnExt tableColumnExt = (TableColumnExt)tc;
                c.visible = tableColumnExt.isVisible();
            } else {
                c.visible = c.viewIndex == -1;
            }
            c.width = tc.getWidth();
            s.columns.put(c.identifier, c);
            ++i;
        }
        return s;
    }

    @Override
    public void restoreSettings(JTable jt, String identifier) {
        if (this.mainSetting == null) {
            return;
        }
        Setting setting = this.mainSetting.settings.get(identifier);
        if (setting == null) {
            return;
        }
        int i = 0;
        while (i < jt.getColumnCount()) {
            int j = 0;
            while (j < jt.getColumnCount() - 1) {
                TableColumnModel columnModel = jt.getColumnModel();
                Column col1 = (Column)setting.columns.get(columnModel.getColumn(j).getIdentifier());
                Column col2 = (Column)setting.columns.get(columnModel.getColumn(j + 1).getIdentifier());
                if (col1 == null && col2 != null || col1 != null && !col1.visible || col1 != null && col2 != null && col1.viewIndex > col2.viewIndex) {
                    jt.moveColumn(j, j + 1);
                }
                ++j;
            }
            ++i;
        }
        TableColumnModel columnModel = jt.getColumnModel();
        List<TableColumn> columns = columnModel instanceof TableColumnModelExt ? ((TableColumnModelExt)columnModel).getColumns(true) : Collections.list(columnModel.getColumns());
        int i2 = 0;
        while (i2 < columns.size()) {
            Column colsetting;
            TableColumn tc = columns.get(i2);
            String columnId = (String)tc.getIdentifier();
            if (columnId != null && (colsetting = (Column)setting.columns.get(columnId)) != null) {
                if (tc instanceof TableColumnExt) {
                    TableColumnExt ext = (TableColumnExt)tc;
                    ext.setVisible(colsetting.isVisible());
                }
                if (colsetting.width > 0) {
                    tc.setWidth(colsetting.width);
                    tc.setPreferredWidth(colsetting.width);
                }
            }
            ++i2;
        }
    }

    void store() {
        GsonFactory.write(this.file, this.mainSetting);
    }

    public static class Column {
        private String identifier;
        private int modelIndex;
        private int viewIndex;
        private boolean visible;
        private int width;

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public void setModelIndex(int modelIndex) {
            this.modelIndex = modelIndex;
        }

        public int getViewIndex() {
            return this.viewIndex;
        }

        public void setViewIndex(int viewIndex) {
            this.viewIndex = viewIndex;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }

    public static class Setting {
        private String identifier;
        private Map<String, Column> columns = new HashMap<String, Column>();

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public Map<String, Column> getColumns() {
            return this.columns;
        }

        public void setColumns(Map<String, Column> columns) {
            this.columns = columns;
        }
    }

    public static class TableSettings {
        Map<String, Setting> settings = new HashMap<String, Setting>();
    }
}

