/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.view.DefaultTableTransferHandler;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TableRowUtilities {
    public static JTable addNumberColumn(final JTable userTable, int startingNumber, boolean isRowSelectable, final String header) {
        Container parentParentContainer;
        Container parentContainer = userTable.getParent();
        if (parentContainer instanceof JViewport && (parentParentContainer = parentContainer.getParent()) instanceof JScrollPane) {
            final JScrollPane scrollPane = (JScrollPane)parentParentContainer;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != userTable) {
                return null;
            }
            JTableHeader tableHeader = userTable.getTableHeader();
            scrollPane.setColumnHeaderView(tableHeader);
            TableRowUtilities tableRowUtilities = new TableRowUtilities();
            tableRowUtilities.getClass();
            final JTable rowHeadersTable = new JTable(tableRowUtilities.new RowHeadersTableModel(userTable, userTable.getModel().getRowCount(), startingNumber, header));
            final JLabel label = new JLabel();
            userTable.getModel().addTableModelListener(e -> TableRowUtilities.handleTableChangeEvent(userTable, rowHeadersTable, label, false));
            userTable.getRowSorter().addRowSorterListener(l -> TableRowUtilities.handleTableChangeEvent(userTable, rowHeadersTable, label, true));
            scrollPane.getVerticalScrollBar().addAdjustmentListener(e -> {
                int scrollBarValue = e.getValue();
                TableRowUtilities.adjustColumnWidth(rowHeadersTable, label, scrollBarValue, header);
            });
            rowHeadersTable.createDefaultColumnsFromModel();
            userTable.setColumnSelectionAllowed(true);
            rowHeadersTable.setBackground(rowHeadersTable.getTableHeader().getBackground());
            rowHeadersTable.setForeground(rowHeadersTable.getTableHeader().getForeground());
            rowHeadersTable.setFont(rowHeadersTable.getTableHeader().getFont());
            rowHeadersTable.setRowHeight(userTable.getRowHeight());
            rowHeadersTable.setTransferHandler(new DefaultTableTransferHandler.ForwardedTransferHandler(userTable));
            rowHeadersTable.getTableHeader().setReorderingAllowed(false);
            rowHeadersTable.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (userTable.getSelectedRowCount() == userTable.getRowCount()) {
                        userTable.clearSelection();
                    } else {
                        userTable.selectAll();
                    }
                    e.consume();
                }
            });
            if (isRowSelectable) {
                rowHeadersTable.getColumnModel().getColumn(0).setCellRenderer((table, value, isSelected, hasFocus, row, column) -> {
                    label.setText("" + value);
                    if (isSelected) {
                        label.setForeground(rowHeadersTable.getSelectionForeground());
                        label.setBackground(rowHeadersTable.getSelectionBackground());
                    } else {
                        label.setBackground(rowHeadersTable.getBackground());
                        label.setForeground(rowHeadersTable.getForeground());
                    }
                    return label;
                });
                rowHeadersTable.setRowSelectionAllowed(true);
                rowHeadersTable.setCellSelectionEnabled(true);
                rowHeadersTable.setFocusable(true);
                rowHeadersTable.setDragEnabled(true);
            }
            scrollPane.setRowHeaderView(rowHeadersTable);
            scrollPane.setCorner("UPPER_LEFT_CORNER", rowHeadersTable.getTableHeader());
            Border border = scrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
            scrollPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    TableRowUtilities.adjustColumnWidth(rowHeadersTable, label, scrollPane.getVerticalScrollBar().getValue(), header);
                }
            });
            TableRowUtilities tableRowUtilities2 = new TableRowUtilities();
            tableRowUtilities2.getClass();
            final TableListener listener = tableRowUtilities2.new TableListener(rowHeadersTable, userTable);
            rowHeadersTable.setSelectionMode(userTable.getSelectionModel().getSelectionMode());
            rowHeadersTable.setColumnSelectionAllowed(false);
            rowHeadersTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    int row = rowHeadersTable.rowAtPoint(evt.getPoint());
                    if (row >= 0 && rowHeadersTable.getSelectedRow() == row) {
                        listener.valueChanged(new ListSelectionEvent(rowHeadersTable.getSelectionModel(), row, row, false));
                    }
                }
            });
            return rowHeadersTable;
        }
        return null;
    }

    private static void handleTableChangeEvent(JTable userTable, JTable rowHeadersTable, JLabel label, boolean change) {
        RowHeadersTableModel m = (RowHeadersTableModel)rowHeadersTable.getModel();
        if (userTable.getRowCount() != m.getRowCount()) {
            m.setRowCount(userTable.getRowCount());
            SwingUtilities.invokeLater(() -> {
                TableRowUtilities.adjustColumnWidth(rowHeadersTable, label, 0, "");
                rowHeadersTable.invalidate();
            });
        } else if (change) {
            SwingUtilities.invokeLater(() -> {
                TableRowUtilities.adjustColumnWidth(rowHeadersTable, label, 0, "");
                rowHeadersTable.invalidate();
            });
        }
    }

    private static void adjustColumnWidth(JTable rowHeadersTable, JLabel label, int scrollBarValue, String header) {
        label.setFont(rowHeadersTable.getFont());
        label.setOpaque(true);
        label.setHorizontalAlignment(0);
        int v = rowHeadersTable.getVisibleRect().height;
        int row = rowHeadersTable.rowAtPoint(new Point(0, v + scrollBarValue));
        String modelValue = null;
        if (row != -1) {
            modelValue = (String)rowHeadersTable.getModel().getValueAt(row, 0);
        } else {
            RowHeadersTableModel tm = (RowHeadersTableModel)rowHeadersTable.getModel();
            modelValue = tm.getMaxIntValue();
        }
        if (modelValue.length() == 1) {
            modelValue = "99";
        }
        label.setText(modelValue);
        FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
        int widthFactor = 0;
        if (fontMetrics != null && label.getText() != null) {
            widthFactor = fontMetrics.stringWidth(label.getText());
            rowHeadersTable.setPreferredScrollableViewportSize(new Dimension(widthFactor + 8, 100));
            rowHeadersTable.repaint();
        }
    }

    public static int convertColumnIndexToModel(TableColumnModel cm, int viewColumnIndex) {
        if (viewColumnIndex < 0) {
            return viewColumnIndex;
        }
        return cm.getColumn(viewColumnIndex).getModelIndex();
    }

    class RowHeadersTableModel
    extends AbstractTableModel {
        private final int startNumber;
        private final String headerName;
        private int maxRow;
        private final int maxRowCount;
        private final JTable parent;

        public RowHeadersTableModel(JTable parent, int maxNumber, int startingNumber, String headerName) {
            this.startNumber = startingNumber;
            this.headerName = headerName;
            this.maxRow = maxNumber;
            this.maxRowCount = maxNumber;
            this.parent = parent;
        }

        public void setRowCount(int rowCount) {
            this.maxRow = rowCount;
        }

        @Override
        public int getRowCount() {
            return this.maxRow;
        }

        public String getMaxIntValue() {
            return this.maxRow > 0 ? (String)this.getValueAt(this.maxRow - 1, 0) : "99";
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.maxRowCount == this.maxRow) {
                return "" + (rowIndex + this.startNumber);
            }
            int convertedValue = this.parent.convertRowIndexToModel(rowIndex);
            if (convertedValue == rowIndex) {
                return "" + (rowIndex + this.startNumber);
            }
            return rowIndex + this.startNumber + "/" + (convertedValue + this.startNumber);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            super.addTableModelListener(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            super.removeTableModelListener(l);
        }
    }

    class TableListener
    implements ListSelectionListener {
        private final JTable rowHeadersTable;
        private final JTable userTable;
        private final JViewport userTableViewPort;
        private final JViewport rowHeadersViewPort;
        private int[] lastSelectedColumns;

        public TableListener(JTable rowHeadersTable, JTable userTable) {
            this.userTable = userTable;
            this.rowHeadersTable = rowHeadersTable;
            this.lastSelectedColumns = userTable.getSelectedColumns();
            Container p = userTable.getParent();
            this.userTableViewPort = (JViewport)p;
            Container p2 = rowHeadersTable.getParent();
            this.rowHeadersViewPort = (JViewport)p2;
            Point newPosition = this.userTableViewPort.getViewPosition();
            this.rowHeadersViewPort.setViewPosition(newPosition);
            rowHeadersTable.getSelectionModel().addListSelectionListener(this);
            userTable.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.userTable.getSelectionModel()) {
                int[] rows = this.userTable.getSelectedRows();
                if (e.getFirstIndex() == 0 && e.getLastIndex() == rows.length - 1 && rows.length == this.userTable.getRowCount()) {
                    if (this.rowHeadersTable.getSelectedRowCount() != rows.length) {
                        this.rowHeadersTable.getSelectionModel().removeListSelectionListener(this);
                        this.rowHeadersTable.selectAll();
                        this.rowHeadersTable.getSelectionModel().addListSelectionListener(this);
                    }
                } else {
                    this.rowHeadersTable.getSelectionModel().removeListSelectionListener(this);
                    this.rowHeadersTable.getSelectionModel().clearSelection();
                    int i = 0;
                    while (i < rows.length) {
                        this.rowHeadersTable.getSelectionModel().addSelectionInterval(rows[i], rows[i]);
                        ++i;
                    }
                    this.rowHeadersTable.getSelectionModel().addListSelectionListener(this);
                }
                if (rows.length > 0 && this.userTable.getColumnModel().getSelectedColumnCount() == 0 && this.lastSelectedColumns.length > 0) {
                    this.userTable.addColumnSelectionInterval(this.lastSelectedColumns[0], this.lastSelectedColumns[0]);
                }
            } else if (e.getSource() == this.rowHeadersTable.getSelectionModel()) {
                boolean isColumnSelectionAllowed = this.userTable.getColumnSelectionAllowed();
                boolean isRowSelectionAllowed = this.userTable.getRowSelectionAllowed();
                boolean isCellSelectionAllowed = this.userTable.getCellSelectionEnabled();
                this.userTable.getSelectionModel().removeListSelectionListener(this);
                this.userTable.getSelectionModel().clearSelection();
                int[] rows = this.rowHeadersTable.getSelectedRows();
                if (isRowSelectionAllowed && !isCellSelectionAllowed && !isColumnSelectionAllowed) {
                    int i = 0;
                    while (i < rows.length) {
                        this.userTable.addRowSelectionInterval(rows[i], rows[i]);
                        this.userTableViewPort.setViewPosition(this.rowHeadersViewPort.getViewPosition());
                        ++i;
                    }
                } else {
                    this.userTableViewPort.setScrollMode(2);
                    int i = 0;
                    while (i < rows.length) {
                        if (i == 0) {
                            this.userTable.changeSelection(rows[i], 0, false, false);
                            this.userTable.changeSelection(rows[i], this.userTable.getColumnCount() - 1, false, true);
                        } else {
                            this.userTable.addRowSelectionInterval(rows[i], rows[i]);
                        }
                        ++i;
                    }
                }
                this.userTable.getSelectionModel().addListSelectionListener(this);
            }
            this.lastSelectedColumns = this.userTable.getSelectedColumns();
        }
    }
}

