/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.view.core.LabelProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCheckBoxTree
extends JTree {
    private static final long serialVersionUID = -4194122328392241790L;
    JCheckBoxTree selfPointer = this;
    private LabelProvider render = null;
    private static Logger LOGGER = LoggerFactory.getLogger(JCheckBoxTree.class);
    HashMap<TreePath, CheckedNode> nodesCheckingState;
    HashSet<TreePath> checkedPaths = new HashSet();
    protected EventListenerList listenerList = new EventListenerList();

    public void setTreeRenderer(LabelProvider renderer) {
        this.render = renderer;
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
        this.revalidate();
        this.repaint();
    }

    public void addCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.add(CheckChangeEventListener.class, listener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.remove(CheckChangeEventListener.class, listener);
    }

    void fireCheckChangeEvent(CheckChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)listeners[i + 1]).checkStateChanged(evt);
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.resetCheckingState();
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[this.checkedPaths.size()]);
    }

    public boolean isSelectedPartially(TreePath path) {
        CheckedNode cn = this.nodesCheckingState.get(path);
        return cn.isSelected && cn.hasChildren && !cn.allChildrenSelected;
    }

    public void resetCheckingState() {
        this.nodesCheckingState = new HashMap();
        this.checkedPaths = new HashSet();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(node);
    }

    public void quickResetAllChecks() {
        this.checkSubTree(new TreePath(((DefaultMutableTreeNode)this.getModel().getRoot()).getPath()), false);
    }

    public void addSubtreeToCheckingStateTracking(DefaultMutableTreeNode node) {
        Object[] path = node.getPath();
        TreePath tp = new TreePath(path);
        CheckedNode cn = new CheckedNode(false, node.getChildCount() > 0, false);
        this.nodesCheckingState.put(tp, cn);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addSubtreeToCheckingStateTracking((DefaultMutableTreeNode)tp.pathByAddingChild(node.getChildAt(i)).getLastPathComponent());
        }
    }

    public JCheckBoxTree() {
        this.setToggleClickCount(0);
        CheckBoxCellRenderer cellRenderer = new CheckBoxCellRenderer();
        this.setCellRenderer(cellRenderer);
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -8190634240451667286L;

            @Override
            public void setSelectionPath(TreePath path) {
            }

            @Override
            public void addSelectionPath(TreePath path) {
            }

            @Override
            public void removeSelectionPath(TreePath path) {
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
            }
        };
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                TreePath tp = JCheckBoxTree.this.selfPointer.getPathForLocation(arg0.getX(), arg0.getY());
                if (tp == null) {
                    return;
                }
                boolean checkMode = !JCheckBoxTree.this.nodesCheckingState.get((Object)tp).isSelected;
                JCheckBoxTree.this.setCheckStatus(tp, checkMode, true);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.setSelectionModel(dtsm);
    }

    private void setCheckStatus(TreePath tp, boolean checkStatus, boolean fireEvent) {
        this.checkSubTree(tp, checkStatus);
        this.updatePredecessorsWithCheckMode(tp, checkStatus, this.nodesCheckingState);
        if (fireEvent) {
            this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
        }
        this.selfPointer.repaint();
    }

    public void setCheckStatus(List<TreePath> tps, boolean checkStatus) {
        this.setCheckStatus(tps, checkStatus, false);
    }

    private void setCheckStatus(List<TreePath> tps, boolean checkStatus, boolean triggerEvent) {
        for (TreePath tp : tps) {
            this.checkSubTree(tp, checkStatus);
            this.updatePredecessorsWithCheckMode(tp, checkStatus, this.nodesCheckingState);
        }
        if (triggerEvent) {
            this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
        }
        this.selfPointer.repaint();
    }

    protected void updatePredecessorsWithCheckMode(TreePath tp, boolean check, HashMap<TreePath, CheckedNode> nodesCheckingState) {
        if (tp == null) {
            return;
        }
        TreePath parentPath = tp.getParentPath();
        if (parentPath == null) {
            return;
        }
        CheckedNode parentCheckedNode = nodesCheckingState.get(parentPath);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        parentCheckedNode.allChildrenSelected = true;
        parentCheckedNode.isSelected = false;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreePath childPath = parentPath.pathByAddingChild(parentNode.getChildAt(i));
            CheckedNode childCheckedNode = nodesCheckingState.get(childPath);
            if (childCheckedNode == null) {
                LOGGER.error("Error resolving tree path {}, parent: {}", (Object)childPath, (Object)parentNode);
            }
            if (!childCheckedNode.allChildrenSelected) {
                parentCheckedNode.allChildrenSelected = false;
            }
            if (!childCheckedNode.isSelected) continue;
            parentCheckedNode.isSelected = true;
        }
        if (parentCheckedNode.isSelected) {
            this.checkedPaths.add(parentPath);
        } else {
            this.checkedPaths.remove(parentPath);
        }
        this.updatePredecessorsWithCheckMode(parentPath, check, nodesCheckingState);
    }

    protected void checkSubTree(TreePath tp, boolean check) {
        CheckedNode cn = this.nodesCheckingState.get(tp);
        if (cn == null) {
            return;
        }
        cn.isSelected = check;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.checkSubTree(tp.pathByAddingChild(node.getChildAt(i)), check);
        }
        cn.allChildrenSelected = check;
        if (check) {
            this.checkedPaths.add(tp);
        } else {
            this.checkedPaths.remove(tp);
        }
    }

    private class CheckBoxCellRenderer
    extends JCheckBox
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7341833835878991719L;

        private CheckBoxCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            TreePath tp = new TreePath(node.getPath());
            CheckedNode cn = JCheckBoxTree.this.nodesCheckingState.get(tp);
            this.setText(JCheckBoxTree.this.render == null ? obj.toString() : JCheckBoxTree.this.render.getLabel(obj));
            this.setSizeFromText();
            if (cn == null) {
                return this;
            }
            this.setSelected(cn.isSelected);
            if (cn.isSelected) {
                this.setBackground(Color.YELLOW);
                this.setOpaque(true);
            } else {
                this.setBackground(null);
                this.setOpaque(false);
            }
            this.setSizeFromText();
            this.revalidate();
            return this;
        }

        private void setSizeFromText() {
            int computeStringWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.getText());
            this.setSize(new Dimension(computeStringWidth + 50, (int)this.getPreferredSize().getHeight()));
            this.setPreferredSize(new Dimension(computeStringWidth + 50, (int)this.getPreferredSize().getHeight()));
            this.setMinimumSize(new Dimension(computeStringWidth + 50, (int)this.getPreferredSize().getHeight()));
        }
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public class CheckChangeEvent
    extends EventObject {
        private static final long serialVersionUID = -8100230309044193368L;

        public CheckChangeEvent(Object source) {
            super(source);
        }
    }

    private class CheckedNode {
        boolean isSelected;
        boolean hasChildren;
        boolean allChildrenSelected;

        public CheckedNode(boolean isSelected_, boolean hasChildren_, boolean allChildrenSelected_) {
            this.isSelected = isSelected_;
            this.hasChildren = hasChildren_;
            this.allChildrenSelected = allChildrenSelected_;
        }
    }
}

