/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.config.ConfigHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ComponentUtils {
    public static void wrapPanelsIntoASplitPane(Component panel1, Component panel2, String id, boolean vertical) {
        ComponentUtils.wrapPanelsIntoASplitPane(panel1, panel2, id, vertical, true);
    }

    public static void wrapPanelsIntoASplitPane(Component panel1, Component panel2, String id, boolean vertical, boolean removeSplitPaneBorder) {
        Component cmp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Container parentComponent = panel1.getParent();
        if (parentComponent == null) {
            throw new IllegalArgumentException("Parent component cannot be null");
        }
        JSplitPane jp = new JSplitPane(vertical ? 0 : 1, panel1, panel2);
        jp.setName("wrapped splitpane");
        jp.resetToPreferredSizes();
        jp.setPreferredSize(new Dimension(200, 300));
        jp.setResizeWeight(0.5);
        jp.setDividerLocation(ConfigHandler.getConfig().getNumberConfigValue("viewConfig.mainSplitDividerLocation_" + id, -1).intValue());
        jp.addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("dividerLocation")) {
                ConfigHandler.getConfig().setConfigValue("viewConfig.mainSplitDividerLocation_" + id, evt.getNewValue());
                ConfigHandler.saveInBackground();
            }
        });
        if (removeSplitPaneBorder) {
            jp.setBorder(BorderFactory.createEmptyBorder());
        }
        jp.revalidate();
        parentComponent.add((Component)jp, "Center");
        panel1.revalidate();
        panel2.revalidate();
        parentComponent.revalidate();
        parentComponent.repaint();
        if (cmp != null) {
            if (SwingUtilities.getWindowAncestor(cmp) == SwingUtilities.getWindowAncestor(panel1)) {
                cmp.requestFocusInWindow();
            } else {
                System.err.println("Component: " + cmp + " is not part of correct window hierarchy");
            }
        }
    }

    public static void unwrapPanelsFromASplitPane(Component panel1) {
        Container parentComponent = panel1.getParent();
        if (!(parentComponent instanceof JSplitPane)) {
            throw new IllegalArgumentException("Panel " + panel1 + " isn't wrapped in a JSplitPane");
        }
        Component cmp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Container splitParent = parentComponent.getParent();
        splitParent.remove(parentComponent);
        if (splitParent.getLayout() instanceof BorderLayout) {
            splitParent.add(panel1, "Center");
        } else {
            splitParent.add(panel1);
        }
        splitParent.revalidate();
        splitParent.repaint();
        if (cmp != null && SwingUtilities.getWindowAncestor(cmp) != SwingUtilities.getWindowAncestor(panel1)) {
            System.err.println("Component: " + cmp + " is not part of correct window hierarchy, ancestor: " + SwingUtilities.getWindowAncestor(cmp));
        }
    }

    public static void enableFocusLogging() {
        Logger focusLog = Logger.getLogger("java.awt.focus.Component");
        ConsoleHandler handler = new ConsoleHandler();
        focusLog.setLevel(Level.ALL);
        handler.setLevel(Level.ALL);
        focusLog.addHandler(handler);
    }

    public static void removeTravelsalForComponent(JComponent c, boolean traversalKeys) {
        ComponentUtils.removeKeyFromMap(c.getInputMap(), KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ComponentUtils.removeKeyFromMap(c.getInputMap(), KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        ComponentUtils.removeKeyFromMap(c.getInputMap(2), KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ComponentUtils.removeKeyFromMap(c.getInputMap(2), KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        ComponentUtils.removeKeyFromMap(c.getInputMap(1), KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ComponentUtils.removeKeyFromMap(c.getInputMap(1), KeyStroke.getKeyStroke(9, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        ComponentUtils.removeKeyFromMap(c.getInputMap(2), KeyStroke.getKeyStroke(112, 512));
        ComponentUtils.removeKeyFromMap(c.getInputMap(1), KeyStroke.getKeyStroke(112, 512));
        ComponentUtils.removeKeyFromMap(c.getInputMap(2), KeyStroke.getKeyStroke(112, 128));
        ComponentUtils.removeKeyFromMap(c.getInputMap(1), KeyStroke.getKeyStroke(112, 128));
        ComponentUtils.removeKeyFromMap(c.getInputMap(2), KeyStroke.getKeyStroke(113, 512));
        ComponentUtils.removeKeyFromMap(c.getInputMap(1), KeyStroke.getKeyStroke(113, 512));
        if (traversalKeys) {
            c.setFocusTraversalKeysEnabled(false);
            c.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            c.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        }
    }

    public static void removeKeyFromMap(InputMap map, KeyStroke ks) {
        map.remove(ks);
        InputMap p = map.getParent();
        if (p != null) {
            ComponentUtils.removeKeyFromMap(p, ks);
        }
    }
}

