/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.view.tabs.ColorLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonTabComponent
extends JPanel {
    private final JTabbedPane pane;
    private final JLabel label;
    private final Consumer<Integer> holder;

    public ButtonTabComponent(JTabbedPane pane, JLabel label, Consumer<Integer> tabCloser) {
        super(new FlowLayout(0, 0, 0));
        this.label = label;
        this.holder = tabCloser;
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        TabButton button = new TabButton();
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
    }

    public Color getLabelBackground() {
        if (this.label instanceof ColorLabel) {
            return ((ColorLabel)this.label).getColor();
        }
        return null;
    }

    public void setLabelBackground(Color c) {
        if (this.label instanceof ColorLabel) {
            ((ColorLabel)this.label).setColor(c);
        }
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 15;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(true);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 2) {
                        TabButton.this.closeTab();
                        e.consume();
                    } else {
                        super.mousePressed(e);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(false);
                    }
                }
            });
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.closeTab();
        }

        private void closeTab() {
            int i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (i != -1) {
                ButtonTabComponent.this.holder.accept(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.RED);
            }
            int delta = 4;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

