/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.changedb;

import com.sigge.filerunner.core.HighlightingFilter;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.core.DatabaseUtils;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DatabaseListRenderer
implements ListCellRenderer<ServerDatabase> {
    protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private final Supplier<String> filterSupplier;

    public DatabaseListRenderer(Supplier<String> filterSupplier) {
        this.filterSupplier = filterSupplier;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ServerDatabase> list, ServerDatabase value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        renderer.setFont(list.getFont());
        if (value != null) {
            StringBuilder sb = new StringBuilder("<html><body style='font-family: Verdana; font-size: 10px;'>&nbsp;");
            sb.append(DatabaseUtils.getColorBlob((DatabaseFromConfig)value.getDb()));
            String database = value.getDatabase();
            if (this.filterSupplier.get().length() > 0) {
                database = new HighlightingFilter(this.filterSupplier.get()).highlight(database);
            }
            sb.append(database);
            if (value.getDb() != null) {
                sb.append(" <font color=blue>").append(value.getDb().getLabel()).append("</font>");
            }
            sb.append("</body></html>");
            renderer.setText(sb.toString());
        }
        return renderer;
    }
}

