/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity.sqlserver;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.sql.ResultsetConsumer;
import com.sigge.filerunner.sql.sqlserver.SQLServerDatabaseContext;
import com.sigge.filerunner.view.activity.Activity;
import com.sigge.filerunner.view.activity.ActivityHandler;
import com.sigge.filerunner.view.activity.ActivityStatus;
import com.sigge.filerunner.view.activity.IRunner;
import com.sigge.filerunner.view.activity.sqlserver.SQLServerActivity;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerMonitorer
implements IRunner {
    private SQLOptions options = this.createSQLOptions();
    public static final String PROGRESS_XML = "PROGRESS_XML";
    public static final String TRANSACTION_ID = "TRANSACTION_ID";
    private Database db;
    private IScriptRunner runner;
    private IScriptRunner stopRunner;
    private boolean isRunning;
    protected boolean closed = false;
    private final String query = this.readQueryString("sqlserver.query");
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerMonitorer.class);
    private boolean lastError = false;

    public SQLServerMonitorer(Database db) {
        this.db = db;
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public void getActivities(Consumer<List<Activity>> consumer) {
        if (this.isRunning) {
            return;
        }
        try {
            try {
                this.options = this.createSQLOptions();
                this.runSQL(this.query, (rs, result) -> consumer.accept(this.processSQL(rs, result)), this.options);
            }
            catch (Exception ex) {
                if (!SQLServerDatabaseContext.isTransientError(ex)) {
                    LOGGER.error("Error while running: " + this.db, (Throwable)ex);
                }
                this.isRunning = false;
            }
        }
        finally {
            this.isRunning = false;
        }
    }

    private String readQueryString(String string) {
        try {
            return FileUtils.streamContents(ActivityHandler.class.getResourceAsStream(string), "UTF8");
        }
        catch (Exception e) {
            LOGGER.error("Error while loading:" + string, (Throwable)e);
            return "";
        }
    }

    List<Activity> processSQL(ResultSet rs, int result) throws SQLException {
        ArrayList<Activity> acs = new ArrayList<Activity>();
        while (rs.next()) {
            String dbName = rs.getString("dbname");
            String objectName = rs.getString("objname");
            String statement = rs.getString("SQLStatement");
            String session_id = String.valueOf(rs.getInt("Session_id"));
            String blockedBy = rs.getString("BlockedBy");
            String loginName = rs.getString("Login");
            long elapsedMs = rs.getLong("ElapsedMS");
            long connectionWrites = rs.getLong("ConnectionWrites");
            long connectionReads = rs.getLong("ConnectionReads");
            Float completedPercent = Float.valueOf(rs.getFloat("Completed"));
            if (rs.wasNull()) {
                completedPercent = null;
            }
            String progressXML = rs.getString("ProgressXML");
            Integer status = rs.getInt("requestStatus");
            if (rs.wasNull()) {
                status = null;
            }
            SQLServerActivity ac = new SQLServerActivity(this.db, session_id, statement, dbName, objectName, loginName, elapsedMs, connectionReads, connectionWrites, blockedBy){

                @Override
                public boolean isSameQueryForQueryPlan(Activity ac) {
                    if (ac.getServer().equals(this.getServer()) && ac.getId().equals(this.getId())) {
                        return Objects.equals(ac.getExtraFields().get(SQLServerMonitorer.TRANSACTION_ID), this.getExtraFields().get(SQLServerMonitorer.TRANSACTION_ID));
                    }
                    return false;
                }
            };
            ac.setStatus(status == null || status.equals(0) ? ActivityStatus.IDLE : ActivityStatus.RUNNING);
            Long transaction_id = rs.getLong("transaction_id");
            if (!rs.wasNull()) {
                ac.getExtraFields().put(TRANSACTION_ID, transaction_id);
            }
            ac.setCompleted(completedPercent);
            ac.getExtraFields().put(PROGRESS_XML, progressXML);
            ac.getExtraFields().put("APPLICATION", rs.getString("ProgramName"));
            Integer openTransactions = rs.getInt("open_transaction_count");
            if (rs.wasNull()) {
                openTransactions = null;
            }
            ac.getExtraFields().put("OPEN_TRANSACTIONS", openTransactions);
            ac.setQueryPlan(rs.getString("QueryPlan"));
            acs.add(ac);
        }
        rs.close();
        return acs;
    }

    @Override
    public void close() {
        this.closed = true;
        this.options.cancel();
        if (this.runner != null) {
            this.runner.closeConnection();
        }
    }

    public synchronized void runSQL(String sql, final ResultsetConsumer resultConsumer, SQLOptions so) throws SQLException, Exception {
        this.isRunning = true;
        if (this.runner == null || this.runner.getConnection().isClosed() || this.lastError && !this.runner.isAlive()) {
            if (this.runner != null) {
                this.runner.closeConnection();
            }
            try {
                this.runner = this.createRunner();
            }
            catch (Exception ex) {
                this.isRunning = false;
                this.options.cancel();
                if (this.runner != null) {
                    this.runner.closeConnection();
                }
                this.runner = null;
                throw ex;
            }
        }
        this.lastError = false;
        this.runner.runScript(new StringReader(sql), Arrays.asList(new ProgressReportedAdaptor(){
            int prevResults = 0;

            @Override
            public void reportScriptFailure(String command, Statement s, Exception e, boolean result) {
                if (!SQLServerMonitorer.this.closed) {
                    if (!SQLServerDatabaseContext.isTransientError(e)) {
                        LOGGER.error("Running script in {}: {} failed with {}", new Object[]{SQLServerMonitorer.this.db, command, e});
                    }
                    SQLServerMonitorer.this.lastError = true;
                }
                SQLServerMonitorer.this.isRunning = false;
            }

            @Override
            public void reportScriptFinished(String command, Statement s, boolean result) {
                try {
                    try {
                        this.prevResults += SQLServerMonitorer.this.processStatement(s, resultConsumer, this.prevResults);
                    }
                    catch (Exception ex) {
                        if (!SQLServerMonitorer.this.closed && !SQLServerDatabaseContext.isTransientError(ex)) {
                            LOGGER.error("Processing statement in {} from command {} failed with exception {}", new Object[]{SQLServerMonitorer.this.db, command, ex});
                        }
                        SQLServerMonitorer.this.isRunning = false;
                    }
                }
                finally {
                    SQLServerMonitorer.this.isRunning = false;
                }
            }
        }), so);
    }

    private IScriptRunner createRunner() throws SQLException {
        return this.db.createRunner("", null);
    }

    protected int processStatement(Statement s, ResultsetConsumer resultConsumer, int prevResults) throws SQLException {
        int resultSets = 0;
        while (true) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ResultSet r = s.getResultSet();){
                if (r == null) {
                    int updateCount = s.getUpdateCount();
                    if (updateCount == -1) break;
                    s.getMoreResults();
                    continue;
                }
                resultConsumer.consume(r, ++resultSets + prevResults);
                s.getMoreResults();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return resultSets;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public synchronized void stopActivity(Activity activity) {
        try {
            if (this.stopRunner == null || !this.stopRunner.isAlive()) {
                if (this.stopRunner != null) {
                    this.stopRunner.closeConnection();
                }
                this.stopRunner = this.createRunner();
            }
            this.stopRunner.runScript(new StringReader("KILL " + activity.getId()), Arrays.asList(new ProgressReportedAdaptor()), new SQLOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error occured while stopping task: " + activity.getId() + ": " + e.getMessage());
        }
    }

    private SQLOptions createSQLOptions() {
        return new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).timeout(240).build();
    }
}

