/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.view.activity.ActivityProcess;
import com.sigge.filerunner.view.activity.ActivityStatus;
import com.sigge.filerunner.view.activity.ActivityTableModel;
import com.sigge.filerunner.view.core.DatabaseUtils;
import com.sigge.filerunner.view.core.VTableCellRenderer;
import java.awt.Color;
import java.math.BigDecimal;
import javax.swing.JLabel;
import javax.swing.JTable;

final class ActivityTableRenderer
extends VTableCellRenderer {
    private final int counter;

    ActivityTableRenderer(int counter) {
        this.counter = counter;
        if (counter == 0) {
            this.putClientProperty("html.disable", Boolean.FALSE);
        }
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ActivityTableModel at = (ActivityTableModel)((Object)table.getModel());
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ActivityProcess ap = (ActivityProcess)at.getValueAt(table.convertRowIndexToModel(row));
        if (ap != null) {
            if (ap.isQuarantine()) {
                if (!isSelected) {
                    this.setBackground(new Color(250, 255, 214));
                }
                this.setFont(this.getFont().deriveFont(2));
            }
            if (!isSelected && ap.getActivity().getStatus() == ActivityStatus.IDLE && this.counter == 3) {
                this.setForeground(Color.GRAY);
            }
            switch (this.counter) {
                case 0: {
                    Database db = ap.getActivity().getServer();
                    String server = value != null ? value.toString().replaceAll("\\s+", " ") : "";
                    String blob = DatabaseUtils.getColorBlob(db);
                    if (blob != null && !blob.isEmpty()) {
                        server = "<html>" + blob + server + "</html>";
                    }
                    this.setText(server);
                    return this;
                }
                case 8: {
                    Number durationMs = (Number)value;
                    if (durationMs == null) break;
                    this.setText(DateUtils.getDuration(durationMs.intValue()));
                    return this;
                }
                case 12: {
                    Number count = (Number)value;
                    if (count != null && count.intValue() > 0) {
                        this.setForeground(Color.red);
                    }
                    return this;
                }
            }
        }
        if (value instanceof String && ((String)value).length() > 100000) {
            this.setText(((String)value).substring(0, 99997).replaceAll("\\s+", " "));
        } else if (value != null) {
            if (value instanceof Double) {
                if ((Double)value % 1.0 == 0.0) {
                    this.setText(String.format("%.0f", value));
                } else {
                    this.setText(BigDecimal.valueOf((Double)value).toPlainString());
                }
            }
            this.setText(value.toString().replaceAll("\\s+", " "));
        }
        return this;
    }

    @Override
    public String getToolTipText() {
        return null;
    }
}

